/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BASKETFACTORY_H
#define BASKETFACTORY_H

#include <qptrlist.h>

class QString;
class KService;

/** Methods to create various baskets (mkdir, init the properties and load it).
  * @author Sbastien Laot
  */
namespace BasketFactory
{
	enum BasketType { Clips = 0, Checklist, Stack, Mirror, Launcher, Clipboard };
	/** Create and load basket templates :
	 * - Create and initialize a basket directory on hard drive
	 *   and return the folderName that should be loaded
	 *   (e.g. by Container::loadBasket()).
	 * - folder parameter is needed for KNoteBookManager that integrate a basket
	 *   as annotations for each notes. BasKet in itself shouldn't use it.
	 */
	QString createBasketClips(     const QString &name = "", const QString &folderName = "" );
	QString createBasketChecks(    const QString &name = "", const QString &folderName = "" );
	QString createBasketStack(     bool takeOnSameSide = true, int afterDrag = 2, const QString &name = "",
	                                                         const QString &folderName = "" );
	QString createBasketMirror(    bool onlyNewFiles, bool reload = false, const QString &name = "",
	                                                         const QString &folderName = "" );
//	void createBasketLaunchers( const QString &name = "", QPtrList<KService> applications = QPtrList<KService> );
	QString createBasketClipboard( const QString &name = "", const QString &folderName = "" );
	void reloadAMirrorBasket(   const QString &folderName );
	/** Needed methods for baskets creation or for the New basket wizard : */
	QString newFolderName();
	QString newBasketName(  BasketType basketType, const QString &wantedName = "", const QString &folderName = "" );
	QString newBasketName(  const QString &baseName, const QString &templateName, const QString &wantedName = "" );
	bool isAlreadyAClipboard();
	bool isAlreadyMirrored( const QString &folderName );
	bool isAlreadyNamed(    const QString &basketName );
	QString makeBasketDir(  const QString &properties, const QString &folderName = "" );

	// General purpose functions:
	QString escapeXML(QString text);
}

#endif // BASKETFACTORY_H
