/*
    This program can be distributed under the terms of the GNU GPL.
    See the file COPYING.

    Author: Martin Prtel <martin.partel@gmail.com>
*/

#ifndef INC_BINDFS_USERINFO_H
#define INC_BINDFS_USERINFO_H

#include <config.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#include <pwd.h>
#include <grp.h>

/* Misc. reentrant helpers for handling user data.
   Return non-zero on success/true and 0 on failure/false. */

int user_uid(const char *username, uid_t *ret);
int group_gid(const char *groupname, gid_t *ret);

int user_belongs_to_group(uid_t uid, gid_t gid);

#endif
