/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sun Jul  2 15:50:22 EDT 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 9 -dit -name hf_9 -include hf.h */

/*
 * This function contains 96 FP additions, 88 FP multiplications,
 * (or, 24 additions, 16 multiplications, 72 fused multiply/add),
 * 75 stack variables, and 36 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf_9(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP777861913, +0.777861913430206160028177977318626690410586096);
     DK(KP852868531, +0.852868531952443209628250963940074071936020296);
     DK(KP839099631, +0.839099631177280011763127298123181364687434283);
     DK(KP492403876, +0.492403876506104029683371512294761506835321626);
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP954188894, +0.954188894138671133499268364187245676532219158);
     DK(KP363970234, +0.363970234266202361351047882776834043890471784);
     DK(KP176326980, +0.176326980708464973471090386868618986121633062);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 16, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1K, T20, T1H, T1Z;
	  {
	       E T1, T1R, T10, T1Q, Te, T1W, Th, Tk, T1l, T1r, T1q, T1N, Ti, T1g, TT;
	       E T12, Tn, Tq, Tp, T17, Tx, T14, To, Tj;
	       {
		    E T9, Tc, TY, Ta, Tb, TX, T7, TZ, Td;
		    T1 = rio[0];
		    {
			 E T3, T6, T8, TW, T4, T2, T5;
			 T3 = rio[WS(ios, 3)];
			 T6 = iio[-WS(ios, 5)];
			 T2 = W[4];
			 T9 = rio[WS(ios, 6)];
			 Tc = iio[-WS(ios, 2)];
			 T8 = W[10];
			 TW = T2 * T6;
			 T4 = T2 * T3;
			 T5 = W[5];
			 TY = T8 * Tc;
			 Ta = T8 * T9;
			 Tb = W[11];
			 TX = FNMS(T5, T3, TW);
			 T7 = FMA(T5, T6, T4);
		    }
		    T1R = iio[-WS(ios, 8)];
		    TZ = FNMS(Tb, T9, TY);
		    Td = FMA(Tb, Tc, Ta);
		    {
			 E TB, TE, T1n, TC, TH, TK, T1k, TR, TG, TJ, TD, TA;
			 TB = rio[WS(ios, 2)];
			 TE = iio[-WS(ios, 6)];
			 T10 = TX - TZ;
			 T1Q = TX + TZ;
			 Te = T7 + Td;
			 T1W = Td - T7;
			 TA = W[2];
			 {
			      E TN, TQ, TP, T1j, TO, TM;
			      TN = rio[WS(ios, 8)];
			      TQ = iio[0];
			      TM = W[14];
			      T1n = TA * TE;
			      TC = TA * TB;
			      TP = W[15];
			      T1j = TM * TQ;
			      TO = TM * TN;
			      TH = rio[WS(ios, 5)];
			      TK = iio[-WS(ios, 3)];
			      T1k = FNMS(TP, TN, T1j);
			      TR = FMA(TP, TQ, TO);
			      TG = W[8];
			      TJ = W[9];
			 }
			 TD = W[3];
			 {
			      E T1o, TF, T1i, TL, T1h, TI, Tg, T1p, TS;
			      Th = rio[WS(ios, 1)];
			      T1h = TG * TK;
			      TI = TG * TH;
			      T1o = FNMS(TD, TB, T1n);
			      TF = FMA(TD, TE, TC);
			      T1i = FNMS(TJ, TH, T1h);
			      TL = FMA(TJ, TK, TI);
			      Tk = iio[-WS(ios, 7)];
			      Tg = W[0];
			      T1p = T1i + T1k;
			      T1l = T1i - T1k;
			      TS = TL + TR;
			      T1r = TR - TL;
			      T1q = FNMS(KP500000000, T1p, T1o);
			      T1N = T1o + T1p;
			      Ti = Tg * Th;
			      T1g = FNMS(KP500000000, TS, TF);
			      TT = TF + TS;
			      T12 = Tg * Tk;
			 }
			 {
			      E Tt, Tw, Ts, Tv, T16, Tu, Tm;
			      Tt = rio[WS(ios, 7)];
			      Tw = iio[-WS(ios, 1)];
			      Ts = W[12];
			      Tv = W[13];
			      Tn = rio[WS(ios, 4)];
			      Tq = iio[-WS(ios, 4)];
			      T16 = Ts * Tw;
			      Tu = Ts * Tt;
			      Tm = W[6];
			      Tp = W[7];
			      T17 = FNMS(Tv, Tt, T16);
			      Tx = FMA(Tv, Tw, Tu);
			      T14 = Tm * Tq;
			      To = Tm * Tn;
			 }
			 Tj = W[1];
		    }
	       }
	       {
		    E TV, Tf, T1d, T1a, T19, T1M, T1V, T1S, T1c, Tz, Tl, Ty;
		    TV = FNMS(KP500000000, Te, T1);
		    Tf = T1 + Te;
		    {
			 E T15, Tr, T13, T18;
			 T15 = FNMS(Tp, Tn, T14);
			 Tr = FMA(Tp, Tq, To);
			 T13 = FNMS(Tj, Th, T12);
			 Tl = FMA(Tj, Tk, Ti);
			 T18 = T15 + T17;
			 T1d = T15 - T17;
			 Ty = Tr + Tx;
			 T1a = Tr - Tx;
			 T19 = FNMS(KP500000000, T18, T13);
			 T1M = T13 + T18;
			 T1V = FNMS(KP500000000, T1Q, T1R);
			 T1S = T1Q + T1R;
		    }
		    T1c = FNMS(KP500000000, Ty, Tl);
		    Tz = Tl + Ty;
		    {
			 E T11, T1z, T1E, T1D, T21, T1X, T1I, T1C, T22, T1y, T24, T1u, T1U, TU;
			 T1U = TT - Tz;
			 TU = Tz + TT;
			 {
			      E T1P, T1O, T1L, T1T;
			      T1P = T1M + T1N;
			      T1O = T1M - T1N;
			      T11 = FNMS(KP866025403, T10, TV);
			      T1z = FMA(KP866025403, T10, TV);
			      T1L = FNMS(KP500000000, TU, Tf);
			      rio[0] = Tf + TU;
			      T1T = FNMS(KP500000000, T1P, T1S);
			      iio[0] = T1P + T1S;
			      rio[WS(ios, 3)] = FMA(KP866025403, T1O, T1L);
			      iio[-WS(ios, 6)] = FNMS(KP866025403, T1O, T1L);
			      iio[-WS(ios, 3)] = FMA(KP866025403, T1U, T1T);
			      rio[WS(ios, 6)] = FMS(KP866025403, T1U, T1T);
			 }
			 {
			      E T1B, T1m, T1w, T1f, T1s, T1A, T1b, T1e, T1x, T1t;
			      T1E = FNMS(KP866025403, T1a, T19);
			      T1b = FMA(KP866025403, T1a, T19);
			      T1e = FNMS(KP866025403, T1d, T1c);
			      T1D = FMA(KP866025403, T1d, T1c);
			      T1B = FMA(KP866025403, T1l, T1g);
			      T1m = FNMS(KP866025403, T1l, T1g);
			      T21 = FNMS(KP866025403, T1W, T1V);
			      T1X = FMA(KP866025403, T1W, T1V);
			      T1w = FNMS(KP176326980, T1b, T1e);
			      T1f = FMA(KP176326980, T1e, T1b);
			      T1s = FNMS(KP866025403, T1r, T1q);
			      T1A = FMA(KP866025403, T1r, T1q);
			      T1x = FMA(KP363970234, T1m, T1s);
			      T1t = FNMS(KP363970234, T1s, T1m);
			      T1I = FNMS(KP176326980, T1A, T1B);
			      T1C = FMA(KP176326980, T1B, T1A);
			      T22 = FMA(KP954188894, T1x, T1w);
			      T1y = FNMS(KP954188894, T1x, T1w);
			      T24 = FMA(KP954188894, T1t, T1f);
			      T1u = FNMS(KP954188894, T1t, T1f);
			 }
			 {
			      E T1Y, T1G, T23, T1F, T1J, T1v;
			      iio[-WS(ios, 2)] = FNMS(KP984807753, T22, T21);
			      T1v = FNMS(KP492403876, T1u, T11);
			      rio[WS(ios, 2)] = FMA(KP984807753, T1u, T11);
			      T1F = FMA(KP839099631, T1E, T1D);
			      T1J = FNMS(KP839099631, T1D, T1E);
			      iio[-WS(ios, 5)] = FNMS(KP852868531, T1y, T1v);
			      iio[-WS(ios, 8)] = FMA(KP852868531, T1y, T1v);
			      T1K = FMA(KP777861913, T1J, T1I);
			      T1Y = FNMS(KP777861913, T1J, T1I);
			      T1G = FMA(KP777861913, T1F, T1C);
			      T20 = FNMS(KP777861913, T1F, T1C);
			      T23 = FMA(KP492403876, T22, T21);
			      iio[-WS(ios, 1)] = FNMS(KP984807753, T1Y, T1X);
			      rio[WS(ios, 1)] = FMA(KP984807753, T1G, T1z);
			      T1H = FNMS(KP492403876, T1G, T1z);
			      rio[WS(ios, 8)] = -(FMA(KP852868531, T24, T23));
			      rio[WS(ios, 5)] = FMS(KP852868531, T24, T23);
			      T1Z = FMA(KP492403876, T1Y, T1X);
			 }
		    }
	       }
	  }
	  iio[-WS(ios, 7)] = FNMS(KP852868531, T1K, T1H);
	  rio[WS(ios, 4)] = FMA(KP852868531, T1K, T1H);
	  iio[-WS(ios, 4)] = FMA(KP852868531, T20, T1Z);
	  rio[WS(ios, 7)] = FMS(KP852868531, T20, T1Z);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 9},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 9, "hf_9", twinstr, &GENUS, {24, 16, 72, 0}, 0, 0, 0 };

void X(codelet_hf_9) (planner *p) {
     X(khc2hc_register) (p, hf_9, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -n 9 -dit -name hf_9 -include hf.h */

/*
 * This function contains 96 FP additions, 72 FP multiplications,
 * (or, 60 additions, 36 multiplications, 36 fused multiply/add),
 * 41 stack variables, and 36 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hf.h"

static const R *hf_9(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP939692620, +0.939692620785908384054109277324731469936208134);
     DK(KP342020143, +0.342020143325668733044099614682259580763083368);
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 16, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1, T1B, TQ, T1G, Tc, TN, T1A, T1H, TL, T1x, T17, T1o, T1c, T1n, Tu;
	  E T1w, TW, T1k, T11, T1l;
	  {
	       E T6, TO, Tb, TP;
	       T1 = rio[0];
	       T1B = iio[-WS(ios, 8)];
	       {
		    E T3, T5, T2, T4;
		    T3 = rio[WS(ios, 3)];
		    T5 = iio[-WS(ios, 5)];
		    T2 = W[4];
		    T4 = W[5];
		    T6 = FMA(T2, T3, T4 * T5);
		    TO = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E T8, Ta, T7, T9;
		    T8 = rio[WS(ios, 6)];
		    Ta = iio[-WS(ios, 2)];
		    T7 = W[10];
		    T9 = W[11];
		    Tb = FMA(T7, T8, T9 * Ta);
		    TP = FNMS(T9, T8, T7 * Ta);
	       }
	       TQ = KP866025403 * (TO - TP);
	       T1G = KP866025403 * (Tb - T6);
	       Tc = T6 + Tb;
	       TN = FNMS(KP500000000, Tc, T1);
	       T1A = TO + TP;
	       T1H = FNMS(KP500000000, T1A, T1B);
	  }
	  {
	       E Tz, T19, TE, T14, TJ, T15, TK, T1a;
	       {
		    E Tw, Ty, Tv, Tx;
		    Tw = rio[WS(ios, 2)];
		    Ty = iio[-WS(ios, 6)];
		    Tv = W[2];
		    Tx = W[3];
		    Tz = FMA(Tv, Tw, Tx * Ty);
		    T19 = FNMS(Tx, Tw, Tv * Ty);
	       }
	       {
		    E TB, TD, TA, TC;
		    TB = rio[WS(ios, 5)];
		    TD = iio[-WS(ios, 3)];
		    TA = W[8];
		    TC = W[9];
		    TE = FMA(TA, TB, TC * TD);
		    T14 = FNMS(TC, TB, TA * TD);
	       }
	       {
		    E TG, TI, TF, TH;
		    TG = rio[WS(ios, 8)];
		    TI = iio[0];
		    TF = W[14];
		    TH = W[15];
		    TJ = FMA(TF, TG, TH * TI);
		    T15 = FNMS(TH, TG, TF * TI);
	       }
	       TK = TE + TJ;
	       T1a = T14 + T15;
	       TL = Tz + TK;
	       T1x = T19 + T1a;
	       {
		    E T13, T16, T18, T1b;
		    T13 = FNMS(KP500000000, TK, Tz);
		    T16 = KP866025403 * (T14 - T15);
		    T17 = T13 + T16;
		    T1o = T13 - T16;
		    T18 = KP866025403 * (TJ - TE);
		    T1b = FNMS(KP500000000, T1a, T19);
		    T1c = T18 + T1b;
		    T1n = T1b - T18;
	       }
	  }
	  {
	       E Ti, TY, Tn, TT, Ts, TU, Tt, TZ;
	       {
		    E Tf, Th, Te, Tg;
		    Tf = rio[WS(ios, 1)];
		    Th = iio[-WS(ios, 7)];
		    Te = W[0];
		    Tg = W[1];
		    Ti = FMA(Te, Tf, Tg * Th);
		    TY = FNMS(Tg, Tf, Te * Th);
	       }
	       {
		    E Tk, Tm, Tj, Tl;
		    Tk = rio[WS(ios, 4)];
		    Tm = iio[-WS(ios, 4)];
		    Tj = W[6];
		    Tl = W[7];
		    Tn = FMA(Tj, Tk, Tl * Tm);
		    TT = FNMS(Tl, Tk, Tj * Tm);
	       }
	       {
		    E Tp, Tr, To, Tq;
		    Tp = rio[WS(ios, 7)];
		    Tr = iio[-WS(ios, 1)];
		    To = W[12];
		    Tq = W[13];
		    Ts = FMA(To, Tp, Tq * Tr);
		    TU = FNMS(Tq, Tp, To * Tr);
	       }
	       Tt = Tn + Ts;
	       TZ = TT + TU;
	       Tu = Ti + Tt;
	       T1w = TY + TZ;
	       {
		    E TS, TV, TX, T10;
		    TS = FNMS(KP500000000, Tt, Ti);
		    TV = KP866025403 * (TT - TU);
		    TW = TS + TV;
		    T1k = TS - TV;
		    TX = KP866025403 * (Ts - Tn);
		    T10 = FNMS(KP500000000, TZ, TY);
		    T11 = TX + T10;
		    T1l = T10 - TX;
	       }
	  }
	  {
	       E T1y, Td, TM, T1v;
	       T1y = KP866025403 * (T1w - T1x);
	       Td = T1 + Tc;
	       TM = Tu + TL;
	       T1v = FNMS(KP500000000, TM, Td);
	       rio[0] = Td + TM;
	       rio[WS(ios, 3)] = T1v + T1y;
	       iio[-WS(ios, 6)] = T1v - T1y;
	  }
	  {
	       E T1D, T1z, T1C, T1E;
	       T1D = KP866025403 * (TL - Tu);
	       T1z = T1w + T1x;
	       T1C = T1A + T1B;
	       T1E = FNMS(KP500000000, T1z, T1C);
	       iio[0] = T1z + T1C;
	       iio[-WS(ios, 3)] = T1D + T1E;
	       rio[WS(ios, 6)] = T1D - T1E;
	  }
	  {
	       E TR, T1I, T1e, T1J, T1i, T1F, T1f, T1K;
	       TR = TN + TQ;
	       T1I = T1G + T1H;
	       {
		    E T12, T1d, T1g, T1h;
		    T12 = FMA(KP766044443, TW, KP642787609 * T11);
		    T1d = FMA(KP173648177, T17, KP984807753 * T1c);
		    T1e = T12 + T1d;
		    T1J = KP866025403 * (T1d - T12);
		    T1g = FNMS(KP642787609, TW, KP766044443 * T11);
		    T1h = FNMS(KP984807753, T17, KP173648177 * T1c);
		    T1i = KP866025403 * (T1g - T1h);
		    T1F = T1g + T1h;
	       }
	       rio[WS(ios, 1)] = TR + T1e;
	       iio[-WS(ios, 1)] = T1F + T1I;
	       T1f = FNMS(KP500000000, T1e, TR);
	       iio[-WS(ios, 7)] = T1f - T1i;
	       rio[WS(ios, 4)] = T1f + T1i;
	       T1K = FNMS(KP500000000, T1F, T1I);
	       rio[WS(ios, 7)] = T1J - T1K;
	       iio[-WS(ios, 4)] = T1J + T1K;
	  }
	  {
	       E T1j, T1M, T1q, T1O, T1u, T1L, T1r, T1N;
	       T1j = TN - TQ;
	       T1M = T1H - T1G;
	       {
		    E T1m, T1p, T1s, T1t;
		    T1m = FMA(KP173648177, T1k, KP984807753 * T1l);
		    T1p = FNMS(KP939692620, T1o, KP342020143 * T1n);
		    T1q = T1m + T1p;
		    T1O = KP866025403 * (T1p - T1m);
		    T1s = FNMS(KP984807753, T1k, KP173648177 * T1l);
		    T1t = FMA(KP342020143, T1o, KP939692620 * T1n);
		    T1u = KP866025403 * (T1s + T1t);
		    T1L = T1s - T1t;
	       }
	       rio[WS(ios, 2)] = T1j + T1q;
	       iio[-WS(ios, 2)] = T1L + T1M;
	       T1r = FNMS(KP500000000, T1q, T1j);
	       iio[-WS(ios, 8)] = T1r - T1u;
	       iio[-WS(ios, 5)] = T1r + T1u;
	       T1N = FMS(KP500000000, T1L, T1M);
	       rio[WS(ios, 5)] = T1N - T1O;
	       rio[WS(ios, 8)] = T1O + T1N;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 9},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 9, "hf_9", twinstr, &GENUS, {60, 36, 36, 0}, 0, 0, 0 };

void X(codelet_hf_9) (planner *p) {
     X(khc2hc_register) (p, hf_9, &desc);
}
#endif				/* HAVE_FMA */
