//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_GAIM_DBUS_HH
#define BMP_GAIM_DBUS_HH

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <vector>

#include <dbus/dbus-glib.h>
#include <dbus-gaim.h>

#include <gtkmm.h>
#include <gtk/gtkstock.h>
#include "stock.hh"

namespace Bmp
{
  namespace Gaim
  {
    class DBUS
    {
      public:

      typedef sigc::signal<void> SignalGaimLost;
      typedef sigc::signal<void> SignalGaimPresent;

#include "exception.hh"

        EXCEPTION(GaimDbusError)
        EXCEPTION(ConnectionError)

        struct Buddy
        {
          std::string   name;
          std::string   alias;
          std::string   protocol_name;
          std::string   protocol_id;
          int           account;
          int           connection;
          int           contact;
          int           icon;
        };

        static Gtk::StockID
        protocol_get_stock_icon_id (std::string const& protocol_id)
        {
          // FIXME: Automate this somehow

          if (protocol_id == "prpl-oscar")
                return Gtk::StockID (BMP_STOCK_GAIM_OSCAR);

          if (protocol_id == "prpl-gadu-gadu")
                return Gtk::StockID (BMP_STOCK_GAIM_GADU);

          if (protocol_id == "prpl-jabber")
                return Gtk::StockID (BMP_STOCK_GAIM_JABBER);

          if (protocol_id == "prpl-msn")
                return Gtk::StockID (BMP_STOCK_GAIM_MSN);

          if (protocol_id == "prpl-napster")
                return Gtk::StockID (BMP_STOCK_GAIM_NAPSTER);

          if (protocol_id == "prpl-yahoo")
                return Gtk::StockID (BMP_STOCK_GAIM_YAHOO);

          if (protocol_id == "prpl-zephyr")
                return Gtk::StockID (BMP_STOCK_GAIM_ZEPHYR);

          return Gtk::StockID (GTK_STOCK_NETWORK);
        }

        typedef std::vector < Buddy > OnlineBuddies;
      

        DBUS ();
        ~DBUS ();

        void get_online_buddies (OnlineBuddies &buddies);
        void send_file (Buddy const& buddy, std::string const& filename);
        bool gaim_is_present () const;

      private:

        SignalGaimLost    s_gaim_lost_;
        SignalGaimPresent s_gaim_present_;

      public:

        SignalGaimLost&
        signal_gaim_lost    () { return s_gaim_lost_; }

        SignalGaimPresent&
        signal_gaim_present () { return s_gaim_present_; }

      private:
  
        static void
        NameOwnerChanged (DBusGProxy *proxy, char *name, char *old_owner, char *new_owner, gpointer data);

        DBusGConnection *bus;
        DBusGProxy      *gaim;
        DBusGProxy      *fdobus;
        
    };
  } // namespace Gaim
} // namespace Bmp

#endif // BMP_GAIM_DBUS_HH

