//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#include <gtkmm.h>
#include "stock.hh"

#include <iostream>

namespace Bmp
{
  using namespace std;
  using namespace Glib;
  using namespace Gtk;
  using namespace Gdk;

  void
  register_stock_icons ()
  {
      RefPtr<Gtk::IconFactory> factory = IconFactory::create ();

      struct StockIconSpec
      {
        char* filename;
        char* stock_id;
      };

      StockIconSpec list[] =
      {   
          { "audio.png",                   BMP_STOCK_AUDIO            },
          { "bmp.png",                     BMP_STOCK_ABOUT            },
          { "cdrom.png",                   BMP_STOCK_CDDA             },
          { "library.png",                 BMP_STOCK_LIBRARY          },

#ifdef HAVE_MOOD
          { "museek.png",                  BMP_STOCK_MUSEEK,          },
#endif //HAVE_MOOD

          { "musicbrainz.png",             BMP_STOCK_MUSICBRAINZ      },
          { "playlist.png",                BMP_STOCK_PLAYLIST         },
          { "shoutcast.png",               BMP_STOCK_SHOUTCAST        },
          { "tag.png",                     BMP_STOCK_TAG              },
          { "xiph.png",                    BMP_STOCK_XIPH             },

          { "lastfm.png",                  BMP_STOCK_LASTFM           },
          { "lastfm-ban.png",              BMP_STOCK_LASTFM_BAN       },
          { "lastfm-love.png",             BMP_STOCK_LASTFM_LOVE      },
          { "lastfm-skip.png",             BMP_STOCK_LASTFM_SKIP      },
          { "lastfm.png",                  BMP_STOCK_LASTFM           },

          { "entry-clear.png",             BMP_STOCK_ENTRY_CLEAR      },

          { "approve-partial.png",         BMP_STOCK_APPROVE_PARTIAL  },
          { "approve.png",                 BMP_STOCK_APPROVE          },

          { "silk-feed.png",               BMP_STOCK_FEED             },
          { "silk-feed_add.png",           BMP_STOCK_FEED_ADD         },
          { "silk-feed_delete.png",        BMP_STOCK_FEED_DELETE      },
          { "silk-html.png",               BMP_STOCK_HTML_LINK        },
          { "silk-add.png",                BMP_STOCK_ADD              },
          { "silk-application_edit.png",   BMP_STOCK_PREFERENCES      },
          { "silk-attach.png",             BMP_STOCK_SELECTED         },
          { "silk-cart_put.png",           BMP_STOCK_DOWNLOAD         },
          { "silk-cd_edit.png",            BMP_STOCK_EDIT_ALBUM       },
          { "silk-cd_go.png",              BMP_STOCK_MOVE_ALBUM       },
          { "silk-cd_add.png",             BMP_STOCK_ADD_MUSIC        },
          { "silk-cd_delete.png",          BMP_STOCK_REMOVE_MUSIC     },
          { "silk-cog.png",                BMP_STOCK_SCAN             },
          { "silk-control_play_blue.png",  BMP_STOCK_MEDIA_PLAY       },
          { "silk-control_stop_blue.png",  BMP_STOCK_MEDIA_STOP       },
          { "silk-control_pause_blue.png", BMP_STOCK_MEDIA_PAUSE      },
          { "silk-delete.png",             BMP_STOCK_DELETE           },
          { "silk-drive.png",              BMP_STOCK_HARDDISK         },
          { "silk-exclamation.png" ,       BMP_STOCK_ERROR            },
          { "silk-folder_star.png" ,       BMP_STOCK_NEW_FILED        },
          { "silk-mod-server_down.png",    BMP_STOCK_XFER_DOWN        },
          { "silk-mod-server_up.png",      BMP_STOCK_XFER_UP          },
          { "silk-new.png",                BMP_STOCK_NEW              },
          { "silk-picture.png",            BMP_STOCK_VIEW             },
          { "silk-plugin.png",             BMP_STOCK_PLUGIN           },
          { "silk-plugin_disabled.png",    BMP_STOCK_PLUGIN_DISABLED  }, 
          { "silk-tag_blue_add.png",       BMP_STOCK_COLLECTION_ADD   },
          { "silk-tag_blue_delete.png",    BMP_STOCK_COLLECTION_DEL   },
        };

    for (unsigned int n = 0; n < G_N_ELEMENTS (list); ++n)
    {
      string filename = build_filename (DATA_DIR G_DIR_SEPARATOR_S "images" G_DIR_SEPARATOR_S "stock", list[n].filename);
      RefPtr<Pixbuf> pixbuf = Pixbuf::create_from_file (filename);
      factory->add (StockID (list[n].stock_id), IconSet(pixbuf));
    }

#ifdef HAVE_GAIM
      StockIconSpec list_gaim[] =
      {   { "oscar.png",          BMP_STOCK_GAIM_OSCAR       },
          { "gadu-gadu.png",      BMP_STOCK_GAIM_GADU        },
          { "jabber.png",         BMP_STOCK_GAIM_JABBER      },
          { "msn.png",            BMP_STOCK_GAIM_MSN         },
          { "napster.png",        BMP_STOCK_GAIM_NAPSTER     },
          { "yahoo.png",          BMP_STOCK_GAIM_YAHOO       },
          { "zephyr.png",         BMP_STOCK_GAIM_ZEPHYR      },
          { "gaim.png",           BMP_STOCK_GAIM             }, };

    for (unsigned int n = 0; n < G_N_ELEMENTS (list_gaim); ++n)
    {
      string filename = Glib::build_filename (DATA_DIR G_DIR_SEPARATOR_S "images" G_DIR_SEPARATOR_S "stock" G_DIR_SEPARATOR_S "gaim", list_gaim[n].filename);
      RefPtr<Gdk::Pixbuf> pixbuf = Pixbuf::create_from_file (filename);
      factory->add (StockID (list_gaim[n].stock_id), IconSet(pixbuf));
    }
#endif

    factory->add_default ();
  }
}
