//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_LASTFM_HH
#define BMP_UI_PART_LASTFM_HH

#include <gtkmm.h>
#include <libglademm.h>
#include <boost/optional.hpp>

#include "resizable.hh"

#include "playbacksource.hh"
#include "ui-part-base.hh"

#include "lastfm.hh"

namespace Bmp
{
  namespace UiPart
  {
    class LASTFM : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      public:

        LASTFM (Glib::RefPtr<Gnome::Glade::Xml> const&  xml,
                Glib::RefPtr<Gtk::UIManager>            ui_manager);
        ~LASTFM ();

        void set_uri (Glib::ustring const& uri);

      protected:

        virtual guint
        add_ui ();
       
        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type () { return Glib::ustring(); }

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();
  
        virtual void
        play ();

        virtual void
        play_requested () {}

        virtual void
        restore_context ();

        virtual GHashTable*
        get_metadata ();

     private:

        class CompletionRecord : public Gtk::TreeModel::ColumnRecord
        {
          public:
            Gtk::TreeModelColumn<Glib::ustring> text;
            CompletionRecord ()
            {
              add (text);
            }
        };

        class TreeViewStations : public Gtk::TreeView
        {
          public:

            typedef sigc::signal<void, Glib::ustring const&> StationActivated;

            TreeViewStations (BaseObjectType                       *cobject,
                              const Glib::RefPtr<Gnome::Glade::Xml> &xml);
            ~TreeViewStations ();

            StationActivated& 
            station_activated ()
            { return station_activated_; }

            void set_user (Glib::ustring const& user, bool subscriber);

          protected:

            virtual void on_row_activated
                (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn * column);

          private:

            void cell_data_func (Gtk::CellRenderer* cell, Gtk::TreeModel::iterator const& m_iter);

            enum RowType
            {
              ROW_MAINUSER,  
              ROW_STATION,  
              ROW_NEIGHBOUR_ROOT,
              ROW_NEIGHBOUR,
              ROW_FRIEND_ROOT,
              ROW_FRIEND,
              ROW_TAG_ROOT,
              ROW_TAG,
            };

            class Columns : public Gtk::TreeModel::ColumnRecord
            {
              public:

                Gtk::TreeModelColumn<Glib::ustring>              name;
                Gtk::TreeModelColumn<Glib::ustring>              station;
                Gtk::TreeModelColumn<RowType>                    type; 

                Columns ()
                {
                    add (name);
                    add (station);
                    add (type); 
                }
            };
            Columns columns;

            Glib::RefPtr<Gtk::TreeStore>  m_store;

            Glib::RefPtr<Gdk::Pixbuf>     m_pb_station;  
            Glib::RefPtr<Gdk::Pixbuf>     m_pb_neighbour;  
            Glib::RefPtr<Gdk::Pixbuf>     m_pb_friend;  
            Glib::RefPtr<Gdk::Pixbuf>     m_pb_tag;  
            Glib::RefPtr<Gdk::Pixbuf>     m_pb_user;  
            Glib::RefPtr<Gdk::Pixbuf>     m_pb_mainuser;  

            StationActivated station_activated_;
        };

        enum LastFMNetworkState
        {
            LAST_FM_IDLE,
            LAST_FM_RX,
            LAST_FM_TX,
            LAST_FM_N_IMAGES
        };

      bool lastfm_set_idle_image ();

      void on_lastfm_queue_size (unsigned int queue_size);
      void on_lastfm_submit_start ();
      void on_lastfm_submit_end ();
      void on_lastfm_submit_error (Glib::ustring message);

      Gtk::Widget         * hbox_lastfm_submit_error;
      TreeViewStations    * m_treeview_stations;

      void mcs_lastfm_submit_enable_changed (MCS_CB_DEFAULT_SIGNATURE);
      void mcs_lastfm_queue_enable_changed (MCS_CB_DEFAULT_SIGNATURE);
      void mcs_lastfm_record_to_profile_changed (MCS_CB_DEFAULT_SIGNATURE);
      void mcs_lastfm_credentials_changed (MCS_CB_DEFAULT_SIGNATURE);

      void radio_connect ();

      bool set_metadata_timeout_func ();
      void send_title_set_metadata ();
      
      void clear_error ();
      void set_error (Glib::ustring const& message, bool disable_session = true);
      void set_connection_message (Glib::ustring const& message);

      void play_lastfm_sync ();
      void play_http_status (int status);

      void station_list_update ();

      Glib::RefPtr<Gdk::Pixbuf>         m_network[LAST_FM_N_IMAGES];
      Glib::RefPtr<Gdk::Pixbuf>         m_audio_empty;

      Gtk::Label                        *last_fm_queue_size;
      Gtk::Image                        *last_fm_netstatus;
      Gtk::ToggleButton                 *last_fm_enable;
      Gtk::ToggleButton                 *last_fm_rtp;

      Gtk::Image                        *lastfm_coverimage;

      Gtk::Label                        *lastfm_radio_artist,
                                        *lastfm_radio_album,
                                        *lastfm_radio_track,
                                        *lastfm_radio_station,
                                        *lastfm_connection_message,
                                        *lastfm_queue_submit_error;

      Gtk::Image                        *lastfm_connection_state;
  
      Bmp::LastFM::Radio::Metadata  m_metadata;
      Bmp::LastFM::Radio::Session   m_session;

      boost::optional<Glib::ustring> m_artist;
      boost::optional<Glib::ustring> m_album;
      boost::optional<Glib::ustring> m_track;
 
      Gtk::Button *b_love, *b_skip, *b_ban;

      void love ();
      void skip ();
      void ban  ();
      void tune ();

      Gtk::Entry  *e_station;
      Gtk::Button *b_lastfm_reconnect;

      bool m_streamlist_created;
      bool m_init;
      
    }; // class LASTFM
  } // namespace UiPart
} // namespace Bmp

#endif // !BMP_UI_PART_LASTFM_HH

