//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_PLAYLIST_HH
#define BMP_UI_PART_PLAYLIST_HH

#include <gtkmm.h>
#include <libglademm.h>
#include <boost/shared_ptr.hpp>

#include "dialog-export.hh"
#include "vfs.hh"
#include "flow.hh"

#include "playbacksource.hh"
#include "ui-part-base.hh"

#include "fs.hh"

namespace Bmp
{
  namespace UiPart
  {
    class Playlist : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      public:

        Playlist (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager);
        ~Playlist ();

        void add_uris (VUri& list, bool playback);

      protected:

        virtual guint
        add_ui ();
       
        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type () { return Glib::ustring(); }

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();
  
        virtual void
        play ();

        virtual void
        play_requested ();

        virtual void
        restore_context ();

        virtual GHashTable*
        get_metadata ();

     private:

        typedef std::deque<RGUID> Queue; 
        Queue history;
        boost::optional<Queue::size_type> mark;

        Bmp::ExportDialog *export_dialog;
        Glib::RefPtr<Gtk::ActionGroup> m_actions;

        std::vector <std::string> m_container_plugins;

        bool popup_menu (GdkEvent *ev);
        void activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column);

        class PlaylistFCDialog : public Gtk::FileChooserDialog
        {
          public:
            PlaylistFCDialog ();    
            virtual ~PlaylistFCDialog ();

          protected:
            virtual void on_hide (); 

          private:
            bool audio_files_filter (Gtk::FileFilter::Info const& info);
        };

        class Track: public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::ustring> title;
            Gtk::TreeModelColumn<unsigned int>  tracknumber;
            Gtk::TreeModelColumn<Glib::ustring> artist;
            Gtk::TreeModelColumn<Glib::ustring> album;
            Gtk::TreeModelColumn<Glib::ustring> genre;
            Gtk::TreeModelColumn<unsigned int>  date;
            Gtk::TreeModelColumn<unsigned int>  duration;
            Gtk::TreeModelColumn<Glib::ustring> location;
            Gtk::TreeModelColumn<Glib::ustring> asin;
            Gtk::TreeModelColumn<guint64>       guid;

            Track ()
            {
              add (title);
              add (tracknumber);
              add (artist);
              add (album);
              add (genre);
              add (date);
              add (duration);
              add (location);
              add (asin);
              add (guid);
            }
        };
        Track track;

        void cell_data_func_playing (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& iter);
        void cell_data_func_numbers (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& iter);

        int  default_sort_func (Gtk::TreeModel::iterator const& iter_a, Gtk::TreeModel::iterator const& iter_b);

        void list_selection_changed ();
        void tree_selection_changed ();
        void send_title ();
        void check_nextprev_caps ();
  
        void append_track (Glib::ustring const& uri);
        void add (bool play = false);
        void add_fc ();
        void clear ();
        void clear_selected ();
        void export_playlist ();

        void mcs_playlist_dirtree_rootpath_changed (MCS_CB_DEFAULT_SIGNATURE);

        Gtk::TreeView                    *playlist_view;
        Glib::RefPtr<Gtk::ListStore>      playlist_store;

        Gtk::CellRendererPixbuf          *cell_playing;
        Glib::RefPtr<Gdk::Pixbuf>         m_playing;

        boost::optional<Gtk::TreeModel::RowReference> m_playing_row;

        Bmp::FilesystemTree             * tree;

        Gtk::Notebook                   * playlist_notebook;
        Gtk::HPaned                     * playlist_hpaned;
        Gtk::Alignment                  * playlist_alignment_single;

        Glib::RefPtr<Gtk::ToggleAction>   m_action_show_fstree;

        void on_show_tree_toggled ();
        bool m_init;

        guint64 m_guid;

    }; // Playlist
  } // UiPart
} // Bmp

#endif // !BMP_UI_PART_PLAYLIST_HH

