//  BMPx - The Dumb Music Player
//  Copyright (C) 2005 BMPx development team.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License Version 2
//  as published by the Free Software Foundation.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//  --
//
//  The BMPx project hereby grants permission for non-GPL compatible GStreamer
//  plugins to be used and distributed together with GStreamer and BMPx. This
//  permission is above and beyond the permissions granted by the GPL license
//  BMPx is covered by.

#ifndef BMP_UI_PART_PODCASTS_HH
#define BMP_UI_PART_PODCASTS_HH

#include <boost/shared_ptr.hpp>

#include <gtkmm.h>
#include <libglademm.h>

#include "util.hh"

#include "playbacksource.hh"
#include "ui-part-base.hh"
#include "ui-part-podcasts.hh"

#include "podcast.hh"

namespace Bmp
{
  namespace UiPart
  {
    class Podcasts : public Bmp::PlaybackSource, public Bmp::UiPart::Base
    {
      public:

        Podcasts (Glib::RefPtr<Gnome::Glade::Xml> const& xml, Glib::RefPtr<Gtk::UIManager> ui_manager);
        ~Podcasts ();

      protected:

        virtual guint
        add_ui ();
       
        virtual Glib::ustring
        get_uri ();

        virtual Glib::ustring
        get_type ();

        virtual bool
        go_next ();

        virtual bool
        go_prev ();

        virtual void
        stop ();
  
        virtual void
        play ();

        virtual void
        play_requested ();

        virtual void
        restore_context ();

        virtual GHashTable*
        get_metadata ();

     private:
    
        boost::shared_ptr<Bmp::PodCastTools::PodCastManager> m_cast_manager;

        void add_cast_internal (Bmp::PodCastTools::PodCast const& cast, Glib::RefPtr<Gdk::Pixbuf> & pixbuf);
        void upd_cast_internal (Bmp::PodCastTools::PodCast const& cast, Glib::RefPtr<Gdk::Pixbuf> & pixbuf,
                                Gtk::TreeModel::iterator const& m_iter);

        // Action Callbacks
        void activate_default (Gtk::TreeModel::Path const& path, Gtk::TreeViewColumn* column);

        void add_podcast ();
        void del_podcast ();
        void upd_podcast ();

        void copy_podcast_link ();
        void copy_web_link ();

        void download_cast_item ();
        void download_cast_item_progress (double progress);

        void casts_selection_changed ();
        void items_selection_changed ();

        void buffering (double buffering);

        class Casts : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> >  image;
            Gtk::TreeModelColumn<Glib::ustring>               title;
            Gtk::TreeModelColumn<std::string>                 key;
            Gtk::TreeModelColumn<bool>                        defaultimage;
            Gtk::TreeModelColumn<guint64>                     guid;
            Gtk::TreeModelColumn<Glib::ustring>               cast_uri;

            Casts ()
            {
              add (image);
              add (title);
              add (key);
              add (cast_uri);
              add (defaultimage);
              add (guid);
            }
        };
        Casts casts;

        class Items : public Gtk::TreeModel::ColumnRecord
        {
          public:

            Gtk::TreeModelColumn<Glib::ustring>                   title;
            Gtk::TreeModelColumn<Glib::ustring>                   feed;
            Gtk::TreeModelColumn<time_t>                          date;
            Gtk::TreeModelColumn<Bmp::PodCastTools::PodCastItem>  item;

            Gtk::TreeModelColumn<bool>                            listenedto;

            Gtk::TreeModelColumn<bool>                            downloading;

            Items ()
            {
              add (title);
              add (feed);
              add (date);
              add (item);

              add (listenedto); // shouldn't be a separate column but too lazy now to code all the treemodel sorting code manually -- deadchip
              add (downloading);  
            }
        };
        Items items;

        enum Direction
        {
          NEXT,
          PREV,
          CHECKONLY,
        };

        // Items
        void cell_data_func_playing (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);
        void cell_data_func_new     (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);
        void cell_data_func_disk    (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);
        void cell_data_func_date    (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);

        // Casts
        void cell_data_func_cast_logo (Gtk::CellRenderer * cell, Gtk::TreeModel::iterator const& m_iter);
        int  casts_default_sort_func (Gtk::TreeModel::iterator const& iter_a, Gtk::TreeModel::iterator const& iter_b);

        void go_next_prev  (Direction direction);
        void has_next_prev (bool & next, bool & prev);
        bool sel_guid_is_current_guid ();
  
        Gtk::TreeView * m_view_casts;
        Gtk::TreeView * m_view_items;

        Glib::RefPtr<Gtk::ActionGroup> m_actions;
        Glib::RefPtr<Gtk::ListStore>   m_store_casts;
        Glib::RefPtr<Gtk::ListStore>   m_store_items;

        Glib::RefPtr<Gdk::Pixbuf>      m_playing;
        Glib::RefPtr<Gdk::Pixbuf>      m_feed_default;
        Glib::RefPtr<Gdk::Pixbuf>      m_emblem_new;
    
        oustring                                m_title;
        boost::optional<SimpleTrackInfo>        m_sti;

        boost::optional<Gtk::TreeModel::iterator>   m_current_iter;
        boost::optional<guint64>                    m_current_guid;
        boost::optional<Glib::ustring>              m_current_item_guid;

        Gtk::TextView * textview;
        Glib::RefPtr<Gtk::TextBuffer> textbuffer;

        typedef std::map<guint64, Gtk::TreeModel::iterator> ContextMap;
        ContextMap context_map;

        guint64 m_guid;

    }; // Playlist
  } // namespace UiPart
} // namespace Bmp

#endif // !BMP_UI_PART_PODCASTS_HH

