/*
	$Id: menubar.cpp,v 1.21 2001/09/08 19:12:51 japj Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/GUI/menubar.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"
#include "menubar_generic.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_MenuBar::CL_MenuBar(
	const CL_ComponentOptions &options,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_MenuData(options, parent, style),
	impl(NULL)
{
	impl = new CL_MenuBar_Generic(this, options, style);
	get_style_manager()->connect_styles("menubar", options, this);
}

CL_MenuBar::CL_MenuBar(
	const CL_Rect &pos,
	CL_Component *parent,
	CL_StyleManager *style)
:
	CL_MenuData(
		CL_MenuBar_Generic::create_options(pos),
		parent,
		style),
	impl(NULL)
{
	CL_ComponentOptions options = CL_MenuBar_Generic::create_options(pos);
	impl = new CL_MenuBar_Generic(this, options, style);
	get_style_manager()->connect_styles("menubar", options, this);
}

CL_MenuBar::~CL_MenuBar()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

/////////////////////////////////////////////////////////////////////////////
// Operations:

/////////////////////////////////////////////////////////////////////////////
// Signals:

