/*
	$Id: menuitem_generic.cpp,v 1.12 2001/12/16 19:18:08 mbn Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "menuitem_generic.h"
#include "API/GUI/menuitem.h"
#include "API/GUI/component.h"
#include "API/GUI/component_options.h"
#include "API/GUI/stylemanager.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_ComponentOptions CL_MenuItem_Generic::create_options(
	const std::string &text,
	bool checkable,
	bool checked,
	bool separator)
{
	CL_ComponentOptions options;

	options.add_option("text", text);
	options.add_option("checkable", checkable);
	options.add_option("checked", checked);
	options.add_option("separator", separator);

	return options;
}

CL_MenuItem_Generic::CL_MenuItem_Generic(CL_MenuItem *self, const CL_ComponentOptions &options, CL_StyleManager *style)
:
	menuitem(self)
{
	separator = false;
	checked = false;
	checkable = false;
	highlighted = false;

/*	timer_popup.set_interval(250);
	timer_popup.disable();

	slots.add_slot(timer_popup.sig_timer.connect(
		this, &CL_MenuItem::on_timer_popup));
*/
	slot_key_down = menuitem->sig_key_down().connect(
		this, &CL_MenuItem_Generic::on_key_down);
	slot_mouse_enter = menuitem->sig_mouse_enter().connect(
		this, &CL_MenuItem_Generic::on_mouse_enter);
	slot_mouse_left = menuitem->sig_mouse_leave().connect(
		this, &CL_MenuItem_Generic::on_mouse_leave);
	slot_child_add = menuitem->sig_child_add().connect(
		this, &CL_MenuItem_Generic::on_child_add);

	if(options.exists("text"))
		text = options.get_value("text");
	if(options.exists("separator"))
		separator = options.get_value_as_bool("separator");
	if(options.exists("checked"))
		checked = options.get_value_as_bool("checked");
	if(options.exists("checkable"))
		checkable = options.get_value_as_bool("checkable");
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

bool CL_MenuItem_Generic::is_checkable() const
{
	return checkable;
}

bool CL_MenuItem_Generic::is_separator() const
{
	return separator;
}

bool CL_MenuItem_Generic::is_checked() const
{
	return checked;
}

bool CL_MenuItem_Generic::is_highlighted() const
{
	return highlighted;
}

bool CL_MenuItem_Generic::has_submenu() const
{
	return menuitem->get_children().size() > 0;
}
	
const std::string &CL_MenuItem_Generic::get_text() const
{
	return text;
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

void CL_MenuItem_Generic::set_text(const std::string &text)
{
	this->text = text;
}

/////////////////////////////////////////////////////////////////////////////
// Callbacks:

void CL_MenuItem_Generic::on_mouse_enter()
{
	highlighted = true;
	timer_popup.enable();
}

void CL_MenuItem_Generic::on_mouse_leave()
{
	highlighted = false;
	timer_popup.disable();
}

void CL_MenuItem_Generic::on_timer_popup()
{
	timer_popup.disable();
}

void CL_MenuItem_Generic::on_child_add(CL_Component *child)
{
//	child->show(false);
}

void CL_MenuItem_Generic::on_key_down(CL_Component *comp, CL_InputDevice *device, const CL_Key &key)
{
	menuitem->sig_clicked()();
	
	if(checkable)
	{
		checked = !checked;
		return;		
	}

	if(separator)
		return;
}

/////////////////////////////////////////////////////////////////////////////
// Implementation:
