/*
	$Id: treeview_item.cpp,v 1.6 2002/01/16 19:43:06 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"

#include "treeview_item_generic.h"
#include "component_generic.h"
#include "API/GUI/stylemanager.h"

/////////////////////////////////////////////////////////////////////////////
// Construction:

CL_TreeView_Item::CL_TreeView_Item(
	CL_Component *parent,
	CL_StyleManager *style)
: CL_Component(parent, style), impl(NULL)
{
	impl = new CL_TreeView_Item_Generic(this, "");
	get_style_manager()->connect_styles("treeview_item", this);
	find_preferred_size();
}

CL_TreeView_Item::CL_TreeView_Item(
	const std::string &text,
	CL_Component *parent,
	CL_StyleManager *style)
: CL_Component(parent, style), impl(NULL)
{
	impl = new CL_TreeView_Item_Generic(this, text);
	get_style_manager()->connect_styles("treeview_item", this);
	find_preferred_size();
}

CL_TreeView_Item::~CL_TreeView_Item()
{
	delete impl;
}

/////////////////////////////////////////////////////////////////////////////
// Attributes:

bool CL_TreeView_Item::is_open() const
{
	return impl->opened;
}

bool CL_TreeView_Item::is_highlighted() const
{
	return has_mouse_over();
}

bool CL_TreeView_Item::has_subtree() const
{
	return impl->has_subtree();
}

const std::string &CL_TreeView_Item::get_text() const
{
	return impl->text;
}

/////////////////////////////////////////////////////////////////////////////
// Operations:

void CL_TreeView_Item::set_text(const std::string &text)
{
	impl->set_text(text);
}

/////////////////////////////////////////////////////////////////////////////
// Signals:

CL_Signal_v0 &CL_TreeView_Item::sig_clicked()
{
	return impl->sig_clicked;
}

