/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include <string>

#include <wx/filename.h>
#include <wx/file.h>

#include "SelectedFilesList.hh"
#include "../pkcs7.hh"

#include "MainWindow.hh"
#include "Common.hh"

using namespace Cryptonit;

// BEGIN_EVENT_TABLE(SelectedFilesList, wxListCtrl)
//     EVT_CLOSE(MainWindow::exit)
// END_EVENT_TABLE();


SelectedFilesList::SelectedFilesList(wxWindow* parent, wxWindowID id, long style)
  : wxListCtrl(parent, id, wxDefaultPosition,  wxDefaultSize, style){
    p = parent;
};

  

SelectedFilesList::~SelectedFilesList(){}


bool SelectedFilesList::addFiles(const wxArrayString& filenames) {
 
  size_t nFiles = filenames.GetCount();
  wxString str;
  long i;
  for ( size_t n = 0; n < nFiles; n++ ) {
 
    if(isValid(filenames[n])){
    i = GetItemCount();
    InsertItem(i, filenames[n] ,0);
    SetItem(i,2,getType(filenames[n]));
    SetItem(i,1,getSize(filenames[n]));
    }
  }
  
  if(GetItemCount()>0){
      
      ((MainWindow*)p)->enableButtons();
      SetColumnWidth( 0 , wxLIST_AUTOSIZE );
      SetColumnWidth( 1 , wxLIST_AUTOSIZE );
      SetColumnWidth( 2 , wxLIST_AUTOSIZE );

  }
  return TRUE;
}


wxString SelectedFilesList::getSize(wxString &filename){
  wxString ssize;

  wxFile *file = new wxFile(filename.c_str(), wxFile::read);
  if (file->IsOpened())
    {
      float fsize = file->Length();
      file->Close();
      
      if (fsize > 1024)
	{
	  fsize /= 1024;
	  if (fsize > 1024)
	    {
	      fsize /= 1024;
	      ssize.Printf(_T("%.1f Mo"), fsize);
	    }
	  else
				ssize.Printf(_T("%.1f ko"), fsize);
	}
      else
					ssize.Printf(_T("%.1f o"), fsize);

      return ssize;
    }
  else
			return _T("-1");

}

bool SelectedFilesList::OnDropFiles(wxCoord x, wxCoord y, const wxArrayString& filenames){
  
  addFiles(filenames);

  return TRUE;
}

wxString SelectedFilesList::getType(wxString &filename){
  pkcs7 *p = new pkcs7();
  wxString ret = _T("");

  if(p->read(wx2std(filename).c_str())==SUCCESS){
    if(p->isSigned() && ! p->isDetached()) 
	ret = _("Signed File");
    else if(p->isSigned() && p->isDetached()) 
	ret = _("Detached signature");
    else if(p->isEncrypted())
      ret = _("Encrypted File");
    else if(p->isSignedAndEncrypted())
      ret = _("Signed & Encrypted File");
    else 
      ret = _("Data file");
  }
  else
    ret = _("Data file");
  
  delete p;
  return ret;
}

void SelectedFilesList::OnListKeyDown(wxListEvent& event){
  switch ( event.GetKeyCode() ){

  case WXK_DELETE:
    {
      long item = GetNextItem(-1,
			      wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
      while ( item != -1 )
	{
	  DeleteItem(item);
	  
	  // -1 because the indices were shifted by DeleteItem()
	  item = GetNextItem(item - 1,
			     wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	}
   
    }
    break;
    
  default: break;
    event.Skip();
  }
 if(GetItemCount()==0)
      ((MainWindow*)p)->enableButtons(false);
}


bool SelectedFilesList::isValid(wxString file){
   long item = -1;
   bool ret = true;
    for ( ;; )
    {
      item = GetNextItem(item,
				   wxLIST_NEXT_ALL,
				   wxLIST_STATE_DONTCARE);
      if ( item == -1 )
	break;
      
      if(file.IsSameAs(GetItemText(item)))
	return false;
      
    }
      return ret;
}


