#ifndef __SHA2_H__
#define __SHA2_H__

#include "types.h"

#define SHA256_BLOCK_LENGTH		64
#define SHA256_DIGEST_LENGTH		32

typedef struct _sha256_ctx {
	uint32	state[8];
	uint64	bitcount;
	uint8	buffer[SHA256_BLOCK_LENGTH];
} sha256_ctx;

void sha256_begin(sha256_ctx *ctx);
void sha256_hash(const uint8 *data, const uint32 len, sha256_ctx *ctx);
void sha256_final(uint8 *hash, sha256_ctx *ctx);

#endif /* __SHA2_H__ */

