/***************************************************************************
                          blop.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include "blop.h"
#include "leveldaten.h"


/** Constructor... Zu den Parametern siehe setSorte(...) */
Blop::Blop(int a /*= blopart_keins*/, int f /*= -1*/):
  mAmPlatzen(0), mFeuer(0), mBesitzer(0), mX(keine_koord), mY(keine_koord)
{
  setSorte(a, f);
}

Blop::Blop(const Blop & b):
  mFeuer(0), mBesitzer(0), mX(keine_koord), mY(keine_koord)
{
  /* Alle Felder auf den Inhalt von b ndern...
     (Vorher mFeuer auf 0 setzen, damit nicht was nicht-existentes
     gelscht wird) */
  aendern(b);
}

Blop::~Blop() {
  if (mFeuer)
    delete mFeuer;
}


/** Tut, was man erwartet. (Kopiert insbesondere auch das Feuer) */
Blop & Blop::operator=(const Blop & b) {
  aendern(b);
  return *this;
}


/** kopiert die Daten von b; liefert true, wenn
    dabei was gendert wurde */
bool Blop::aendern(const Blop & b) {
  /* mSorte muss kopiert werden, auch wenn sich der Blop nicht gendert
     zu haben scheint, falls inzwischen ein neuer Level luft. (Sonst
     funktioniert das Lschen vom Blopgitter nicht richtig, wenn es eine
     nix-Sorte gibt.) */
  mSorte = b.mSorte;
  if (mArt == b.mArt &&
      mFarbe == b.mFarbe &&
      mAmPlatzen == b.mAmPlatzen &&
      mZustand == b.mZustand &&
      !mFeuer && !b.mFeuer) // Das ist einfacher...
    return false;
  mArt = b.mArt;
  mFarbe = b.mFarbe;
  mAmPlatzen = b.mAmPlatzen;
  mZustand = b.mZustand;
  if (mFeuer) delete mFeuer;
  if (b.mFeuer) {
    /* Wenn man einen Copy-Contructor htte... */
    mFeuer = new Blop(*b.mFeuer);
    mFeuer->setBesitzer(this);
  } else
    mFeuer = 0;
	
  geaendert(true);
		
  return true;
}



/** malt den Blop; xx und yy sind in Pixeln angegeben;
    der Hintergrund wird vorher gelscht;
    verbindung gibt an, wo nachbarblops sind */
void Blop::malen(QPainter & p, int xx, int yy) const {
  if (ld->mSpiegeln) yy = gry * gric - yy - gric;
  if (mSorte) {
    mSorte->malen(p, xx, yy, mZustand, getVerbindungen());
    if (mAmPlatzen) {
      ld->bbumm.malBildchen(p, xx, yy, mAmPlatzen - 1);
    }
  }
  if (mFeuer) {
    mFeuer->malen(p, xx, yy);
  }
} // malen



/** liefert die Art zurck */
int Blop::getArt() const {
  /*  if (mArt == blopart_wirklich_keins)
    return blopart_keins;
    else*/
    return mArt;
}


/** liefert die Farbe zurck, aber nur, wenns wirklich ein farbiges
    Blop ist (sonst wird keine_farbe zurckgeliefert) */
int Blop::getFarbe() const {
  if (mArt == blopart_farbe)
    return mFarbe;
  else
    return keine_farbe;
}

/** liefert die Version zurck. */
int Blop::getVersion() const {
  return mZustand.mVersion;
}

/** liefert true, wenn der Blop am platzen ist */
bool Blop::getAmPlatzen() const {
  return mAmPlatzen != 0;
}


/** fhrt die ganzen Animationen durch. Liefert
    in Bit 0 zurck, ob das Blop-Bild geupdatet werden muss.
    Liefert in Bit 1 zurck, ob die Nachbarblopbilder evtl. geupdatet werden
    mssen (weil sich die Sorte gendert hat). Dinge, die zu zuend hinzugefgt
    werden, sollen angezndet werden. */
int Blop::animiere(PointList * zuendLi /*= 0*/) {
  int ret = 0;

  /* Normale (sorteneigene) Animation */	
  if (mSorte) {
    BildchenPtr abp = mSorte->getAnimBPtr(mZustand);
    mSorte->animiere(mZustand);
    BildchenPtr bp = mSorte->getAnimBPtr(mZustand);

    /* Nur, wenn das Bildchen anders aussieht, Grafik updaten.
       (Wichtig fr Jahreszeitenlevel.) */
    if (!abp.siehtGleichAus(bp))
      geaendert(false);

    /* Mal sehen, ob's bei diesem Animationsstand noch Specials gibt */
 		
    /* Verwandelt sich der Blop? */
    switch (bp.mVerwandlung) {
    case verwandlung_keine:
      break;
    case verwandlung_weg:
      /* Fertig gebrannt; Feuer verschwindet */
      ASSERT(mArt == blopart_feuer);
      ret |= animret_verschwinden;
      break;
    case verwandlung_verbrenne:
      /* Der Blop, der mit diesem Feuer brennt, wird zum grauen */
      ASSERT(mArt == blopart_feuer);
      ret |= animret_verbrennen;
      break;
    case verwandlung_version:
				/* Dieser Blop wechselt seine Version */
      ASSERT(mArt != blopart_feuer);
      mZustand = BlopZustand(bp.mVerwandlungParam);
      /* Wenn sich der Blop verkleiden kann, mssen (evtl.) auch die
	 Nachbarn neu gemalt werden... */
      geaendert(mSorte->getKleidsam());
      break;
    case verwandlung_sorte:
      /* Dieser Blop verwandelt sich in eine andere Sorte */
      ASSERT(mArt != blopart_feuer);
      setSorte(blopart_farbe, bp.mVerwandlungParam);
      //geaendert(true); // Nicht ntig; wird in setSorte erlegigt
      break;
    default:
      ASSERT(false);
    }
 	  	  	
    /* Zndet dieser Blop jetzt einen anderen an? (Nur testen, wenn die
       Antwort erwnscht ist) */
    if (zuendLi) {
      /* Will dieses Bildchen znden? */
      if (bp.mZuendX || bp.mZuendY) {
				/* Ja... */
	QPoint * p = new QPoint(bp.mZuendX, bp.mZuendY);
	*p += *zuendLi->first();
	zuendLi->append(p);
      }
    }
  } // if kein leeres Blop
 	
  // Animation des Platzens
  if (mAmPlatzen > 0) {
    geaendert(false);
    mAmPlatzen++;
    if (mAmPlatzen > platzbild_anzahl) {
      // fertiggeplatzt
      setSorte(blopart_keins);
      mAmPlatzen = 0;
    }
  } // if Blop ist am platzen
	
  // Feuer
  if (mFeuer) {
    ret |= mFeuer->animiere(zuendLi);
    /* Auch Feuer kann znden... (aber ob man das wirklich will, ist
       fraglich) */
		
    /* (Zu grauem) verbrannt? */
    if (ret & animret_verbrennen) {
      ret &= ~animret_verbrennen;
      if (mArt == blopart_farbe)
	setSorte(blopart_grau);
    }
		
    /* Fertig gebrannt? */
    if (ret & animret_verschwinden) {
      ret &= ~animret_verschwinden;
      delete mFeuer;
      mFeuer = 0;
    }
  }
 	
  return ret;
}

/** Startet den Platzvorgang */
void Blop::lassPlatzen() {
  ASSERT(mArt != blopart_keins);
  mAmPlatzen = 1;
}

/** Startet die Verbrennung dieses Blops (wenn's nicht schon brennt). */
void Blop::starteVerbrennung() {
  if (!mFeuer) {
    mFeuer = new Blop(blopart_feuer);
    mFeuer->setBesitzer(this);
  }
}

/** Liefert true, wenn die Blobs so gleich sind, dass sie sich verbinden
    knnen */
bool Blop::verbindetMit(const Blop & b) const {
  return getVerkleidung() == b.getVerkleidung();
}

/** Liefert true, wenn beide Blobs brennen (oder einen Brennanschluss haben) */
bool Blop::verbindetMitFeuer(const Blop & b) const {
  return (mFeuer || mSorte->getAnimBPtr(mZustand).mFeuerVerbindbar)  &&
    (b.mFeuer || b.mSorte->getAnimBPtr(b.mZustand).mFeuerVerbindbar);
}

/** liefert true, wenn der Blob prinzipiell bereit ist, Verbindungen
einzugehen */
bool Blop::verbindbar() const {
  if (mSorte)
    return mSorte->verbindbar();
  else
    return false;
}
/** Setzt mArt, mFarbe und mSorte. Nur mit dieser Funktion
    sollte die Sorte gendert werden. Bei der Gelegenheit
    wird auch der Zustand zurckgesetzt. Und die Version wird
    neu gesetzt: Wenn keine angegeben ist, auf was zuflliges.
    (Bei Farbblops ist der zweite Parameter die Farbe, und der
    dritte die Version; bei anderen Blops ist der zweite die
    Version... etwas provisorisch.) */
void Blop::setSorte(int a, int f /*= -1*/, int v /*= -1*/) {
  mArt = a;
  if (a == blopart_farbe) {
    mFarbe = f;
    f = v;
  }
  switch (mArt) {
    /*  case blopart_wirklich_keins:
    mSorte = 0;
    break;*/
  case blopart_keins:
    if (ld->mMitLeerBildchen)
      mSorte = &ld->mLeerSorte;
    else
      mSorte = 0;
    break;
  case blopart_farbe:
    mSorte = &ld->mFarbSorten[mFarbe];
    break;
  case blopart_gras:
    mSorte = &ld->mGrasSorte;
    break;
  case blopart_grau:
    mSorte = &ld->mGrauSorte;
    break;
  case blopart_blaeschen:	
    mSorte = &ld->mBlaeschenSorte;
    break;
  case blopart_feuer:
    mSorte = &ld->mFeuerSorte;
    break;
  default:
    ASSERT(false);
  }

  /* Zustand (zurck) setzen */
  if (mSorte) {
    if (f == -1) {
      /* Version nicht angegeben, also zufllig setzen... auer,
	 wenn die Version aus der Kettengre bestimmt wird. Dann
	 erst mal Version 0 nehmen. */
      if (mSorte->mVersionNachKette)
	f = 0;
      else
	f = mSorte->getZufallsVersion();
    } else
      ASSERT(f < mSorte->getAnzVersionen());
    mZustand = BlopZustand(f);
  } else
    mZustand = BlopZustand();

  /* nderung bekannt geben */
  geaendert(true);
}

/** Wenn's ein Level ist, bei dem sich Blops beim Drehen
    ndern, wird dies getan */
void Blop::drehen(){
  ASSERT(mArt == blopart_farbe);
  int neufa = ld->mDrehWechsel[mFarbe];
  /* Wechselt der Blop beim drehen? */
  if (neufa != mFarbe)
    setSorte(blopart_farbe, neufa);
	
  /* Ggf. Dreh-Sonderanimation starten */
  mSorte->starteSonderAnim(mZustand, animzeit_drehen);
}

/** Teilt einem Farbblop die (neue) Gre seiner Kette mit. */
void Blop::setKettenGroesse(int anz) {
  ASSERT(mArt == blopart_farbe);
		
  /* ndern wir unsere Version passend zur Kettenlnge? */
  if (mArt == blopart_farbe && mSorte->mVersionNachKette) {
    int nv = anz - 1;
    if (nv >= mSorte->getAnzVersionen())
      nv = mSorte->getAnzVersionen() - 1;
    if (nv != mZustand.mVersion)
      setSorte(mArt, mFarbe, nv);
  }	
}

/** Setzt Besitzer und Besitzer-Informationen. Braucht nur am Anfang
    einmal aufgerufen zu werden. */
void Blop::setBesitzer(BlopBesitzer * bes,
		       int x /*= keine_koord*/,
		       int y /*= keine_koord*/) {
  mBesitzer = bes;
  mX = x;
  mY = y;
}

/** Muss aufgerufen werden, wenn das Blop anders aussieht, damit
    es frisch gemalt wird. Kmmert sich drum, die gendert-Nachricht
    an die richtige Stelle weiterzuleiten. */
void Blop::geaendert(bool auch_nachbarn){
  if (mBesitzer)
    mBesitzer->besitzGeaendert(mX, mY, auch_nachbarn);
}

/** Wird ggf. vom Feuer aufgerufen */
void Blop::besitzGeaendert(int x, int y, bool auch_nachbarn) {
  geaendert(auch_nachbarn);
}

/** Fragt beim Besitzer an, in welche Richtungen dieser Blop
    verbunden werden kann und liefert das zurck. Bei Feuer
    =true wird fr das Feuer dieses Blops gefragt */
int Blop::getVerbindungen(bool feuer /*= false*/) const {
  if (mBesitzer) {
    return mBesitzer->getBesitzVerbindungen(mX, mY, feuer);
  } else
    return verbindung_solo;
}

/** Sagt (ggf.) dem Feuer, wie es sich verbinden kann. */
int Blop::getBesitzVerbindungen(int x, int y, bool feuer) const {
  ASSERT(feuer == false);
  return getVerbindungen(true);
}

/** liefert true, wenn sich der Blop auch mit dem angegebenen
    Rand verbindet */
bool Blop::verbindetMitRand(int seite) const {
  if (mSorte)
    return mSorte->mVerbindetMitRand[seite];
  else
    return false;
}

/** Liefert zurck, wie viele Punkte dieser Stein zur Kettengre
    beitrgt (normalerweise 1). */
int Blop::getKettenBeitrag() const {
  ASSERT(mArt == blopart_farbe);
  ASSERT(mSorte);
  if (mSorte->mKetteZaehltNurInnen) {
    return (getVerbindungen() & verbindung_alle4) == verbindung_alle4;
  } else
    return 1;
}

/** Liefert die aktuelle Verkleidung dieses Blops zurck. */
const Sorte * Blop::getVerkleidung() const {
  if (mSorte) {
    int v = mSorte->getVerkleidung(mZustand);
    if (v == verkleidung_keine)
      return mSorte;
    else
      return &ld->mFarbSorten[v];
  } else
    return 0;
}

/** Liefert die Art des Blop zurck, wie es sich verkleidet
    hat. */
int Blop::getArtVerkleidet() const {
  if (mSorte && mSorte->getVerkleidung(mZustand) != verkleidung_keine)
    return blopart_farbe;
  else
    return getArt();
}

/** Liefert die Farbe unter Bercksichtigung eventueller
    Verkleidungen zurck. */
int Blop::getFarbeVerkleidet() const{
  if (mSorte) {
    int v = mSorte->getVerkleidung(mZustand);
    if (v != verkleidung_keine)
      return v;
  }
  return getFarbe();
}
