/***************************************************************************
                          blopgitter.cpp  -  description
                             -------------------
    begin                : Thu Jul 12 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "blopgitter.h"

BlopGitter::BlopGitter() {
  for (int x = 0; x < grx; x++)
    for (int y = 0; y <= gry; y++)
      mDaten[x][y].setBesitzer(this, x, y);
  /* Bevor das BlopGitter benutzt wird, muss noch init() aufgerufen werden. */
}
BlopGitter::~BlopGitter(){
}


/* Animiert alle Blops. Liefert true, wenn grad welche am platzen sind */
bool BlopGitter::animiere() {

  bool da_ist_was_am_platzen = false;

  /* Liste der Dinge, die (whrend der Animation) angezndet werden. Sie drfen
     erst nach der Animationsschleife angezndet werden, damit nicht aus versehen
     danach nochmal animiere() aufgerufen wird. PointList wird in sorte.h definiert.
  */
  PointList zuendListe;
  zuendListe.setAutoDelete(true);
  /* Etwas provisorisch: in den ersten Eintrag wird immer die Position des
     Blops gespeichert, der was einfgen soll, weil der ja seine eigenen
     Koordinaten nicht kennt. */
  zuendListe.append(new QPoint(0, 0));
		
  /* Animationen bei fest liegenden Steinen? */
  for (int x = 0; x < grx; x++)
    for (int y = 0; y < getGrY(); y++) {
      Blop alt = mDaten[x][y];
      zuendListe.first()->setX(x);
      zuendListe.first()->setY(y);
      mDaten[x][y].animiere(&zuendListe);
      if (mDaten[x][y].getAmPlatzen())
	da_ist_was_am_platzen = true;
    }
	
  /* Wurden Dinge angezndet? (Ersten Punkt berspringen (s.o.)) */
  for (QPoint * p = (zuendListe.first(), zuendListe.next());
       p != 0; p = zuendListe.next()) {
    if (getFeldArt(p->x(), p->y()) != blopart_ausserhalb) {
      mDaten[p->x()][p->y()].starteVerbrennung();
      setUpdateFeld(p->x(), p->y());
    }
  }
  return da_ist_was_am_platzen;
}




/** Aufrufen, wenn sich der Blop bei x, y gendert hat.
		Updatet die Nachbarn. */
void BlopGitter::setUpdateNachbarn(int x, int y) {
  if (koordOK(x - 1, y))
    mUpdaten[x - 1][y] = true;
  if (koordOK(x + 1, y))
    mUpdaten[x + 1][y] = true;
  if (koordOK(x, y - 1))
    mUpdaten[x][y - 1] = true;
  if (koordOK(x, y + 1))
    mUpdaten[x][y + 1] = true;

  if (koordOK(x - 1, y - 1))
    mUpdaten[x - 1][y - 1] = true;
  if (koordOK(x + 1, y - 1))
    mUpdaten[x + 1][y - 1] = true;
  if (koordOK(x - 1, y + 1))
    mUpdaten[x - 1][y + 1] = true;
  if (koordOK(x + 1, y + 1))
    mUpdaten[x + 1][y + 1] = true;		
}


/** liefert true, wenn der Blob bei x, y sich mit b verbinden kann.
		Bezieht sich ggf. auf's Feuer. */
bool BlopGitter::getFeldVerbindbar(int x, int y, const Blop & b,
				   bool feuer /*= false*/) const {
  if (!koordOK(x, y)) {
    /* Auerhalb vom Rand genau dann verbinden, wenn die Sorte das
       Special hat */
    /* Known bug: Das Feuer verbindet mit Rand genau dann, wenn der
       unterliegende Blop es tut */
    bool ret = true;
    if (x < 0) ret &= b.verbindetMitRand(rand_links);
    if (x >= grx) ret &= b.verbindetMitRand(rand_rechts);
    if (y < 0) ret &= b.verbindetMitRand(rand_oben);
    if (y >= getGrY()) ret &= b.verbindetMitRand(rand_unten);
    return ret;
  } else if (feuer)
    return b.verbindetMitFeuer(mDaten[x][y]);
  else
    return b.verbindetMit(mDaten[x][y]);
		
  return false; // Um keine Warnung zu bekommen
}


/** Lscht alles */
void BlopGitter::init() {
  for (int x = 0; x < grx; x++)
    for (int y = 0; y <= gry; y++) {
      mDaten[x][y] = Blop();
      mUpdaten[x][y] = true;
    }
  mRueberReihe = false;
  mTestPlatz = false;
}



/** verschiebt einen Blop (auch wenn er explodiert oder
    sonstwie grad animiert ist). Was dort hin soll, von wo der Blop weg ist
    (z. B. blopart_wirklich_keins) kann bergeben werden. */
void BlopGitter::verschiebBlop(int x1, int y1, int x2, int y2
			       /*, int bg_sorte = blopart_keins*/) {
  mDaten[x2][y2] = mDaten[x1][y1];
  mDaten[x1][y1] = Blop(blopart_keins);/*Blop(bg_sorte);*/
}




/** liefert die Feldart bei x, y; (d. h. grau oder gras oder leer
    oder normaler Stein oder auerhalb vom Spielfeld). */
int BlopGitter::getFeldArt(int x, int y) const {
  if (x < 0 || x >= grx || y >= getGrY())
    return blopart_ausserhalb;
  else if (y < 0)
    return blopart_keins;
  else
    return mDaten[x][y].getArt();
}


/** liefert eine VerbindungsBitliste fr den Blop bei x, y. Bezieht sich
    ggf. auf's Feuer. */
int BlopGitter::getBesitzVerbindungen(int x, int y,
				      bool feuer /*= false*/) const {
  int verb = 0;
  const Blop & b = mDaten[x][y];
  if (!feuer && !b.verbindbar()) return 0;
	
  /* Sonderflle bei Sechseck-Muster:
     os = obenschrg; 1, wenn die Verbinung nach lo / ro wirklich
     schrg ist...*/
  int os = !ld->mSechseck | (x & 1);
  /* Dito fr unten */
  int us = !ld->mSechseck | !(x & 1);

  /* Bei Sechtsecken keine waag. Verbindung */
  if (!ld->mSechseck) {
    if (getFeldVerbindbar(x - 1, y, b, feuer)) verb += verbindung_links;
    if (getFeldVerbindbar(x + 1, y, b, feuer)) verb += verbindung_rechts;
  }
  if (getFeldVerbindbar(x, y - 1, b, feuer)) verb += verbindung_oben;
  if (getFeldVerbindbar(x, y + 1, b, feuer)) verb += verbindung_unten;
  			
  if (getFeldVerbindbar(x - 1, y - os, b, feuer)) verb += verbindung_lo;
  if (getFeldVerbindbar(x - 1, y + us, b, feuer)) verb += verbindung_lu;
  if (getFeldVerbindbar(x + 1, y - os, b, feuer)) verb += verbindung_ro;
  if (getFeldVerbindbar(x + 1, y + us, b, feuer)) verb += verbindung_ru;
  return verb;
}


/** liefert true, wenn (x,y) im Spielfeld liegt */
bool BlopGitter::koordOK(int x, int y) const {
  return x >= 0 && x < grx && y >= 0 && y < getGrY();
}



/** Setzt, ob die Rberreihe existiert. */
void BlopGitter::setRueberReihe(bool ex){
  mRueberReihe = ex;
  mTestPlatz = true;
  /* ... Ist fast sicher unntig, weil beim Reihe rbergeben
     sowieso genug passiert, was mTestPlatz auf true setzt */
}


/** Liefert die Anzahl der Zeilen zurck, d. h. normalerweise
gry; aber wenn die Rbergebreihe existiert, dann eins mehr. */
int BlopGitter::getGrY() const{
  return mRueberReihe ? gry + 1 : gry;
}


/** Liefert true, wenn man mal wieder testen sollte, ob was
platzt. Achtung: Das Flag wird bei diesem Aufruf gleich
gelscht. */
bool BlopGitter::getTestPlatz(){
  bool r = mTestPlatz;
  mTestPlatz = false;
  return r;
}


/** Liefert true, wenn (x, y) und alle darber liegenden
Felder frei sind. Wird von Fall bentigt. */
bool BlopGitter::testPlatzSpalte(int x, int y){
  if (!koordOK(x, y))
    return false;
  /* Das Fall mchte nicht in die Rberreihe fallen. */
  if (y == gry)
    return false;
  while (y >= 0) {
    if (mDaten[x][y].getArt() != blopart_keins)
      return false;
    y--;
  }
  return true;
}
