/***************************************************************************
                          sorte.h  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2001 by Immi
    email                : cuyo@karimmi.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SORTE_H
#define SORTE_H

#include "inkompatibel.h"

#include <qvector.h>
#include <qlist.h>
#include <qpoint.h>

#include "fehler.h"
#include "bilddatei.h"
#include "menge.h"
#include "bildchenptr.h"
#include "blopbesitzer.h" // Nur fr die Verbindungskonstanten

#define max_versionen_zahl 52

/* die verschiedenen Animationsarten... */
//#define animart_keine 0
#define animart_einzeln 1
#define animart_synchron 2

/* Zur bergabe an laden */
#define verbart_nein 0
#define verbart_selten 1
#define verbart_ja 2


/* Sonderwerte fr Zeitpunkt des Animations-Starts */
#define animzeit_drehen -1

/* Fr das verbindetMitRand-Array: */
#define rand_links 0
#define rand_rechts 1
#define rand_oben 2
#define rand_unten 3

/* Konstanten fr neighbours= */
#define nachbarschaft_normal 0
#define nachbarschaft_schraeg 1
#define nachbarschaft_6 2
#define nachbarschaft_6_schraeg 3
#define nachbarschaft_springer 4
#define nachbarschaft_dame 5
#define nachbarschaft_letzte 5



/* Fr die Znd-Liste... */
typedef QList<QPoint> PointList;


/** Enthlt alle Informationen ber den aktuellen Zustand eines Blops:
	* Untersorte vom Blop und Position in der Animation */

struct BlopZustand {
  /** Nummer der aktuellen Animation (des AnimEinsprungs). */
  int mAnimNr;
  /** Position in der Animationsfolge */
  int mAnimPos;
  /** true bedeutet: Aktuelles Animationsbild wird noch einen Schritt lnger
      angezeigt. (Ntig bei Sonderanimation Drehen: Beim Drehen des Blops
      wird die Sonderanimation gestartet; wenn nicht verzgert wird, wird
      im nchsten Spielschritt, bei dem Grafik angezeigt wird, schon der
      darauffolgende Animationsschritt angezeigt.) */
  bool mVerzoegert;
  /** Version des Blops; -1, wenn der Blopzustand nicht zu einem Blop gehrt,
      sondern zur sync-Animation */
  int mVersion;
  /** Wenn ein Blop mit diesem Zustand gemalt wird, werden die dabei benutzten
      Schemapositionen in mBenutzteSchemaPos gespeichert. Wird von animiere()
      und zuende(...) benutzt */
  mutable Menge mBenutzteSchemaPos;
			
  BlopZustand(int ver = 0): mAnimNr(-1), mAnimPos(0),
    mVerzoegert(false), mVersion(ver), mBenutzteSchemaPos(true) {}
	
  bool operator==(const BlopZustand & b) const {
    return mAnimNr == b.mAnimNr &&
      mAnimPos == b.mAnimPos &&
      mVerzoegert == b.mVerzoegert &&
      mVersion == b.mVersion;
  }
};

/* Das folgende struct sollte eigentlich innerhalb von Sorte definiert
   werden, aber damit kommt ja der kdevelop-parser nicht zurecht... */

/** Enthlt die Informationen ber eine Animation auer die Bildfolge selbst */
struct AnimEinsprung {
  /** Einsprungstelle in der Sorte::mAnimFolgen */
  int mEinsprung;
  /** Durchschnittliche Zeit zwische zwei Animationen (oder eine
      Sonderfall-Konstante) */
  int mAnimZeit;
  /** Versionen, in denen diese Animation angewandt werden kann */
  Menge mVersionen;
  /** Positionen im Schema, in denen diese Animation angewandt werden kann */
  Menge mSchemaPos;
  /** Synchron-Animation? */
  bool mSync;
		
  AnimEinsprung() {}
  AnimEinsprung(int ei, int az, const Menge & v, const Menge & sp, bool sy):
    mEinsprung(ei), mAnimZeit(az), mVersionen(v), mSchemaPos(sp), mSync(sy) {}
	
  /* Liefert true, wenn der Blop mit dem angegebenen Zustand zu der Animation
     passt. Prft nur die Sorte und die Schemapos, _nicht_ ob die Animation
     eigentlich fr Synchron bestimmt ist. */
  bool animPasst(const BlopZustand & zust) const;
  /** Prft (mit passtAnim) ob die Animation passt und startet sie
      mit der richtigen Wahrscheinlichkeit. Prft _auch_, ob die Animation
      fr Synchron bestimmt ist (und der zust zur Sync-Anim gehrt)
      Das starten der Animation
      besteht darin, die Einsprungstelle zurckzuliefern. */
  int starteVielleichtAnim(const BlopZustand & zust) const;
};



/** Enthlt alle Informationen ber eine Blopsorte; kann solche Blops malen
  *@author Immi
  */

class Sorte {
	

 public: 
  Sorte();
  ~Sorte();
	
  /** Ldt die Sorte mit dem angegebenen Namen. Schaut auch in der
      entsprechenden Gruppe von mLevelConf nach, setzt die Gruppe
      aber danach zurck. Fr verbart gibt's Konstanten zum bergeben.
      Throwt Fehler, wenn erfolglos. */
  void laden(__String name, int verbart, bool vmr = false);
	
  /** Sollte einmal pro Spielschritt aufgerufen werden (bevor
      Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich ggf. um
      die Synchron-Animation */
  void spielSchritt() const;
  /** Liefert ein BildchenPtr zum aktuellen Bildchen aus der Animation
      (damit die ganzen Animations-Zusatzinformationen ausgelesen werden
      knnen). Liefert 0-Ptr bei keiner Animation. */
  BildchenPtr getAnimBPtr(const BlopZustand & zust) const;
  /** ndert die Variable zust zum nchsten Animationsschritt. (Evtl. wird
      einfach der Zustand der Synchron-Animationsvariable nach zust kopiert.)
  */
  void animiere(BlopZustand & zust) const;
  /** Startet die Sonder-Animation san, so sie existiert. (Mit Verzgerung!) */
  void starteSonderAnim(BlopZustand & zust, int san) const;

  /** Malt ggf. einen Springerstrich.
      stueck: Bit 0 und 1 geben Bildchen-Nr an.
      Bit 2 gesetzt bedeutet linker/oberer Teil vom Strich in
      rechten/unteren Teil vom Bildchen malen. */
  void malSpringerStrich(QPainter & p, int xx, int yy, int stueck) const;
  /** malt einen Blop; xx und yy sind in Pixeln angegeben.
      Verbindung gibt an, wo nachbarblops sind; zust gibt den Zustand
      des Blops (Animationsstand und Version) an.
      Bei der Gelegenheit wird zust.mBenutzteSchemaPos aktualisiert. */
  void malen(QPainter & p, int xx, int yy, const BlopZustand & zust,
	     int verbindung) const;
  /** liefert true, wenn diese Blopsorte Verbindungen eingehen kann */
  bool verbindbar() const;
  /** liefert die Anzahl der Versionen dieses Blops zurck. */
  int getAnzVersionen() const;
  /** Liefert eine zufllige Version mit der korrekten
      Wahrscheinlichkeitsverteilung
      (wie in level.descr angegeben) zurck. */
  int getZufallsVersion() const;
  /** Liefert die Blopsorte zurck, als die sich dieser Blop
      grade verkleidet. (Meistens verkleidung_keine.) */
  int getVerkleidung(const BlopZustand & zust) const;
  /** Liefert true, wenn sich die Blops verkleiden knnen
      (und deshalb beim Versionswechsel auch Nachbarn
      neu gemalt werden mssen.) */
  bool getKleidsam() const ;

 protected:
  /***** Funktionen, die (hauptschlich) von laden() aufgerufen werden *****/
  /** Prft, ob als nchstes b kommt. b wird ggf. weggeparst. */
  bool parseBuch(const char * & str, char b) const;
  /** Parst X= (fr X Buchstabe). Liefert 0 zurck, wenn da kein Buchstabe
      steht. Sonst: Liefert X als Kleinbuchstabe. */
  char parseParGleich(const char * & str) const;
  /** Erwartet ein "," oder ein kl; liefert true bei "," */
  bool parseKommaKlammer(const char * & str, char kl) const;
  /** Parst eine Zahl >= 0. Liefert def, wenn da keine Zahl stand. */
  int parseZahl(const char * & str, int def = -1) const;
  /** Parst ein Wort (aus Buchstaben und _) und liefert es in
      Kleinbuchstaben zurck */
  __String parseWort(const char * & str) const;
  /** Parst einen BildchenPointer aus dem String */
  BildchenPtr parseBPtr(const char * & str, int & akt_dat, bool def_druebermal) const;
  /** Erwartet, dass da ein ";" oder ein Stringende steht; das ";" wird ggf.
      weggeparst */
  void parseSemikolon(const char * & str) const;
  /** Parst eine Folge von BildchenPointern und schreibt sie hinters
      Array. Ein Semikolon am Ende wird auch mit weggeparst.
      def_druebermal gibt einen Defaultwert fr
      mDrueberMalen bei Buchstaben an. (Bei * und . ist der
      Default-Wert sowieso klar. */
  void parseBPtrFolge(QArray<BildchenPtr> & ar, const char * & str,
		      int akt_dat, bool def_druebermal = false) const;
  /** Parst eine Menge von Buchstaben (A-Z, a-z). */
  Menge parseMenge(const char * & str) const;
  /** lscht die ganzen Bilder aus dem bilddateien-Array */
  void loeschBilder();
	
  /***** Funktionen, die whrend des Spiels hufig aufgerufen werden *****/
  /** 8-Nachbar-Ausnahmen mssen zweimal gemalt werden:
      - Am Anfang von malen() die deckenden; wenn eine passende deckende
      existiert, liefert malAusnahmen8 true zurck, und es muss nix weiteres
      mehr gemalt werden.
      - Am Ende von malen() die nicht deckenden.
  */
  bool malAusnahmen8(QPainter & p, int xx, int yy,
		     const BlopZustand & zust,
		     int verbindung,
		     bool deckende_malen) const;
  /** Malt das / die Bildchen passend zu zust und der Schemaposition.
      viertel gibt an, welches Viertel gemalt werden soll. */
  void malAnimiertesBildchen(QPainter & p, int xx, int yy,
			     const BlopZustand & zust,
			     char schepo, int viertel = viertel_alle) const;
  /** Malt das Bildchen, dass von bp angegeben wird.
      Insbesondere wird bei * schepo gemalt und bei . nichts.
      viertel gibt an, welches Viertel gemalt werden soll. */
  void malBPtr(QPainter & p, int xx, int yy, BildchenPtr bp,
	       char schepo, int viertel = viertel_alle) const;
  /** extrahiert aus einer bergebenen Verbindung die vier
      Berhrviertel der angegebenen Ecke und speichert sie
      in die vier ersten Bits des Rckgabewerts. Verschiedene
      Speicheranordnungen knnen angegeben werden. */
  int getEckVerbindung(int verbindung, int vnr,
		       int * anordnung) const;
  /** Interne Version von animiere(); berechnet nur den neuen Wert von anim */
  void animiereIntern(BlopZustand & zust) const;	
	
  /** liefert die Nr. eines Bildchens, die der Buchstabe c
      in level.descr bedeutet, zurck */
  int bildchenNr(char c) const;

  
  /* ACHTUNG! Beim Neueinfgen von Variablen, die aus der
   * level.descr gelesen werden, nicht vergessen, am Anfang
   * von Sorte::laden() defaults zu setzen! */
  
  public:
  /** true, wenn die Version automatisch aus der Kettenlnge eingestellt
      wird. */
  bool mVersionNachKette;
  /** Verbinden sich diese Blops auch zum Rand hin? Aufgeschlsselt
      nach den Rndern. (Konstanten rand_...) */
  bool mVerbindetMitRand[4];
  /** Zhlen nur innere Steine zur Kettengre? */
  bool mKetteZaehltNurInnen;
  /** Was zhlt als Nachbarn im Sinne einer Kette? */
  int mNachbarschaft;

  protected:
  /** Schema, nach dem die Blops aus den Bildchen zusammengesetzt werden */
  int mSchema;
  /** "Springer-Sriche"-Grafik (Schach-Level), falls existent. (Sonst 0) */
  Bilddatei * mSpringerStriche;
  /** True, wenn sich die Blops ab und zu verkleiden. Dann mssen beim
      Versionswechsel auch die Nachbarn neu gemalt werden. Mutable, da
      es von parseBPtr gesetzt wird, was const ist. */
  mutable bool mKleidsam;
  /** Ausnahme vom Schema bei Solo-Blops */
  char mSchemaAusnahme1;
  /** Ausnahmen von dem Schema (abhngig von den 8 Nachbarn) */
  __String mSchemaAusnahmen8;
  /** Ausnahmen von dem Schema versetzt (abhngig von den 4 Nachbarn der 
      Ecke) */
  __String mSchemaAusnahmen4;
  /** Alle Bildchen zu diesem Blop */
  QArray<Bilddatei *> mBilddateien;
  /** Versionen (Normalbildchen) */
  QArray<BildchenPtr> mVersionen;
  /** Animationseinsprnge */
  QVector<AnimEinsprung> mAnimEinspruenge;
  /** Animationsfolgen (alle am Stck, durch 0-Pointer getrennt) */
  QArray<BildchenPtr> mAnimFolgen;
			
  /** Fr Synchron-Animationen...: */
  mutable BlopZustand mSyncAnimZust;
};

#endif
