/***************************************************************************
                          prefsdaten.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>
#include <cstdio>
#include <cmath>

#include <qkeycode.h>

#include "inkompatibel.h"
#include "prefs.h"
#include "startatdlg.h"
#include "prefsdaten.h"
#include "cuyointl.h"
#include "fehler.h"
#include "leveldaten.h"
#include "configdatei.h"


/* Globale Variable mit den Preferences */

PrefsDaten * gPrefs;



/** Prefs-Objekt erzeugen und nach gPrefs speichern. */
PrefsDaten::PrefsDaten()
{
  gPrefs = this;
  
  liesPreferences();
}



/** Zeigt den Preferences-Dialog und kmmert sich dabei um alles. */
void PrefsDaten::preferencesDialog(QWidget * parent) {
  Prefs p(parent);  /* parent = Fenster, ber dem der Dialog liegt */

  /* Aktuelle Einstellungen in den Dialog schreiben */
  for (int i = 0; i < anz_spieler_in_dlg; i++)
    for (int j = 0; j < 4; j++)
      p.mTasten[i][j]->setTaste(mTasten[i][j]);
  //p.mTaste1Spieler->setChecked(mTaste1Spieler);
  p.mUnfertigeLevel->setChecked(mUnfertigeLevel);
  p.mKIGeschwindigkeit->setValue(mKIGeschwLog);

  /* Dialog ausfhren */
  if (p.exec()) {
    /* OK geklickt => Einstellungen wieder aus Dialog holen */
    for (int i = 0; i < anz_spieler_in_dlg; i++)
      for (int j = 0; j < 4; j++)
	mTasten[i][j] = p.mTasten[i][j]->getTaste();
    //mTaste1Spieler = p.mTaste1Spieler->isChecked();
    mUnfertigeLevel = p.mUnfertigeLevel->isChecked();
    mKIGeschwLog = p.mKIGeschwindigkeit->value();
    calcKILangsamLin();

    schreibPreferences();
  }
}


/** Zeigt den start-at-Dialog und kmmert sich dabei um alles.
    Liefert true, wenn gestartet werden soll. Speichert den
    gewhlten Level in lnr.
    sp2: true bei zweispielermodus */
bool PrefsDaten::startAtDialog(QWidget * parent, bool sp2, int & lnr) const {
  StartAtDlg sa(parent);  /* parent = Fenster, ber dem der Dialog liegt */

  try {

    /* Liste der Level basteln, die gestartet werden drfen.
       Liste soll dabei nicht dauernd repainted werden. */
    sa.mLevelListe->setAutoUpdate(false);

    int leanz = ld->getLevelAnz();

    /* Level durchgehen */
    bool alle_gewonnen = true;
    int lenr;
    for (lenr = 1; lenr <= leanz; lenr++) {
      /* In Liste einfgen */
      __String lena = ld->getLevelName(lenr);
      __String zei;
      zei.sprintf("%d. %s", lenr, lena.data());
      sa.mLevelListe->insertItem((QString) zei);

      /* Schon mal gewonnen? */
      __String intlena= ld->getIntLevelName(lenr);
      if (!mGewonneneLevel[sp2].contains(intlena)) {
	/* Der Level war noch nicht gewonnen; also keine weiteren 
	   in die Liste */
	alle_gewonnen = false;
	break;
      }
    }
    sa.mLevelListe->setAutoUpdate(true);
    sa.mLevelListe->repaint();

    /* Versuchen zu erraten, welchen Level der User haben will */
    sa.mLevelListe->setCurrentItem((
				    lnr == 0 ?
				    alle_gewonnen ? 1 : lenr
				    : lnr) - 1);


    if (sa.exec()) {
      lnr = sa.mLevelListe->currentItem() + 1;
      return true;
    }
  } catch (Fehler fe) {
    fprintf(stderr, "Error:\n%s\n", fe.getText(false).data());
  }
  return false;
}



/** sp2: true bei zweispielermodus */
void PrefsDaten::schreibGewonnenenLevel(bool sp2, int lnr) {
  __String intlena = ld->getIntLevelName(lnr);
  if (!mGewonneneLevel[sp2].contains(intlena.data())) {
    /* Level war bisher noch nie gewonnen; also in Liste einfgen */
    mGewonneneLevel[sp2].append(intlena);
    schreibPreferences();
  }
}



/** Liefert true, wenn die Taste k belegt ist, und speichert dann
    in sp und t ab, was die Taste tut. */
bool PrefsDaten::getTaste(int k, int & sp, int & t) const {
  for (sp = 0; sp < 2; sp++)
    for (t = 0; t < taste_anz; t++)
      if (k == mTasten[sp][t])
        return true;
  return false;
}





/** Liefert den Namen und Pfad der Prefs-Datei zurck
    ($HOME/.cuyo) */
__String PrefsDaten::getPrefsName() {
  char * ho = getenv("HOME");
  if (!ho) {
    /* Unter Windows zum Beispiel... */
    fprintf(stderr, _("Warning: Env-Variable $HOME not found. Using the current cirectory for .cuyo"));
    return ".cuyo";
  }
  if (ho[strlen(ho) - 1] == '/')
    return __String(ho) + ".cuyo";
  else
    return __String(ho) + "/.cuyo";
}





/** Ldt die Preferences aus wo-auch-immer-sie-abgespeichert-werden
in die Variablen. */
void PrefsDaten::liesPreferences() {
	
  int i;
  ConfigDatei prd(getPrefsName());
	
  /* Tastenbelegung */
	
  /* Default-Tasten */
  int dt[2][4] = {{Qt::Key_A, Qt::Key_D, Qt::Key_W, Qt::Key_S},
    {Qt::Key_Left, Qt::Key_Right, Qt::Key_Up, Qt::Key_Down}};
  char tn[4][9] = {"left", "right", "turn", "down"};
																	
  for (i = 0; i < 2; i++) {
    __String s;
    s.sprintf("keys %d", i + 1);
    prd.setAbschnitt(s);
    for (int j = 0; j < 4; j++)
      mTasten[i][j] = prd.getZahlEintrag(tn[j], dt[i][j]);
  }

  /* Gewonnene Level */
  prd.setAbschnitt(0);
  for (i = 0; i < 2; i++) {
    prd.getListenEintrag(i ? "wonMultiPlayer" : "wonOnePlayer", mGewonneneLevel[i]);
    /* Debug-Ausgabe: */
    /*__String t = prd->readEntry(i ? "wonMultiPlayer" : "wonOnePlayer");
      printf("blub = %s\n", t.data());*/
  }

  /* Auch unfertige Level? */
  mUnfertigeLevel = prd.getZahlEintrag("unfinishedLevels", 0);
  
  /* KI-Player-Geschwindigkeit */
  mKIGeschwLog = prd.getZahlEintrag("AISpeed", 6);
  calcKILangsamLin();
}



/** Schreibt die Preferences nach wo-auch-immer-sie-abgespeichert-werden. */
void PrefsDaten::schreibPreferences() {

  __String na = getPrefsName();

  FILE * f = fopen(na, "w");
  if (!f) {
    fprintf(stderr, _("Warning: Could not write preferences file \"%s\"."),
            na.data());
    return;
  }
	    
  fprintf(f, "# cuyo Preferences File\n\n");
  for (int i = 0; i < 2; i++) {
    fprintf(f, i ? "wonMultiPlayer=" : "wonOnePlayer=");
    __String lena;
    for (lena = mGewonneneLevel[i].first(); lena != 0;
	 lena = mGewonneneLevel[i].next())
      fprintf(f, "%s,", lena.data());
    fprintf(f, "\n");
  }
  fprintf(f, "\n");
  fprintf(f, "unfinishedLevels=%d\n\n", mUnfertigeLevel);
  fprintf(f, "AISpeed=%d\n\n", mKIGeschwLog);

  char tn[4][9] = {"left", "right", "turn", "down"};
  for (int i = 0; i < 2; i++) {
    fprintf(f, "[keys %d]\n", i + 1);
    for (int j = 0; j < 4; j++)
      fprintf(f, "%s=%d\n", tn[j], mTasten[i][j]);
    fprintf(f, "\n");
  }

  fclose(f);	
}


void PrefsDaten::calcKILangsamLin() {
  /* 9 -> 1
     6 -> 2
     3 -> 4
     0 -> 8 */
  mKIGeschwLin = exp((9 - mKIGeschwLog) * log(2) / 3);
}


