/***************************************************************************
                          spielfeld.cpp  -  description
                             -------------------
    begin                : Sat Oct 2 1999
    copyright            : (C) 1999 by immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctime>
#include <cstdio>

#include <qstring.h>
#include <qpainter.h>
#include <qtimer.h>

#include "punktefeld.h"
#include "inkompatibel.h"
#include "leveldaten.h"


unsigned int Punktefeld::mRandSeed = (time(0) % 8191) | 1;


Punktefeld::Punktefeld(QWidget *parent/*=0*/, const char *name/*=0*/):
  QWidget(parent,name), mPunkte(-1), mAugenZu(-1) {

  /* Timer erzeugen und verbinden... */	
  QTimer * ti = new QTimer(this);
  ti->start(170);
	
  connect(ti, SIGNAL(timeout()), SLOT(zwinkerSchritt()));
}



void Punktefeld::paintEvent(QPaintEvent * /*evt*/) {

  QPainter p(this);

  if (mPunkte >= 0) {
    int x = width();
    int pt = mPunkte;
    int n = 0;
    do {
      x -= 24;
      ld->mPktZiffernBild[mAugenZu == n].malBildchen(p, x, 0, pt % 10);
      n++;
      pt /= 10;
    } while (pt > 0);

  }
} 


void Punktefeld::setPunkte(int p) {
  mPunkte = p;
  update();
}


void Punktefeld::zwinkerSchritt() {
  if (mAugenZu >= 0) update();
  
  /* Hat mir mal jemand einen Pseudozufalls-Algorithmus? */
  mRandSeed = (mRandSeed * 2369) % 8191;
  
  //fprintf(stderr, "%d\n", mRandSeed);
  if (mRandSeed < 300) {
    mAugenZu = mRandSeed / 60;
    update();
  } else
    mAugenZu = -1;
}



