#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf tempOld tempA tempB
mkdir tempOld tempA
cd tempOld
$DARCS initialize
echo record author me > _darcs/prefs/defaults
echo ALL all >> _darcs/prefs/defaults
#echo ALL verbose >> _darcs/prefs/defaults
echo ALL ignore-times >> _darcs/prefs/defaults
echo A > foo
echo B >> foo
echo C >> foo
echo D >> foo
echo E >> foo
echo F >> foo
echo G >> foo
echo H >> foo
$DARCS add foo
$DARCS record -m Old
cd ..

cd tempA
$DARCS initialize
cp ../tempOld/_darcs/prefs/defaults _darcs/prefs
$DARCS pull ../tempOld
cp foo temp
cat temp | grep -v A | grep -v B | grep -v D | sed s/E/e/ \
    | grep -v G | sed s/H/h/ > foo
$DARCS record -m A
cd ..

darcs get tempOld tempB
cd tempB
cp ../tempOld/_darcs/prefs/defaults _darcs/prefs
echo 7 > foo
$DARCS record -m B
$DARCS pull ../tempA
$DARCS record -m "conflict resolution"
cd ..

cd tempA
$DARCS pull ../tempB
$DARCS annotate -p B
$DARCS annotate -p resolution
cd ..

cmp tempA/foo tempB/foo

rm -rf tempOld tempA tempB

