%  Copyright (C) 2008 Eric Kow
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; see the file COPYING.  If not, write to
%  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
%  Boston, MA 02110-1301, USA.


\begin{code}
module English where

englishNum :: Numbered n => Int -> n -> ShowS
englishNum x = if x == 1 then singular else plural

class Numbered a where
  plural :: a -> ShowS
  singular :: a -> ShowS

newtype Noun = Noun String

instance Numbered Noun where
  plural (Noun "") = id
  -- note that this is wrong! consider 'cat-es' and 'dog-es'
  -- but it works for darcs 'patch-es' and 'change-s'
  plural (Noun s) | last s == 'e' = showString s .  showChar 's'
  plural (Noun s) = showString s . showString "es"
  singular (Noun s) =  showString s

data This = This Noun

instance Numbered This where
  plural (This s)   = showString "these "  . plural s
  singular (This s) = showString "this "   . singular s
\end{code}
