#!/usr/bin/env perl

# Some tests for 'darcs annotate'

use lib 'lib/perl';
use Test::More 'no_plan';
use Shell::Command;
use Test::Darcs;
use strict; 
use warnings;

init_tmp_repo();

my $test_name = 'record something';

`date >> date.t`;
darcs 'add date.t';

like(darcs(q(record -A 'Mark Stosberg <a@b.com>' -a -m foo date.t)), qr/finished recording/i, $test_name);
like(darcs(q(annotate --xml date.t)),qr/&lt;a\@b.com&gt;/,'annotate --xml encodes < and >');

