#!/usr/bin/env perl

# Some tests for the behavior when there is a conflict in _darcs/patches/pending

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

init_tmp_repo();

open(PENDING,'>_darcs/patches/pending') || die "couldn't open pending: $!";
print PENDING '{
    addfile ./date.t
    addfile ./date_moved.t
    move ./date.t ./date_moved.t
}';
close(PENDING); 

# now watch the fireworks as all sorts of things fail
like( darcs ('whatsnew'), qr/pending has conflicts/, "darcs whatsnew reports 'pending has conflicts'");

####

my $revert_output = darcs 'revert -a';
like($revert_output, qr/pending has conflicts/, 'darcs revert reports "pending has conflicts"');

###

my $record_output =  darcs 'record -a -m foo';
like($record_output, qr/pending has conflicts/, 'darcs record reports "pending has conflicts"');

like( darcs('repair'), qr/The repository is already consistent, no changes made/i, 'darcs repair finds no problem');
