.\" dpkg manual page - dpkg-buildflags(1)
.\"
.\" Copyright © 2010-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011 Kees Cook <kees@debian.org>
.\" Copyright © 2011-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-buildflags 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.nh
.SH NAAM
dpkg\-buildflags \- geeft de bij pakketbouw te gebruiken bouwvlaggen terug
.
.SH OVERZICHT
\fBdpkg\-buildflags\fP [\fIoptie\fP...] [\fIcommando\fP]
.
.SH BESCHRIJVING
\fBdpkg\-buildflags\fP is gereedschap om de compilatievlaggen op te halen die
tijdens het bouwen van Debian pakketten gebruikt moeten worden.
.
De standaardvlaggen worden gedefinieerd door de leverancier, maar ze kunnen
op verschillende manieren uitgebreid/vervangen worden:
.IP 1.
voor het hele systeem met \fB%PKGCONFDIR%/buildflags.conf\fP;
.IP 2.
voor de huidige gebruiker met \fB$XDG_CONFIG_HOME/dpkg/buildflags.conf\fP,
waarbij \fB$XDG_CONFIG_HOME\fP als standaardwaarde \fB$HOME/.config\fP heeft;
.IP 3.
tijdelijk door de gebruiker met omgevingsvariabelen (zie het onderdeel
\fBOMGEVING\fP);
.IP 4.
dynamisch door de pakketonderhouder met omgevingsvariabelen die ingesteld
worden via \fBdebian/rules\fP (zie het onderdeel \fBOMGEVING\fP).
.P
De configuratiebestanden kunnen vier types opdrachten bevatten:
.TP 
\fBSET\fP\fI vlag waarde\fP
Vervang de waarde van de vlag die \fIvlag\fP als naam heeft in waarde
\fIwaarde\fP.
.TP 
\fBSTRIP\fP\fI vlag waarde\fP
Verwijder van de vlag die \fIvlag\fP als naam heeft alle bouwvlaggen die in
\fIwaarde\fP opgesomd worden.
.TP 
\fBAPPEND\fP\fI vlag waarde\fP
Breid de vlag die \fIvlag\fP als naam heeft uit door er de opties aan toe te
voegen die in \fIwaarde\fP opgegeven worden. Er wordt een spatie geplaatst voor
de waarde die toegevoegd wordt, indien de huidige waarde van de vlag niet
leeg is.
.TP 
\fBPREPEND\fP\fI vlag waarde\fP
Breid de vlag die \fIvlag\fP als naam heeft uit door er vooraan de opties aan
toe te voegen die in \fIwaarde\fP opgegeven worden. Er wordt een spatie
geplaatst achter de waarde die toegevoegd wordt, indien de huidige waarde
van de vlag niet leeg is.
.P
De configuratiebestanden kunnen commentaar bevatten op regels die beginnen
met een hekje (#). Ook lege regels worden genegeerd.
.SH COMMANDO'S
.TP 
\fB\-\-dump\fP
Laat op standaarduitvoer alle compilatievlaggen en hun waarden zien. Dit
geeft per regel één vlag en de waarde ervan weer met daartussenin een
gelijkheidsteken (“\fIvlag\fP=\fIwaarde\fP”). Dit is de standaardactie.
.TP 
\fB\-\-list\fP
Geeft een lijst weer van vlaggen die door de huidige leverancier ondersteund
wordt (één per regel). Zie het onderdeel \fBONDERSTEUNDE VLAGGEN\fP voor meer
informatie daarover.
.TP 
\fB\-\-status\fP
Laat eventuele informatie zien die nuttig kan zijn om het gedrag te
verklaren van \fBdpkg\-buildflags\fP (sinds dpkg 1.16.5): relevante
omgevingsvariabelen, huidige leverancier, toestand van alle
functievlaggen. Geef ook de resulterende compileervlaggen met hun oorsprong
weer.

Het is de bedoeling dat dit uitgevoerd wordt vanuit \fBdebian/rules\fP, zodat
de bouwlog een duidelijk spoor van de gebruikte vlaggen kan bijhouden. Dit
kan nuttig zijn om ermee verband houdende problemen te diagnosticeren.
.TP 
\fB\-\-export=\fP\fIindeling\fP
Geef op standaarduitvoer commando's weer die gebruikt kunnen worden om alle
compilatievlaggen te exporteren ten behoeve van een specifiek
gereedschap. Indien de waarde \fIindeling\fP niet opgegeven werd, wordt \fBsh\fP
verondersteld. Enkel compilatievlaggen die met een hoofdletter beginnen
worden opgenomen. Van de andere wordt aangenomen dat ze niet bruikbaar zijn
voor de omgeving. Ondersteunde indelingen:
.RS
.TP 
\fBsh\fP
Shell\-opdrachten om alle compilatievlaggen in de omgeving in te stellen en
te exporteren. Er worden aanhalingstekens geplaatst rond de vlagwaarden
waardoor de uitvoer gereed is om door een shell geëvalueerd te worden.
.TP 
\fBcmdline\fP
Argumenten om door te geven aan de commandoregel van een bouwprogramma om al
de compilatievlaggen te gebruiken (sinds dpkg 1.17.0). De vlagwaarden worden
volgens de shell\-syntaxis tussen haakjes geplaatst.
.TP 
\fBconfigure\fP
Dit is een verouderde alias voor \fBcmdline\fP.
.TP 
\fBmake\fP
Make\-opdrachten om alle compilatievlaggen in de omgeving in te stellen en te
exporteren. De uitvoer kan naar een makefile\-fragment geschreven worden en
geëvalueerd met behulp van een \fBinclude\fP\-opdracht.
.RE
.TP 
\fB\-\-get\fP\fI vlag\fP
Geef de waarde van de vlag weer op de standaarduitvoer. Sluit af met 0 bij
een gekende vlag en sluit anders af met 1.
.TP 
\fB\-\-origin\fP\fI vlag\fP
Geef de origine weer van de waarde die teruggegeven wordt door
\fB\-\-get\fP. Sluit af met 0 bij een gekende vlag en sluit anders af met 1. De
origine kan één van de volgende waarden hebben:
.RS
.TP 
\fBvendor\fP
de originele vlag die door de leverancier ingesteld werd, wordt
teruggegeven;
.TP 
\fBsystem\fP
de vlag werd ingesteld/gewijzigd door een systeemconfiguratie;
.TP 
\fBuser\fP
de vlag werd ingesteld/gewijzigd door een gebruikersspecifieke configuratie;
.TP 
\fBenv\fP
de vlag werd ingesteld/gewijzigd door een omgevingsspecifieke configuratie.
.RE
.TP 
\fB\-\-query\-features\fP\fI gebied\fP
Geef de functionaliteit weer die voor een opgegeven gebied geactiveerd is
(sinds dpkg 1.16.2). Momenteel worden door Debian en zijn derivaten enkel de
gebieden \fBqa\fP, \fBreproducible\fP, \fBsanitize\fP en \fBhardening\fP erkend. Zie het
onderdeel \fBFUNCTIONALITEITSGEBIEDEN\fP voor meer details. Sluit af met 0 als
het gebied gekend is, anders met 1.
.IP
De uitvoer is in RFC822\-indeling met één sectie per functie. Bijvoorbeeld:
.IP
.nf
  Feature: pie
  Enabled: yes

  Feature: stackprotector
  Enabled: yes
.fi
.TP 
\fB\-\-help\fP
Toon info over het gebruik en sluit af.
.TP 
\fB\-\-version\fP
Toon de versie en sluit af.
.
.SH "ONDERSTEUNDE VLAGGEN"
.TP 
\fBCFLAGS\fP
Opties voor de C\-compiler. De door de leverancier ingestelde standaardwaarde
bestaat uit \fB\-g\fP en het standaardniveau van optimalisatie (gewoonlijk
\fB\-O2\fP, of \fB\-O0\fP indien de omgevingsvariabele \fBDEB_BUILD_OPTIONS\fP \fInoopt\fP
aangeeft).
.TP 
\fBCPPFLAGS\fP
Opties voor de C\-preprocessor. Standaardwaarde: leeg.
.TP 
\fBCXXFLAGS\fP
Opties voor de C++ compiler. Hetzelfde als \fBCFLAGS\fP.
.TP 
\fBOBJCFLAGS\fP
Opties voor de Objective C compiler. Hetzelfde als \fBCFLAGS\fP.
.TP 
\fBOBJCXXFLAGS\fP
Opties voor de Objective C++ compiler. Hetzelfde als \fBCXXFLAGS\fP.
.TP 
\fBGCJFLAGS\fP
Opties voor de GNU Java compiler (gcj). Een subset van \fBCFLAGS\fP.
.TP 
\fBFFLAGS\fP
Opties voor de Fortran 77 compiler. Een subset van \fBCFLAGS\fP.
.TP 
\fBFCFLAGS\fP
Opties voor de Fortran 9x compiler. Hetzelfde als \fBFFLAGS\fP.
.TP 
\fBLDFLAGS\fP
Opties die aan de compiler doorgegeven worden bij het linken van uitvoerbare
programma's en gedeelde objecten (indien de linker rechtstreeks aangeroepen
wordt, dan moeten \fB\-Wl\fP en \fB,\fP van die opties verwijderd
worden). Standaardwaarde: leeg.
.PP
In de toekomst kunnen nog andere vlaggen toegevoegd worden als daar behoefte
aan ontstaat (bijvoorbeeld om andere talen te ondersteunen).
.
.SH FUNCTIONALITEITSGEBIEDEN
.P
Elke gebiedsfunctionaliteit kan in de gebiedswaarde van de
omgevingsvariabelen \fBDEB_BUILD_OPTIONS\fP en \fBDEB_BUILD_MAINT_OPTIONS\fP
ingeschakeld en uitgeschakeld worden met de schakelaars ‘\fB+\fP’ en ‘\fB\-\fP’. Om
bijvoorbeeld de \fBhardening\fP\-functionaliteit “pie” te activeren en de
functionaliteit “fortify” uit te schakelen, kunt u in \fBdebian/rules\fP het
volgende doen:
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=+pie,\-fortify
.P
De bijzondere functionaliteit \fBall\fP (geldig in elk gebied) kan gebruikt
worden om gelijktijdig alle gebiedsfunctionaliteit te activeren of uit te
schakelen. Alles uitschakelen in het gebied \fBhardening\fP en enkel “format”
en “fortify” activeren kunt u dus doen met:
.P
  export DEB_BUILD_MAINT_OPTIONS=hardening=\-all,+format,+fortify
.
.SS "qa (kwaliteitsbevordering)"
Er kunnen verschillende compilatieopties (die hierna beschreven worden)
gebruikt worden om problemen in de broncode of het bouwsysteem te helpen
detecteren.
.TP 
\fBbug\fP
Deze instelling (die standaard uitgeschakeld is) voegt alle
waarschuwingsopties toe die op een betrouwbare wijze problematische broncode
opsporen. De waarschuwingen zijn fataal. De enige vlaggen die momenteel
ondersteund worden zijn \fBCFLAGS\fP en \fBCXXFLAGS\fP waarbij de vlaggen
ingesteld staan op \fB\-Werror=array\-bounds\fP, \fB\-Werror=clobbered\fP,
\fB\-Werror=implicit\-function\-declaration\fP en
\fB\-Werror=volatile\-register\-var\fP.
.
.TP 
\fBcanary\fP
Deze instelling (die standaard uitgeschakeld is) voegt loze
kanarievogelopties toe aan de bouwvlaggen, zodat in de bouwlogs nagekeken
kan worden hoe de bouwvlaggen doorgegeven worden en zodat het eventueel
ontbreken van normale bouwvlaginstellingen ontdekt kan worden. Momenteel
zijn de enige ondersteunde vlaggen \fBCPPFLAGS\fP, \fBCFLAGS\fP, \fBOBJCFLAGS\fP,
\fBCXXFLAGS\fP en \fBOBJCXXFLAGS\fP, waarbij die vlaggen als
\fB\-D__DEB_CANARY_\fP\fIvlag\fP_\fIwillekeurige\-id\fP\fB__\fP ingesteld worden, en
\fBLDFLAGS\fP dat ingesteld wordt op \fB\-Wl,\-z,deb\-canary\-\fP\fIwillekeurige\-id\fP.
.
.SS "sanitize (saneren)"
Er kunnen verschillende compilatie\-opties (die hierna beschreven worden)
gebruikt worden om te helpen bij het gezond houden van een resulterend
binair pakket op het vlak van geheugenvervuiling, geheugenlekkage,
geheugengebruik na vrijgave, dataraces bij threads en bugs door
ongedefinieerd gedrag.
.TP 
\fBaddress\fP
Deze instelling (standaard uitgeschakeld) voegt \fB\-fsanitize=address\fP toe
aan \fBLDFLAGS\fP en \fB\-fsanitize=address \-fno\-omit\-frame\-pointer\fP aan
\fBCFLAGS\fP en aan \fBCXXFLAGS\fP.
.TP 
\fBthread\fP
Deze instelling (standaard uitgeschakeld) voegt \fB\-fsanitize=thread\fP toe aan
\fBCFLAGS\fP, \fBCXXFLAGS\fP en \fBLDFLAGS\fP.
.TP 
\fBleak\fP
Deze instelling (standaard uitgeschakeld) voegt \fB\-fsanitize=leak\fP toe aan
\fBLDFLAGS\fP. Ze wordt automatisch uitgeschakeld als ofwel de
\fBaddress\fP\-functionaliteit of de \fBthread\fP\-functionaliteit geactiveerd is,
aangezien die dit impliceren.
.TP 
\fBundefined\fP
Deze instelling (standaard uitgeschakeld) voegt \fB\-fsanitize=undefined\fP toe
aan \fBCFLAGS\fP, \fBCXXFLAGS\fP en \fBLDFLAGS\fP.
.SS "hardening (kwetsbaarheidsreductie)"
Er kunnen verschillende compilatie\-opties (die hierna beschreven worden)
gebruikt worden om te helpen bij het versterken van een resulterend binair
pakket tegen geheugenvervuilingsaanvallen of om bijkomende
waarschuwingsberichten te geven tijdens het compileren. Behalve wanneer
hierna anders aangegeven is, worden deze opties standaard geactiveerd voor
architecturen die ze ondersteunen.
.TP 
\fBformat\fP
Deze instelling (standaard geactiveerd) voegt \fB\-Wformat
\-Werror=format\-security\fP toe aan \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP en
\fBOBJCXXFLAGS\fP. Dit zal waarschuwingen geven bij verkeerd gebruik van
indelingstekenreeksen en zal mislukken als indelingsfuncties gebruikt worden
op een manier die mogelijke veiligheidsproblemen tot gevolg kunnen
hebben. Momenteel geeft dit een waarschuwing als een \fBprintf\fP\-functie of
een \fBscanf\fP\-functie aangeroepen wordt met een indelingstekenreeks die geen
letterlijke tekenreeks is en er ook geen indelingsargumenten opgegeven
werden, zoals bij \fBprintf(foo);\fP in plaats van \fBprintf("%s", foo);\fP. Dit
kan een veiligheidslek zijn als de indelingstekenreeks afkomstig was van
onbetrouwbare invoer en ‘%n’ bevat.
.
.TP 
\fBfortify\fP
Deze instelling (standaard geactiveerd) voegt \fB\-D_FORTIFY_SOURCE=2\fP toe aan
\fBCPPFLAGS\fP. Tijdens het produceren van de code heeft de compiler een
heleboel informatie over buffergroottes (waar mogelijk), en tracht een
functieaanroep met een onveilige ongelimiteerde buffergrootte te vervangen
door een functieaanroep met een gelimiteerde buffergrootte. Dit is in het
bijzonder nuttig bij oude en slecht geschreven code. Daarnaast wordt het
gebruik in het voor schrijven toegankelijk geheugen van
indelingstekenreeksen die ‘%n’ bevatten, geblokkeerd. Indien een toepassing
op een dergelijke indelingstekenreeks steunt, zal het er een alternatief
voor moeten gebruiken.

Merk op dat de code ook met \fB\-O1\fP of hoger gecompileerd moet worden opdat
deze optie effect zou hebben. Indien de omgevingsvariabele
\fBDEB_BUILD_OPTIONS\fP \fInoopt\fP bevat, dan wordt ondersteuning voor \fBfortify\fP
uitgeschakeld. Dit is te wijten aan nieuwe waarschuwingen die gegeven worden
door glibc 2.16 en hoger.
.TP 
\fBstackprotector\fP
Deze instelling (standaard geactiveerd als stackprotectorstrong niet
gebruikt wordt) voegt \fB\-fstack\-protector \-\-param=ssp\-buffer\-size=4\fP toe aan
\fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP
en \fBFCFLAGS\fP. Dit voegt beveiligingscontroles tegen het overschrijven van
de stack toe. Dit maakt dat bij veel mogelijke code\-injectieaanvallen
afgebroken wordt. In het beste geval wordt op die manier een kwetsbaarheid
voor code\-injectie omgebogen tot een denial\-of\-service (dienst niet
beschikbaar) of een fictief probleem (afhankelijk van de toepassing).

Deze functionaliteit vereist het linken van de code met glibc (of een andere
aanbieder van \fB__stack_chk_fail\fP) en moet dus uitgeschakeld worden als er
gebouwd wordt met \fB\-nostdlib\fP of \fB\-ffreestanding\fP of iets gelijkaardigs.
.
.TP 
\fBstackprotectorstrong\fP
Deze instelling (standaard geactiveerd) voegt \fB\-fstack\-protector\-strong\fP
toe aan \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP,
\fBFFLAGS\fP en \fBFCFLAGS\fP. Dit is een sterkere variant van \fBstackprotector\fP,
maar zonder noemenswaardig prestatieverlies.

Het uitzetten van \fBstackprotector\fP schakelt ook deze functionaliteit uit.

Deze functionaliteit stelt dezelfde vereisten als \fBstackprotector\fP en heeft
daarenboven ook gcc 4.9 of een recentere versie nodig.
.
.TP 
\fBrelro\fP
Deze instelling (standaard geactiveerd) voegt \fB\-Wl,\-z,relro\fP toe aan
\fBLDFLAGS\fP. Tijdens het laden van het programma moet de linker in
verschillende ELF\-geheugensecties schrijven. Dit zet voor de programmalader
een vlag zodat die deze secties alleen\-lezen maakt alvorens de controle over
te dragen aan het programma. Het meest noemenswaardige effect is dat dit
aanvallen door het overschrijven van de Global Offset Table (GOT)
voorkomt. Indien deze optie uitgeschakeld wordt, wordt ook \fBbindnow\fP
uitgezet.
.
.TP 
\fBbindnow\fP
Deze instelling (standaard uitgeschakeld) voegt \fB\-Wl,\-z,now\fP toe aan
\fBLDFLAGS\fP. Tijdens het laden van het programma worden alle dynamische
symbolen omgezet, waardoor de volledige PLT (Procedure Linkage Table) als
alleen lezen gemarkeerd kan worden (ten gevolge van \fBrelro\fP hiervoor). Deze
optie kan niet aangezet worden als \fBrelro\fP niet geactiveerd is.
.
.TP 
\fBpie\fP
This setting (with no default since dpkg 1.18.23, and injected by default by
gcc on the amd64, arm64, armel, armhf, i386, kfreebsd\-amd64, kfreebsd\-i386,
mips, mipsel, mips64el, ppc64el, s390x, sparc and sparc64 Debian
architectures)  adds the required options via gcc specs files if needed to
enable or disable PIE. When enabled and injected by gcc, adds nothing. When
enabled and not injected by gcc, adds \fB\-fPIE\fP to \fBCFLAGS\fP, \fBCXXFLAGS\fP,
\fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP, and
\fB\-fPIE \-pie\fP to \fBLDFLAGS\fP. When disabled and injected by gcc, adds
\fB\-fno\-PIE\fP to \fBCFLAGS\fP, \fBCXXFLAGS\fP, \fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP,
\fBGCJFLAGS\fP, \fBFFLAGS\fP and \fBFCFLAGS\fP, and \fB\-fno\-PIE \-no\-pie\fP to
\fBLDFLAGS\fP.

Position Independent Executable (PIE \- positie\-onafhankelijke programma's)
zijn nodig om voordeel te halen uit Address Space Layout Randomization (ASLR
\- de adresruimte rangschikken in toevallige volgorde), hetgeen door sommige
kernelversies ondersteund wordt. Hoewel ASLR reeds voor datagebieden in de
stack en de heap opgelegd kan worden (brk and mmap), moeten de codegebieden
als positieonafhankelijk gecompileerd worden. Gedeelde bibliotheken doen dit
reeds (\fB\-fPIC\fP), waardoor zij automatisch ASLR krijgen, maar binaire
\&.text\-gebieden moeten als PIE gebouwd worden om ASLR te krijgen. Als dit
gebeurt, worden aanvallen van het type ROP (Return Oriented Programming \- op
terugkeerwaarde georiënteerd programmeren) veel moeilijker aangezien er geen
statische locaties meer zijn die bij een aanval van geheugenvervuiling als
springplank gebruikt kunnen worden.

PIE is niet compatibel met \fB\-fPIC\fP, dus over het algemeen moet men
voorzichtig zijn bij het bouwen van gedeelde objecten. Maar aangezien de
PIE\-vlaggen die meegegeven worden geïnjecteerd worden via specs\-bestanden
van gcc, zou het altijd veilig moeten zijn om ze onvoorwaardelijk in te
stellen ongeacht het objecttype dat gecompileerd of gelinkt wordt.

Statische bibliotheken kunnen door programma's of door andere gedeelde
bibliotheken gebruikt worden. Afhankelijk van de gebruikte vlaggen bij het
compileren van alle objecten in een statische bibliotheek, zullen deze
bibliotheken door verschillende reeksen objecten gebruikt kunnen worden:

.RS
.TP 
geen
Kan niet gelinkt worden aan een PIE\-programma, noch aan een gedeelde
bibliotheek.
.TP 
\fB\-fPIE\fP
Kan gelinkt worden aan elk programma, maar niet aan een gedeelde bibliotheek
(aanbevolen).
.TP 
\fB\-fPIC\fP
Kan gelinkt worden aan elk programma en elke gedeelde bibliotheek.
.RE

.IP
Indien er een behoefte bestaat om deze vlaggen manueel in te stellen en de
gcc specs\-injectie te overbruggen, moet u rekening houden met verschillende
zaken. Het onvoorwaardelijk en expliciet doorgeven van \fB\-fPIE\fP, \fB\-fpie\fP of
\fB\-pie\fP aan een bouwsysteem dat libtool gebruikt, is veilig aangezien deze
vlaggen weggelaten worden bij het bouwen van gedeelde bibliotheken. Bij
projecten waarin daarentegen zowel programma's als gedeelde bibliotheken
gebouwd worden, moet u ervoor zorgen dat bij het bouwen van de gedeelde
bibliotheken \fB\-fPIC\fP steeds als laatste doorgegeven wordt (waardoor het een
eventuele voorafgaande \fB\-PIE\fP opheft) aan compilatievlaggen zoals \fBCFLAGS\fP
en dat \fB\-shared\fP als laatste doorgegeven wordt (waardoor het een eventuele
voorafgaande \fB\-pie\fP opheft) aan linkvlaggen zoals \fBLDFLAGS\fP. \fBOpmerking:\fP
dit is niet nodig met het standaard specs\-mechanisme van gcc.

.IP
Aangezien PIE via een algemeen register geïmplementeerd wordt, kunnen
bovendien bij sommige architecturen (maar niet meer bij i386 sinds de
optimalisaties die in gcc >= 5 toegepast zijn) prestatieverminderingen
tot 15% optreden bij zeer zware belasting met tekstsegmenten van
toepassingen. De meeste belastingen hebben minder dan 1%
prestatievermindering tot gevolg. Architecturen met meer algemene registers
(bijv. amd64) vertonen niet zo een hoge terugval in de ergste gevallen.
.SS "reproducible (reproduceerbaar)"
De hierna behandelde compilatieopties kunnen gebruikt worden om de
bouwreproduceerbaarheid te helpen verbeteren of om bijkomende
waarschuwingsberichten af te leveren tijdens het compileren. Behalve wanneer
het hierna aangegeven wordt, worden deze opties standaard geactiveerd voor
architecturen die ze ondersteunen.
.TP 
\fBtimeless\fP
Deze instelling (standaard geactiveerd) voegt \fB\-Wdate\-time\fP toe bij
\fBCPPFLAGS\fP. Dit leidt tot waarschuwingen als de macros \fB__TIME__\fP,
\fB__DATE__\fP en \fB__TIMESTAMP__\fP gebruikt worden.
.
.TP 
\fBfixdebugpath\fP
Deze instelling (standaard geactiveerd) voegt
\fB\-fdebug\-prefix\-map=\fP\fIBUILDPATH\fP\fB=.\fP toe aan \fBCFLAGS\fP, \fBCXXFLAGS\fP,
\fBOBJCFLAGS\fP, \fBOBJCXXFLAGS\fP, \fBGCJFLAGS\fP, \fBFFLAGS\fP en \fBFCFLAGS\fP, waarbij
\fBBUILDPATH\fP ingesteld wordt op de basismap van het pakket dat gebouwd
wordt. Dit heeft als effect dat het bouwpad verwijderd wordt van eventueel
gegenereerde debug\-symbolen.
.
.SH OMGEVING
Er zijn twee sets omgevingsvariabelen die dezelfde operaties uitvoeren. De
eerste (DEB_\fIvlag\fP_\fIoperatie\fP) zou nooit gebruikt mogen worden binnen
\fBdebian/rules\fP. Die is bedoeld voor eventuele gebruikers die het bronpakket
opnieuw willen bouwen met andere bouwvlaggen. De tweede set
(DEB_\fIvlag\fP_MAINT_\fIoperatie\fP) zou door pakketonderhouders enkel in
\fBdebian/rules\fP gebruikt moeten worden om de resulterende bouwvlaggen aan te
passen.
.TP 
\fBDEB_\fP\fIvlag\fP\fB_SET\fP
.TQ
\fBDEB_\fP\fIvlag\fP\fB_MAINT_SET\fP
Deze variabele kan gebruikt worden om de teruggegeven waarde voor de
opgegeven vlag \fIvlag\fP af te dwingen.
.TP 
\fBDEB_\fP\fIvlag\fP\fB_STRIP\fP
.TQ
\fBDEB_\fP\fIvlag\fP\fB_MAINT_STRIP\fP
Deze variabele kan gebruikt worden om in een lijst met witruimte als
scheidingsteken opties op te geven die weggehaald zullen worden uit de set
vlaggen die teruggegeven wordt voor de opgegeven \fIvlag\fP.
.TP 
\fBDEB_\fP\fIvlag\fP\fB_APPEND\fP
.TQ
\fBDEB_\fP\fIvlag\fP\fB_MAINT_APPEND\fP
Deze variabele kan gebruikt worden om bijkomende opties toe te voegen aan de
waarde die teruggegeven wordt voor de opgegeven \fIvlag\fP.
.TP 
\fBDEB_\fP\fIvlag\fP\fB_PREPEND\fP
.TQ
\fBDEB_\fP\fIvlag\fP\fB_MAINT_PREPEND\fP
Deze variabele kan gebruikt worden om vooraan bijkomende opties toe te
voegen aan de waarde die teruggegeven wordt voor de opgegeven \fIvlag\fP.
.TP 
\fBDEB_BUILD_OPTIONS\fP
.TQ
\fBDEB_BUILD_MAINT_OPTIONS\fP
Deze variabelen kunnen door een gebruiker of een onderhouder gebruikt worden
om diverse gebiedsfuncties die bouwvlaggen beïnvloeden, te activeren of uit
te zetten. De variabele \fBDEB_BUILD_MAINT_OPTIONS\fP vervangt eventuele
instellingen in de functionaliteitsgebieden \fBDEB_BUILD_OPTIONS\fP. Zie het
onderdeel \fBFUNCTIONALITEITSGEBIEDEN\fP voor de details.
.TP 
\fBDEB_VENDOR\fP
Deze instelling definieert de huidige leverancier. Indien zij niet ingesteld
is, zal gezocht worden naar de huidige leverancier door te gaan lezen in
\fB%PKGCONFDIR%/origins/default\fP.
.TP 
\fBDEB_BUILD_PATH\fP
Deze variabele stelt in welk bouwpad (sinds dpkg 1.18.8) gebruikt moet
worden bij functionaliteit zoals \fBfixdebugpath\fP waardoor die gesuperviseerd
kan worden door het aanroepende programma. Momenteel is deze variabele
Debian\- en derivaat\-specifiek.
.
.SH BESTANDEN
.SS Configuratiebestanden
.TP 
\fB%PKGCONFDIR%/buildflags.conf\fP
Configuratiebestand dat voor het hele systeem geldt.
.TP 
\fB$XDG_CONFIG_HOME/dpkg/buildflags.conf\fP of 
.TQ
\fB$HOME/.config/dpkg/buildflags.conf\fP
Configuratiebestand dat gebruikersafhankelijk is.
.SS "Ondersteuning bij het maken van een pakket"
.TP 
\fB%PKGDATADIR%/buildflags.mk\fP
Makefile\-fragment dat alle vlaggen die door \fBdpkg\-buildflags\fP ondersteund
worden, laadt in variabelen (en eventueel exporteert) (sinds dpkg 1.16.1).
.
.SH VOORBEELDEN
Om in een makefile bouwvlaggen door te geven aan een bouwcommando:
.PP
.RS 4
.nf
$(MAKE) $(shell dpkg\-buildflags \-\-export=cmdline)

\&./configure $(shell dpkg\-buildflags \-\-export=cmdline)
.fi
.RE
.PP
Om in een shell\-script of shell\-fragment bouwvlaggen in te stellen, kan
\fBeval\fP gebruikt worden om de uitvoer te interpreteren van en de vlaggen
naar de omgeving te exporteren:
.PP
.RS 4
.nf
eval "$(dpkg\-buildflags \-\-export=sh)" && make
.fi
.RE
.PP
of om de positieparameters in te stellen die aan een commando doorgegeven
moeten worden:
.PP
.RS 4
.nf
eval "set \-\- $(dpkg\-buildflags \-\-export=cmdline)"
for dir in a b c; do (cd $dir && ./configure "$@" && make); done
.fi
.RE
.
.SS "Het gebruik in debian/rules"
Om de benodigde bouwvlaggen te bekomen die aan het bouwsysteem doorgegeven
moeten worden, moet u vanuit het bestand \fBdebian/rules\fP \fBdpkg\-buildflags\fP
aanroepen of \fBbuildflags.mk\fP invoegen. Merk op dat oudere versies van
\fBdpkg\-buildpackage\fP (voor dpkg 1.16.1) deze vlaggen automatisch
exporteerden. U zou hierop echter niet mogen betrouwen, aangezien dit het
handmatig aanroepen van \fBdebian/rules\fP defect maakt.
.PP
Voor pakketten met een autoconf\-achtig bouwsysteem, kunt u de relevante
opties rechtstreeks doorgeven aan configure of \fBmake\fP(1), zoals hiervoor
geïllustreerd werd.
.PP
Voor andere bouwsystemen, of indien u een meer fijnmazige controle nodig
heeft over welke vlaggen waar doorgegeven worden, kunt u \fB\-\-get\fP
gebruiken. Of in de plaats daarvan kunt u \fBbuildflags.mk\fP invoegen, dat
zorgt voor het aanroepen van \fBdpkg\-buildflags\fP en het opslaan van de
bouwvlaggen in variabelen voor make.
.PP
Indien u alle bouwvlaggen naar de omgeving wenst te exporteren (waar ze door
uw bouwsysteem opgepikt kunnen worden):
.PP
.RS 4
.nf
DPKG_EXPORT_BUILDFLAGS = 1
include %PKGDATADIR%/buildflags.mk
.fi
.RE
.PP
Als u bijkomende controle wenst over wat geëxporteerd wordt, kunt u de
variabelen handmatig exporteren (aangezien er standaard geen enkele
geëxporteerd wordt):
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
export CPPFLAGS CFLAGS LDFLAGS
.fi
.RE
.PP
En u kunt de vlaggen natuurlijk ook handmatig doorgeven aan commando's:
.PP
.RS 4
.nf
include %PKGDATADIR%/buildflags.mk
build\-arch:
\&	$(CC) \-o hello hello.c $(CPPFLAGS) $(CFLAGS) $(LDFLAGS)
.fi
.RE
