@echo off

rem this script builds Engauge Digitizer for MS Windows platforms
rem usage: release_windows.bat version_number_prefix version_number_suffix [build_directory]
rem author: mark mitchell

rem release directory %releaseDir% should be in current directory, to be
rem consistent with the linux and osx environments where it is required so
rem the release directory ends up in the user's current directory when he/she untars!
rem even though you can use '..\engauge' for the release directory with no
rem problems, specifying '..\..\engauge' does not work. therefore, it is best to
rem keep things simple, and consistent with the other environments, by not
rem using '..' or '/' in the value of %releaseDir%
set releaseDir=engauge

rem parse optional command line argument to override directory defaults
if "%1" == "" goto usage
if "%2" == "" goto usage
set version=%1_%2
if "%3" == "" goto noDirectory
   set releaseDir=%3%
:noDirectory

set zipFile=..\digit-exe-windows-%version%.zip

echo 
echo Version number: %version%
echo Building release in directory: %releaseDir%
echo Writing to zip file: %zipFile%

rem clean up release directory. use prompt since empty entry would delete drive
del /s /q %releaseDir%

rem make directory tree
echo Recreating release directory...
mkdir %releaseDir%
mkdir %releaseDir%\samples
mkdir %releaseDir%\usermanual

rem copy files. note that all wildcard copies are performed with file suffixes
rem so the CVS subdirectory is not copied
echo Copying files...
copy bin\digitizer.exe %releaseDir%
copy bin\digitizer.exe.local %releaseDir%
copy LICENSE %releaseDir%
copy samples\*.bmp %releaseDir%\samples 
copy samples\*.gif %releaseDir%\samples 
copy samples\*.jpg %releaseDir%\samples 
copy samples\*.png %releaseDir%\samples 
copy usermanual\*.bmp %releaseDir%\usermanual 
copy usermanual\*.gif %releaseDir%\usermanual 
copy usermanual\*.html %releaseDir%\usermanual 
copy usermanual\*.jpg %releaseDir%\usermanual 
copy usermanual\*.png %releaseDir%\usermanual

rem we made it this far, so finish up by zipping up the release
echo Writing zip file...
"\program files\winzip\winzip32.exe" -a -r %zipFile% %releaseDir%

goto end

:usage

echo Usage: release_windows.bat version_number_prefix version_number_suffix [build_directory]

:end
