/*
 * fdatest.c - Free Debug Allocator
 * Copyright (C) 1997 Thomas Helvey <tomh@inxpress.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include "fda.h"
#include <assert.h>

#define ALLOC_SIZE 100000

void location_enumerator(const char* file, int line, int count)
{
  printf("%s line: %d count: %d\n", file, line, count);
}

void leak_enumerator(const char* file, int line, size_t size, void* ptr)
{
  printf("Memory leak: %s: %d - %d bytes (%p)\n", file, line, size, ptr);
}

int main(void)
{
  static void* allocations[100];
  char* str;
  char* realloc_ptr;
  int i;
  
  for (i = 0; i < 100; ++i) {
    allocations[i] = Malloc(ALLOC_SIZE);
    assert(valid_ptr(allocations[i], ALLOC_SIZE));
    assert(fda_sizeof(allocations[i]) == ALLOC_SIZE);
  }
  str = DupString("This is a string test");
  realloc_ptr = Malloc(100);
  realloc_ptr = Realloc(realloc_ptr, 1000);
  printf("Allocations ok\n");
  printf("str has %d bytes allocated\n", fda_sizeof(str));
  for (i = 0; i < 100; ++i)
    fda_set_ref(allocations[i]);
  fda_set_ref(str);
  fda_set_ref(realloc_ptr);
  printf("Location listing\n");
  i = fda_enum_locations(location_enumerator);
  printf("Total locations: %d\n", i);
  fda_assert_refs();
  fda_clear_refs();
  for (i = 0; i < 100; ++i)
    Free(allocations[i]);
  realloc_ptr = Realloc(realloc_ptr, 100);
  fda_set_ref(str);
  fda_set_ref(realloc_ptr);
  assert(valid_ptr(realloc_ptr, 100));
  fda_assert_refs();
  Free(str);
  Free(realloc_ptr);
  fda_assert_refs();
  for (i = 0; i < 10; ++i)
    allocations[i] = Malloc((i + 1) * 11);
  str = DupString("Hello There");
  realloc_ptr = str++;
  str++;
  printf("checking offset ptr\n");
  assert(valid_ptr(str, 9));
  Free(realloc_ptr);
  printf("Listing memory leaks\n");
  i = fda_enum_leaks(leak_enumerator);
  printf("Total Leaks: %d\n", i);
  for (i = 0; i < 10; ++i)
    Free(allocations[i]);
  fda_assert_refs();
  printf("fdatest completed with no errors\n");
  return 0;
}

