/* $Id: spritetest.c,v 1.2 2003/06/07 15:51:43 sjoerd Exp $ */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <SDL.h>

#include <sprite.h>
#include <svg.h>
#include <global.h>

#ifndef NDEBUG
int debugmask = 0;
#endif 
int quit = FALSE;

char *
load_svgs_file(void) {
#define BUFSIZE 1024
  char * result = NULL;
  int fd;
  char buf[BUFSIZE];
  int size = 0,ret;

  fd = open("testsvgs.xml",O_RDONLY);
  if (fd == -1) {
    WARN("Couldn't open test file");
    exit(-1);
  }
  while ((ret = read(fd,buf,BUFSIZE)) > 0) {
    result = realloc(result,size+ret);
    memcpy(result+size,buf,ret);
    size += ret;
  }
  if (ret < 0) {
    WARN("Reading from file failed: %s",strerror(errno));
    exit(-1);
  }
  close(fd);

  result = realloc(result,size+1);
  result[size] = '\0';
  return result;
}

static int
event_filter(const SDL_Event *event) {
  if (event->type == SDL_QUIT ||
      (event->type == SDL_KEYDOWN && event->key.keysym.sym == SDLK_ESCAPE)) {
    quit = TRUE;
  }
  return TRUE;
}

int
main(int argc, char **argv) {
  char *xml;
  Graphics_svg_series *gss;
  Graphics_sprite_source *spritesource;
  Graphics_sprite_anim *anim;
  SDL_Surface *screen;
  Vector *size;
  Uint32 starttick;
  Uint32 time;
  int i;

  xml = load_svgs_file();

  if (SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_NOPARACHUTE) < 0) {
    WARN(_("SDL initialisation failed: %s"),SDL_GetError());
    exit(-1);
  }
  atexit(SDL_Quit);
  SDL_SetEventFilter(event_filter);

  gss = parse_svg_series(xml);
  if (gss == NULL) {
    WARN("Svgs parsing failed");
  }
  spritesource = gss_to_sprite_source(gss);
  del_gss(gss);

  screen = SDL_SetVideoMode(640,480,0,SDL_DOUBLEBUF|SDL_HWPALETTE);
  SDL_FillRect(screen,NULL,SDL_MapRGB(screen->format,0xff,0xff,0xff));
  size = new_vector(640,480);

  anim = draw_sprite_anim(screen,size,SS_PLAYER_DEAD,spritesource);
  SDL_BlitSurface(anim->anim[0],NULL,screen,NULL);
  SDL_Flip(screen);
  SDL_PumpEvents();

  starttick = SDL_GetTicks();
  for (i = 0 ; i < 10 ; i++) {
    draw_sprite_anim(screen,size,SS_PLAYER_DEAD,spritesource);
  }
  time = SDL_GetTicks() - starttick;
  INFO("%d animations in %d ms = %d ms/frame",i,time,time/i);

  while (!quit) {
    SDL_Delay(40);
    SDL_Flip(screen);
    SDL_PumpEvents();
  }

  exit(0);
  return TRUE;
}
