/* You may find the license in the LICENSE file */

const Cc = Components.classes;
const Ci = Components.interfaces;
const error = Components.utils.reportError;
const Cr = Components.results;
const importModule = Components.utils.import;

function debug(str, ex) {
	try {
		var _debugServ = Components.classes['@downthemall.net/debug-service;1']
			.getService(Components.interfaces.dtaIDebugService);
		debug = function(str, ex) {
			if (ex) {
				_debugServ.log(str, ex);
			}
			else {
				_debugServ.logString(str);
			}
		}
		debug(str, ex);
	}
	catch (ex) {
		error(str + ": " + ex);
	}
}

function implementComponent(obj, classID, contractID, description, interfaces) {
	[
		Ci.nsISupports,
		Ci.nsIClassInfo,
		Ci.nsISupportsWeakReference,
		Ci.nsIWeakReference,
	].forEach(
		function(i) {
			if (interfaces.indexOf(i) == -1) {
				interfaces.push(i);
			}
		}
	);
	obj.interfaces = interfaces;
	
	// implement me
	obj.classID = classID;
	obj.classIDNoAlloc = obj.classID;
	obj.classDescription = description;
	obj.contractID = contractID;
	
	obj.implementationLanguage = Ci.nsIProgrammingLanguage.JAVASCRIPT;
	obj.flags = Ci.nsIClassInfo.MAIN_THREAD_ONLY;
	obj.getHelperForLanguage = function() {
		return null;
	};
	obj.getInterfaces = function(count) {
		count.value = this.interfaces.length;
		return this.interfaces;
	};
	obj.implementsIID = function(iid) {
			return this.interfaces.some(function(e) { return iid.equals(e); });
	};
	obj.QueryInterface = function(iid) {
		if (this.implementsIID(iid)) {
			return this;
		}
		throw Cr.NS_ERROR_NO_INTERFACE;
	};
	obj.QueryReferent = function(iid) {
		return this.QueryInterface(iid);
	};
	obj.GetWeakReference = function() {
		return this;
	};	
} 

function ServiceModule(service, appStartup) {
	this._service = service;
	this._appStartup = appStartup;
};

ServiceModule.prototype = {
	_firstTime: true,

	registerSelf: function M_registerSelf(compMgr, fileSpec, location, type) {
		if (!this._firstTime) {
			return;
		}
		this._firstTime = false;

		compMgr.QueryInterface(Ci.nsIComponentRegistrar)
			.registerFactoryLocation(
				this._service.classID,
				this._service.classDescription,
				this._service.contractID,
				fileSpec,
				location,
				type
			);
		if (this._appStartup) {
			Cc['@mozilla.org/categorymanager;1']
				.getService(Ci.nsICategoryManager)
				.addCategoryEntry(
					'app-startup',
					this._service.contractID,
					this._service.contractID,
					true,
					true,
					null
				);
		}
	},
	unregisterSelf: function(compMgr, fileSpec, location) {
		compMgr.QueryInterface(Ci.nsIComponentRegistrar)
			.unregisterFactoryLocation(
				this._service.classID,
				fileSpec
			);
		if (this._appStartup) {
			Cc['@mozilla.org/categorymanager;1']
			.getService(Ci.nsICategoryManager)
			.deleteCategoryEntry(
				'app-startup',
				this._service.contractID,
				true
			);
		}
	},
	getClassObject: function (compMgr, cid, iid) {
		if (cid.equals(this._service.classID)) {
			return this;
		}
		throw Cr.NS_ERROR_NO_INTERFACE;
	},
	canUnload: function(compMgr) {
		return true;
	},

	// nsIFactory
	QueryInterface : function(aIID) {
		if (aIID.equals(Ci.nsIFactory)) {
			return this;
		}

		return Cr.NS_ERROR_NO_INTERFACE;
	},
	createInstance: function (outer, iid) {
		if (outer != null) {
			throw Cr.NS_ERROR_NO_AGGREGATION;
		}
		if ('init' in this._service) {
			this._service.init();
		}
		return this._service.QueryInterface(iid);
	}
};
