/*
 *  filter.h - Filtering mechanism
 *  
 *  Copyright (C) 1999 Robert Cheramy <tibob@via.ecp.fr>
 *  Copyright (C) 1999 Andres Krapf <dae@via.ecp.fr>
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef FILTER_H
#define FILTER_H

#define SRC 1
#define DST 2

struct s_host {
  u_int32_t ip;
  u_int32_t mask;
};


struct s_filter {
  struct s_filter *next;

  /* Log in table ? NONE (0), FROM (1), TO (2), BOTH (3) */
  int tlog;
  /* IP Match for _t_able log */
  struct s_host thost;

  /* What to do with the _o_ther IP of the header */
  /* Do log ? 1 (TRUE) => LOG; 0 (FALSE) => IGNORE */
  int             olog;
  /* IP Domain to log */
  struct s_host   ohost;
};

struct AllLogsType
{
  struct s_filter * Filter;
  struct s_data * Data;

  char * LogFile;
  int DataSize;
  int Sort;
  int (*SortFunc)(const void *, const void *);
  int ReverseLookup;
  int Append;

  unsigned long int NextDump;
  unsigned long int DumpInterval;
  unsigned long int ClearCounter;
  unsigned long int ClearInterval;

  struct AllLogsType * Next;
};

void dofilter(struct ip *p_packet);

#endif
