.TH CGGESX l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
CGGESX - compute for a pair of N-by-N complex nonsymmetric matrices (A,B), the generalized eigenvalues, the complex Schur form (S,T),
.SH SYNOPSIS
.TP 19
SUBROUTINE CGGESX(
JOBVSL, JOBVSR, SORT, SELCTG, SENSE, N, A, LDA,
B, LDB, SDIM, ALPHA, BETA, VSL, LDVSL, VSR,
LDVSR, RCONDE, RCONDV, WORK, LWORK, RWORK,
IWORK, LIWORK, BWORK, INFO )
.TP 19
.ti +4
CHARACTER
JOBVSL, JOBVSR, SENSE, SORT
.TP 19
.ti +4
INTEGER
INFO, LDA, LDB, LDVSL, LDVSR, LIWORK, LWORK, N,
SDIM
.TP 19
.ti +4
LOGICAL
BWORK( * )
.TP 19
.ti +4
INTEGER
IWORK( * )
.TP 19
.ti +4
REAL
RCONDE( 2 ), RCONDV( 2 ), RWORK( * )
.TP 19
.ti +4
COMPLEX
A( LDA, * ), ALPHA( * ), B( LDB, * ),
BETA( * ), VSL( LDVSL, * ), VSR( LDVSR, * ),
WORK( * )
.TP 19
.ti +4
LOGICAL
SELCTG
.TP 19
.ti +4
EXTERNAL
SELCTG
.SH PURPOSE
CGGESX computes for a pair of N-by-N complex nonsymmetric matrices (A,B), the generalized eigenvalues, the complex Schur form (S,T), and, optionally, the left and/or right matrices of Schur vectors (VSL
and VSR).  This gives the generalized Schur factorization

     (A,B) = ( (VSL) S (VSR)**H, (VSL) T (VSR)**H )
.br

where (VSR)**H is the conjugate-transpose of VSR.
.br

Optionally, it also orders the eigenvalues so that a selected cluster
of eigenvalues appears in the leading diagonal blocks of the upper
triangular matrix S and the upper triangular matrix T; computes
a reciprocal condition number for the average of the selected
eigenvalues (RCONDE); and computes a reciprocal condition number for
the right and left deflating subspaces corresponding to the selected
eigenvalues (RCONDV). The leading columns of VSL and VSR then form
an orthonormal basis for the corresponding left and right eigenspaces
(deflating subspaces).
.br

A generalized eigenvalue for a pair of matrices (A,B) is a scalar w
or a ratio alpha/beta = w, such that  A - w*B is singular.  It is
usually represented as the pair (alpha,beta), as there is a
reasonable interpretation for beta=0 or for both being zero.

A pair of matrices (S,T) is in generalized complex Schur form if T is
upper triangular with non-negative diagonal and S is upper
triangular.
.br

.SH ARGUMENTS
.TP 8
JOBVSL  (input) CHARACTER*1
= 'N':  do not compute the left Schur vectors;
.br
= 'V':  compute the left Schur vectors.
.TP 8
JOBVSR  (input) CHARACTER*1
.br
= 'N':  do not compute the right Schur vectors;
.br
= 'V':  compute the right Schur vectors.
.TP 8
SORT    (input) CHARACTER*1
Specifies whether or not to order the eigenvalues on the
diagonal of the generalized Schur form.
= 'N':  Eigenvalues are not ordered;
.br
= 'S':  Eigenvalues are ordered (see SELCTG).
.TP 8
SELCTG  (input) LOGICAL FUNCTION of two COMPLEX arguments
SELCTG must be declared EXTERNAL in the calling subroutine.
If SORT = 'N', SELCTG is not referenced.
If SORT = 'S', SELCTG is used to select eigenvalues to sort
to the top left of the Schur form.
Note that a selected complex eigenvalue may no longer satisfy
SELCTG(ALPHA(j),BETA(j)) = .TRUE. after ordering, since
ordering may change the value of complex eigenvalues
(especially if the eigenvalue is ill-conditioned), in this
case INFO is set to N+3 see INFO below).
.TP 8
SENSE   (input) CHARACTER
Determines which reciprocal condition numbers are computed.
= 'N' : None are computed;
.br
= 'E' : Computed for average of selected eigenvalues only;
.br
= 'V' : Computed for selected deflating subspaces only;
.br
= 'B' : Computed for both.
If SENSE = 'E', 'V', or 'B', SORT must equal 'S'.
.TP 8
N       (input) INTEGER
The order of the matrices A, B, VSL, and VSR.  N >= 0.
.TP 8
A       (input/output) COMPLEX array, dimension (LDA, N)
On entry, the first of the pair of matrices.
On exit, A has been overwritten by its generalized Schur
form S.
.TP 8
LDA     (input) INTEGER
The leading dimension of A.  LDA >= max(1,N).
.TP 8
B       (input/output) COMPLEX array, dimension (LDB, N)
On entry, the second of the pair of matrices.
On exit, B has been overwritten by its generalized Schur
form T.
.TP 8
LDB     (input) INTEGER
The leading dimension of B.  LDB >= max(1,N).
.TP 8
SDIM    (output) INTEGER
If SORT = 'N', SDIM = 0.
If SORT = 'S', SDIM = number of eigenvalues (after sorting)
for which SELCTG is true.
.TP 8
ALPHA   (output) COMPLEX array, dimension (N)
BETA    (output) COMPLEX array, dimension (N)
On exit, ALPHA(j)/BETA(j), j=1,...,N, will be the
generalized eigenvalues.  ALPHA(j) and BETA(j),j=1,...,N  are
the diagonals of the complex Schur form (S,T).  BETA(j) will
be non-negative real.

Note: the quotients ALPHA(j)/BETA(j) may easily over- or
underflow, and BETA(j) may even be zero.  Thus, the user
should avoid naively computing the ratio alpha/beta.
However, ALPHA will be always less than and usually
comparable with norm(A) in magnitude, and BETA always less
than and usually comparable with norm(B).
.TP 8
VSL     (output) COMPLEX array, dimension (LDVSL,N)
If JOBVSL = 'V', VSL will contain the left Schur vectors.
Not referenced if JOBVSL = 'N'.
.TP 8
LDVSL   (input) INTEGER
The leading dimension of the matrix VSL. LDVSL >=1, and
if JOBVSL = 'V', LDVSL >= N.
.TP 8
VSR     (output) COMPLEX array, dimension (LDVSR,N)
If JOBVSR = 'V', VSR will contain the right Schur vectors.
Not referenced if JOBVSR = 'N'.
.TP 8
LDVSR   (input) INTEGER
The leading dimension of the matrix VSR. LDVSR >= 1, and
if JOBVSR = 'V', LDVSR >= N.
.TP 8
RCONDE  (output) REAL array, dimension ( 2 )
If SENSE = 'E' or 'B', RCONDE(1) and RCONDE(2) contain the
reciprocal condition numbers for the average of the selected
eigenvalues.
Not referenced if SENSE = 'N' or 'V'.
.TP 8
RCONDV  (output) REAL array, dimension ( 2 )
If SENSE = 'V' or 'B', RCONDV(1) and RCONDV(2) contain the
reciprocal condition number for the selected deflating
subspaces.
Not referenced if SENSE = 'N' or 'E'.
.TP 8
WORK    (workspace/output) COMPLEX array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
.TP 8
LWORK   (input) INTEGER
The dimension of the array WORK.  LWORK >= 2*N.
If SENSE = 'E', 'V', or 'B',
LWORK >= MAX(2*N, 2*SDIM*(N-SDIM)).
.TP 8
RWORK   (workspace) REAL array, dimension ( 8*N )
Real workspace.
.TP 8
IWORK   (workspace/output) INTEGER array, dimension (LIWORK)
Not referenced if SENSE = 'N'.
On exit, if INFO = 0, IWORK(1) returns the optimal LIWORK.
.TP 8
LIWORK  (input) INTEGER
The dimension of the array WORK. LIWORK >= N+2.
.TP 8
BWORK   (workspace) LOGICAL array, dimension (N)
Not referenced if SORT = 'N'.
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value.
.br
= 1,...,N:
The QZ iteration failed.  (A,B) are not in Schur
form, but ALPHA(j) and BETA(j) should be correct for
j=INFO+1,...,N.
> N:  =N+1: other than QZ iteration failed in CHGEQZ
.br
=N+2: after reordering, roundoff changed values of
some complex eigenvalues so that leading
eigenvalues in the Generalized Schur form no
longer satisfy SELCTG=.TRUE.  This could also
be caused due to scaling.
=N+3: reordering failed in CTGSEN.
