.TH SLARRV l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
SLARRV - compute the eigenvectors of the tridiagonal matrix T = L D L^T given L, D and the eigenvalues of L D L^T
.SH SYNOPSIS
.TP 19
SUBROUTINE SLARRV(
N, D, L, ISPLIT, M, W, IBLOCK, GERSCH, TOL, Z,
LDZ, ISUPPZ, WORK, IWORK, INFO )
.TP 19
.ti +4
INTEGER
INFO, LDZ, M, N
.TP 19
.ti +4
REAL
TOL
.TP 19
.ti +4
INTEGER
IBLOCK( * ), ISPLIT( * ), ISUPPZ( * ),
IWORK( * )
.TP 19
.ti +4
REAL
D( * ), GERSCH( * ), L( * ), W( * ), WORK( * ),
Z( LDZ, * )
.SH PURPOSE
SLARRV computes the eigenvectors of the tridiagonal matrix T = L D L^T given L, D and the eigenvalues of L D L^T. The input eigenvalues should have high relative accuracy with
respect to the entries of L and D. The desired accuracy of the
output can be specified by the input parameter TOL.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The order of the matrix.  N >= 0.
.TP 8
D       (input/output) REAL array, dimension (N)
On entry, the n diagonal elements of the diagonal matrix D.
On exit, D may be overwritten.
.TP 8
L       (input/output) REAL array, dimension (N-1)
On entry, the (n-1) subdiagonal elements of the unit
bidiagonal matrix L in elements 1 to N-1 of L. L(N) need
not be set. On exit, L is overwritten.
.TP 8
ISPLIT  (input) INTEGER array, dimension (N)
The splitting points, at which T breaks up into submatrices.
The first submatrix consists of rows/columns 1 to
ISPLIT( 1 ), the second of rows/columns ISPLIT( 1 )+1
through ISPLIT( 2 ), etc.
.TP 8
TOL     (input) REAL
The absolute error tolerance for the
eigenvalues/eigenvectors.
Errors in the input eigenvalues must be bounded by TOL.
The eigenvectors output have residual norms
bounded by TOL, and the dot products between different
eigenvectors are bounded by TOL. TOL must be at least
N*EPS*|T|, where EPS is the machine precision and |T| is
the 1-norm of the tridiagonal matrix.
.TP 8
M       (input) INTEGER
The total number of eigenvalues found.  0 <= M <= N.
If RANGE = 'A', M = N, and if RANGE = 'I', M = IU-IL+1.
.TP 8
W       (input) REAL array, dimension (N)
The first M elements of W contain the eigenvalues for
which eigenvectors are to be computed.  The eigenvalues
should be grouped by split-off block and ordered from
smallest to largest within the block ( The output array
W from SLARRE is expected here ).
Errors in W must be bounded by TOL (see above).
.TP 8
IBLOCK  (input) INTEGER array, dimension (N)
The submatrix indices associated with the corresponding
eigenvalues in W; IBLOCK(i)=1 if eigenvalue W(i) belongs to
the first submatrix from the top, =2 if W(i) belongs to
the second submatrix, etc. 
.TP 8
Z       (output) REAL array, dimension (LDZ, max(1,M) )
If JOBZ = 'V', then if INFO = 0, the first M columns of Z
contain the orthonormal eigenvectors of the matrix T
corresponding to the selected eigenvalues, with the i-th
column of Z holding the eigenvector associated with W(i).
If JOBZ = 'N', then Z is not referenced.
Note: the user must ensure that at least max(1,M) columns are
supplied in the array Z; if RANGE = 'V', the exact value of M
is not known in advance and an upper bound must be used.
.TP 8
LDZ     (input) INTEGER
The leading dimension of the array Z.  LDZ >= 1, and if
JOBZ = 'V', LDZ >= max(1,N).
.TP 8
ISUPPZ  (output) INTEGER ARRAY, dimension ( 2*max(1,M) )
The support of the eigenvectors in Z, i.e., the indices
indicating the nonzero elements in Z. The i-th eigenvector
is nonzero only in elements ISUPPZ( 2*i-1 ) through
ISUPPZ( 2*i ).
.TP 8
WORK    (workspace) REAL array, dimension (13*N)
.TP 8
IWORK   (workspace) INTEGER array, dimension (6*N)
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value
.br
> 0:  if INFO = 1, internal error in SLARRB
if INFO = 2, internal error in SSTEIN
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br

