.TH ZHSEQR l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
ZHSEQR - compute the eigenvalues of a complex upper Hessenberg matrix H, and, optionally, the matrices T and Z from the Schur decomposition H = Z T Z**H, where T is an upper triangular matrix (the Schur form), and Z is the unitary matrix of Schur vectors
.SH SYNOPSIS
.TP 19
SUBROUTINE ZHSEQR(
JOB, COMPZ, N, ILO, IHI, H, LDH, W, Z, LDZ,
WORK, LWORK, INFO )
.TP 19
.ti +4
CHARACTER
COMPZ, JOB
.TP 19
.ti +4
INTEGER
IHI, ILO, INFO, LDH, LDZ, LWORK, N
.TP 19
.ti +4
COMPLEX*16
H( LDH, * ), W( * ), WORK( * ), Z( LDZ, * )
.SH PURPOSE
ZHSEQR computes the eigenvalues of a complex upper Hessenberg matrix H, and, optionally, the matrices T and Z from the Schur decomposition H = Z T Z**H, where T is an upper triangular matrix (the Schur form), and Z is the unitary matrix of Schur vectors. 
Optionally Z may be postmultiplied into an input unitary matrix Q,
so that this routine can give the Schur factorization of a matrix A
which has been reduced to the Hessenberg form H by the unitary
matrix Q:  A = Q*H*Q**H = (QZ)*T*(QZ)**H.
.br

.SH ARGUMENTS
.TP 8
JOB     (input) CHARACTER*1
= 'E': compute eigenvalues only;
.br
= 'S': compute eigenvalues and the Schur form T.
.TP 8
COMPZ   (input) CHARACTER*1
.br
= 'N': no Schur vectors are computed;
.br
= 'I': Z is initialized to the unit matrix and the matrix Z
of Schur vectors of H is returned;
= 'V': Z must contain an unitary matrix Q on entry, and
the product Q*Z is returned.
.TP 8
N       (input) INTEGER
The order of the matrix H.  N >= 0.
.TP 8
ILO     (input) INTEGER
IHI     (input) INTEGER
It is assumed that H is already upper triangular in rows
and columns 1:ILO-1 and IHI+1:N. ILO and IHI are normally
set by a previous call to ZGEBAL, and then passed to CGEHRD
when the matrix output by ZGEBAL is reduced to Hessenberg
form. Otherwise ILO and IHI should be set to 1 and N
respectively.
1 <= ILO <= IHI <= N, if N > 0; ILO=1 and IHI=0, if N=0.
.TP 8
H       (input/output) COMPLEX*16 array, dimension (LDH,N)
On entry, the upper Hessenberg matrix H.
On exit, if JOB = 'S', H contains the upper triangular matrix
T from the Schur decomposition (the Schur form). If
JOB = 'E', the contents of H are unspecified on exit.
.TP 8
LDH     (input) INTEGER
The leading dimension of the array H. LDH >= max(1,N).
.TP 8
W       (output) COMPLEX*16 array, dimension (N)
The computed eigenvalues. If JOB = 'S', the eigenvalues are
stored in the same order as on the diagonal of the Schur form
returned in H, with W(i) = H(i,i).
.TP 8
Z       (input/output) COMPLEX*16 array, dimension (LDZ,N)
If COMPZ = 'N': Z is not referenced.
.br
If COMPZ = 'I': on entry, Z need not be set, and on exit, Z
contains the unitary matrix Z of the Schur vectors of H.
If COMPZ = 'V': on entry Z must contain an N-by-N matrix Q,
which is assumed to be equal to the unit matrix except for
the submatrix Z(ILO:IHI,ILO:IHI); on exit Z contains Q*Z.
Normally Q is the unitary matrix generated by ZUNGHR after
the call to ZGEHRD which formed the Hessenberg matrix H.
.TP 8
LDZ     (input) INTEGER
The leading dimension of the array Z.
LDZ >= max(1,N) if COMPZ = 'I' or 'V'; LDZ >= 1 otherwise.
.TP 8
WORK    (workspace/output) COMPLEX*16 array, dimension (LWORK)
On exit, if INFO = 0, WORK(1) returns the optimal LWORK.
.TP 8
LWORK   (input) INTEGER
The dimension of the array WORK.  LWORK >= max(1,N).

If LWORK = -1, then a workspace query is assumed; the routine
only calculates the optimal size of the WORK array, returns
this value as the first entry of the WORK array, and no error
message related to LWORK is issued by XERBLA.
.TP 8
INFO    (output) INTEGER
= 0:  successful exit
.br
< 0:  if INFO = -i, the i-th argument had an illegal value
.br
> 0:  if INFO = i, ZHSEQR failed to compute all the
eigenvalues in a total of 30*(IHI-ILO+1) iterations;
elements 1:ilo-1 and i+1:n of W contain those
eigenvalues which have been successfully computed.
