/*
 * $Id: bitmap.h,v 1.7 2001/06/01 02:07:24 antona Exp $
 *
 * bitmap.h - Exports for bitmap handling. Part of the Linux-NTFS project.
 *
 * Copyright (c) 2000,2001 Anton Altaparmakov.
 *
 * This program/include file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program/include file is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (in the main directory of the Linux-NTFS 
 * distribution in the file COPYING); if not, write to the Free Software
 * Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef BITMAP_H
#define BITMAP_H

#include "types.h"

/*
 * NOTES:
 *
 * - Operations are 8-bit only to ensure the functions work both on little
 *   and big endian machines! So don't make them 32-bit ops!
 * - bitmap starts at bit = 0 and ends at bit = bitmap size - 1.
 * - _Caller_ has to make sure that the bit to operate on is less than the
 *   size of the bitmap.
 */

/**
 * ntfs_set_bit - set a bit in a field of bits
 * @bitmap:	field of bits
 * @bit:	bit to set
 * @new_value:	value to set bit to (0 or 1)
 *
 * Set the bit @bit in the @bitmap to @new_value. Ignore all errors.
 */
__inline__ void ntfs_set_bit(__u8 *bitmap, const __u64 bit,
				const __u8 new_value);

/**
 * ntfs_get_bit - get value of a bit in a field of bits
 * @bitmap:	field of bits
 * @bit:	bit to get
 * 
 * Get and return the value of the bit @bit in @bitmap (0 or 1).
 * Return -1 on error.
 */
extern __inline__ char ntfs_get_bit(const __u8 *bitmap, const __u64 bit);

extern __inline__ void ntfs_change_bit(__u8 *bitmap, const __u64 bit);

/**
 * ntfs_get_and_set_bit - get value of a bit in a field of bits and set it
 * @bitmap:	field of bits
 * @bit:	bit to get/set
 * @new_value:	value to set bit to (0 or 1)
 * 
 * Return the value of the bit @bit and set it to @new_value (0 or 1).
 * Return -1 on error.
 */
extern __inline__ char ntfs_get_and_set_bit(__u8 *bitmap, const __u64 bit,
				   const __u8 new_value);

#endif /* defined BITMAP_H */

