/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

package org.netbeans.modules.favorites.templates;

import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.util.NbBundle;

/**
 * Handles rename of a template file name and display name.
 * 
 * @author Martin Entlicher
 */
public class RenameTemplatePanel extends java.awt.Panel {
    
    private Set<String> otherFileNames;
    private boolean isLicense = false;
    private DialogDescriptor dd;
    private NotificationLineSupport notificationLineSupport;

    /** Creates new form RenameTemplatePanel */
    public RenameTemplatePanel(boolean isUserFile) {
        initComponents();
        fileNameTextField.setEditable(isUserFile);
        fileNameTextField.getDocument().addDocumentListener(new NameDocumentListener());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        displayNameLabel = new javax.swing.JLabel();
        displayNameTextField = new javax.swing.JTextField();
        fileNameLabel = new javax.swing.JLabel();
        fileNameTextField = new javax.swing.JTextField();

        displayNameLabel.setLabelFor(displayNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(displayNameLabel, org.openide.util.NbBundle.getMessage(RenameTemplatePanel.class, "RenameTemplatePanel.displayNameLabel.text")); // NOI18N

        fileNameLabel.setLabelFor(fileNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(fileNameLabel, org.openide.util.NbBundle.getMessage(RenameTemplatePanel.class, "RenameTemplatePanel.fileNameLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(displayNameLabel)
                    .addComponent(fileNameLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(fileNameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE)
                    .addComponent(displayNameTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(displayNameLabel)
                    .addComponent(displayNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(fileNameLabel)
                    .addComponent(fileNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel displayNameLabel;
    private javax.swing.JTextField displayNameTextField;
    private javax.swing.JLabel fileNameLabel;
    private javax.swing.JTextField fileNameTextField;
    // End of variables declaration//GEN-END:variables

    void setFileName(String name) {
        fileNameTextField.setText(name);
    }

    void setFileDisplayName(String name) {
        displayNameTextField.setText(name);
    }

    String getFileName() {
        return fileNameTextField.getText();
    }

    String getFileDisplayName() {
        return displayNameTextField.getText();
    }
    
    void setIsLicense(boolean isLicense) {
        this.isLicense = isLicense;
    }

    void setOtherFileNames(Set<String> otherFileNames) {
        this.otherFileNames = otherFileNames;
    }

    void setDescriptor(DialogDescriptor dd) {
        this.dd = dd;
        this.notificationLineSupport = dd.createNotificationLineSupport();
    }

    @NbBundle.Messages({"Err_FileNameExists=Template with this file name already exists.",
                        "# {0} - prefix of the license file name",
                        "# {1} - suffix of the license file name",
                        "RenameTemplatePanel.license.warning.text=License file name must start with \"{0}\" and end with \"{1}\"."})
    private void checkName() {
        String name = fileNameTextField.getText();
        boolean clash = otherFileNames != null && otherFileNames.contains(name);
        if (clash) {
            notificationLineSupport.setErrorMessage(Bundle.Err_FileNameExists());
        } else {
            clash = isLicense && checkLicenseClash(name);
            if (clash) {
                notificationLineSupport.setErrorMessage(
                        Bundle.RenameTemplatePanel_license_warning_text(
                            TemplatesPanel.LICENSE_NAME_START,
                            TemplatesPanel.LICENSE_NAME_END));
            } else {
                notificationLineSupport.clearMessages();
            }
        }
        dd.setValid(!clash);
    }
    
    private static boolean checkLicenseClash(String name) {
        return !name.startsWith(TemplatesPanel.LICENSE_NAME_START) ||
               !name.endsWith(TemplatesPanel.LICENSE_NAME_END);
    }

    private class NameDocumentListener implements DocumentListener {

        public NameDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            checkName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            checkName();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            checkName();
        }
        
    }

}
