require "rexml/parseexception"

module REXML
	# Represents a node in the tree.  Nodes are never encountered except as
	# superclasses of other objects.  Nodes have siblings.
	module Node
		# The order in which the substitutions occur
		SPECIALS = [ /&(?!#?[\w-]+;)/u, /</u, />/u, /"/u, /'/u ]
		SLAICEPS = [ "&", "<", ">", '"', "'" ]
		# Characters which are substituted in written strings
		SUBSTITUTES = ['&amp;', '&lt;', '&gt;', '&quot;', '&apos;']
		SETUTITSBUS = [/&amp;/u, /&lt;/u, /&gt;/u, /&quot;/u, /&apos;/u]

		# @return the next sibling (nil if unset)
		def next_sibling_node
			return nil if @parent.nil?
			@parent[ @parent.index(self) + 1 ]
		end

		# @return the previous sibling (nil if unset)
		def previous_sibling_node
			return nil if @parent.nil?
			ind = @parent.index(self)
			return nil if ind == 0
			@parent[ ind - 1 ]
		end

		def to_s indent=0
			rv = ""
			write rv,indent
			rv
		end

		def indent to, ind
			to << " "*ind unless ind<1
		end
		
		# Writes out text, substituting special characters beforehand.
		# @param out A String, IO, or any other object supporting <<( String )
		# @param input the text to substitute and the write out
		def write_with_substitution out, input
			copy = input.clone
			# Doing it like this rather than in a loop improves the speed
			copy.gsub!( SPECIALS[0], SUBSTITUTES[0] )
			copy.gsub!( SPECIALS[1], SUBSTITUTES[1] )
			copy.gsub!( SPECIALS[2], SUBSTITUTES[2] )
			copy.gsub!( SPECIALS[3], SUBSTITUTES[3] )
			copy.gsub!( SPECIALS[4], SUBSTITUTES[4] )
			out << copy
		end

		# Reads text, substituting entities
		def read_with_substitution( input, illegal=nil )
			copy = input.clone

			if copy =~ illegal
				raise ParseException.new( "malformed text: Illegal character #$& in \"#{copy}\"" )
			end if illegal
			
			copy.gsub!( SETUTITSBUS[0], SLAICEPS[0] )
			copy.gsub!( SETUTITSBUS[1], SLAICEPS[1] )
			copy.gsub!( SETUTITSBUS[2], SLAICEPS[2] )
			copy.gsub!( SETUTITSBUS[3], SLAICEPS[3] )
			copy.gsub!( SETUTITSBUS[4], SLAICEPS[4] )

			copy
		end
	end
end
