;;;; -*- scheme -*-
;;;; GNU Mailutils -- a suite of utilities for electronic mail
;;;; Copyright (C) 2002, 2003, 2004, 2006, 2007 Free Software Foundation, Inc.
;;;;
;;;; GNU Mailutils is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 3, or (at your option)
;;;; any later version.
;;;; 
;;;; GNU Mailutils is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License along
;;;; with GNU Mailutils; if not, write to the Free Software Foundation,
;;;; Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
;;;;

(define-module (mailutils mailutils)
               #:use-module (ice-9 documentation))

(set! documentation-files (append documentation-files 
                                  (list "/usr/local/share/guile/site/mailutils/guile-procedures.txt")))

(define mu-libs (list "libmailutils"
		      "libmuauth"
		      "libmu_mbox"
		      "libmu_mh"
		      "libmu_maildir"
		      "libmu_pop"
		      "libmu_imap"))

(let ((lib-path "/usr/local/lib/"))
  (for-each
   (lambda (lib)
	   (dynamic-link (string-append lib-path lib)))
   mu-libs)
  (cond
   ((or (string=? (version) "1.4")
	(string=? (version) "1.4.1"))
    (dynamic-call "mu_scm_init"
		  (dynamic-link (string-append
				 lib-path
				 "libguile-mailutils-v-1.1.90"))))
   (else
    (load-extension (string-append
		     lib-path "libguile-mailutils-v-1.1.90") "mu_scm_init"))))

(export mu-package)
(export mu-package-string)
(export mu-version)
(export mu-mailer)
(export mu-debug)
(export mu-path-maildir)
(export mu-path-folder-dir)

(export MU-ATTRIBUTE-ANSWERED)
(export MU-ATTRIBUTE-FLAGGED)
(export MU-ATTRIBUTE-DELETED)
(export MU-ATTRIBUTE-DRAFT)
(export MU-ATTRIBUTE-SEEN)
(export MU-ATTRIBUTE-READ)
(export MU-ATTRIBUTE-MODIFIED)
(export MU-ATTRIBUTE-RECENT)

(export LOG_USER)   
(export LOG_DAEMON)
(export LOG_AUTH)  
(export LOG_LOCAL0)
(export LOG_LOCAL1)
(export LOG_LOCAL2)
(export LOG_LOCAL3)
(export LOG_LOCAL4)
(export LOG_LOCAL5)
(export LOG_LOCAL6)
(export LOG_LOCAL7)
(export LOG_EMERG)    
(export LOG_ALERT)   
(export LOG_CRIT)    
(export LOG_ERR)     
(export LOG_WARNING) 
(export LOG_NOTICE)  
(export LOG_INFO)    
(export LOG_DEBUG)   
(export LOG_CONS)   
(export LOG_NDELAY) 
(export LOG_PID)

(export mu-address-get-personal)
(export mu-address-get-comments)
(export mu-address-get-email)
(export mu-address-get-domain)
(export mu-address-get-local)
(export mu-address-get-count)
(export mu-username->email)

(export mu-body-read-line)
(export mu-body-write)


(export mu-mail-directory)
(export mu-folder-directory)
(export mu-mailbox-open)
(export mu-mailbox-close)
(export mu-mailbox-get-url)
(export mu-mailbox-get-port)
(export mu-mailbox-get-message)
(export mu-mailbox-messages-count)
(export mu-mailbox-expunge)
(export mu-mailbox-append-message)

(export mu-message-create)
(export mu-message-copy)
(export mu-message-destroy)
(export mu-message-set-header)
(export mu-message-get-size)
(export mu-message-get-lines)
(export mu-message-get-sender)
(export mu-message-get-header)
(export mu-message-get-header-fields)
(export mu-message-set-header-fields)
(export mu-message-delete)
(export mu-message-get-flag)
(export mu-message-set-flag)
(export mu-message-get-user-flag)
(export mu-message-set-user-flag)
(export mu-message-get-port)
(export mu-message-get-body)
(export mu-message-multipart?)
(export mu-message-get-num-parts)
(export mu-message-get-part)
(export mu-message-send)
(export mu-message-get-uid)

(export mu-mime-create)
(export mu-mime-multipart?)
(export mu-mime-get-num-parts)
(export mu-mime-get-part)
(export mu-mime-add-part)
(export mu-mime-get-message)

(export mu-openlog)
(export mu-logger)
(export mu-closelog)


(export mu-register-format)
(export mu-strerror)

(export mu-getpwuid)


;;;; End of mailutils.scm
