      DOUBLE PRECISION FUNCTION XMNFRG(LMODEL,WPAR,NPAR,X)
C
C------------------------------------------------------------------------------
C     Interface to fragmentation functions.
C     Does the function normalization if requested.
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
C
      INTEGER MSTEP
      PARAMETER (MSTEP = 100)
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnusr.inc"
C
      INTEGER LMODEL,NPAR
      REAL X
      DOUBLE PRECISION WPAR(MFNPAR)
C
      DOUBLE PRECISION DSIMPS
      DOUBLE PRECISION XMNFR2,WMNFRI,WPARI(MFNPAR),WFRVAL(0:MSTEP)
     + ,WXLO,WXHI,WBIN
      REAL XX,DXX
      INTEGER I
      LOGICAL QFRNEW
C
      SAVE WPARI,WMNFRI
      DATA WPARI/MFNPAR*-1.0D+31/
C
      WBIN = DBLE(XBINNM)
      IF(QFAREA) THEN
C
C         See if any parameters have changed
C
          QFRNEW = .FALSE.
          DO I=2,NPAR
              IF(WPAR(I).NE.WPARI(I)) THEN
                  WPARI(I) = WPAR(I)
                  QFRNEW = .TRUE.
              ENDIF
          ENDDO
C
C         If they have changed then recalculate the AREA
C
          IF(QFRNEW) THEN
              WXLO     = 0.0D0
              WXHI     = 1.0D0
              WPARI(1) = 1.0D0
              DXX = SNGL(WXHI - WXLO) / FLOAT(MSTEP)
              XX  = SNGL(WXLO) - DXX
              DO I=0,MSTEP
                  XX = XX + DXX
                  WFRVAL(I) = XMNFR2(LMODEL,1.0D0,WPARI(1),NPAR,XX)
              ENDDO
              WMNFRI = DSIMPS(WFRVAL(0), WXLO, WXHI, MSTEP)
          ENDIF
      ELSE
          WMNFRI = 1.0D0
      ENDIF
C
      XMNFRG = XMNFR2(LMODEL,WBIN,WPAR,NPAR,X) / WMNFRI
C
      END
