      SUBROUTINE M_HBMN(IDA1I,IDA2I,IDB,NMODE)
C
C-----------------------------------------------------------------------------
C     Converts an HBOOK histogram or Ntuple to a Mn_Fit one
C
C     Called by MN_HBF, M_NTPSCN, M_CALL
C-----------------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
*ICB+CDE,HCBITS.
C
      INTEGER IDA1I,IDA2I,IDB,NMODE
C
      INTEGER MVDIM,MNTPMX,MHIST
      PARAMETER (MVDIM  = 1)
      PARAMETER (MNTPMX = 50 000)
      PARAMETER (MHIST  = 200)
C
      INTEGER IQUEST
      COMMON/QUEST/IQUEST(100)
C
      REAL VECT(1)
      INTEGER KIND(32)
C
      CHARACTER*80 TITLE
      CHARACTER*32 TNAME(MDIMMX),TNDEF(MDIMMX)
      CHARACTER*4 TPART
      INTEGER IDVECT(MHIST)
      INTEGER IDBIN(MDIMMX)
      REAL ADLO(MDIMMX),ADHI(MDIMMX)
      REAL ACONT(3**3)
      INTEGER NWPPTX,NWDATX
C
      INTEGER I,II,IDH,NHIST,IERR,NHDATE,NHTIME,LENN
      INTEGER IDA,NFILE,ICYCLE,NBINX,NBINY,NWT,IAD,NDIM
     + ,NPNT,NWPPT,NWDAT,NBPPT,NTMODE,NH,NPTRH,NPTRD,NWH,NP
     + ,NPTR,NWTOT,NSDATE,NSTIME
      REAL XLO,XHI,YLO,YHI,EDENT,EDLO,EDHI
C
      logical  hntnew,qcwntp
      external hntnew
C
      LOGICAL QSTART
      SAVE TNDEF
      DATA QSTART/.TRUE./
C
      IF(QSTART) THEN
          QSTART = .FALSE.
          DO 100 II=1,MDIMMX
              IF(II.EQ.1) THEN
                  TNDEF(II) = 'X'
              ELSE IF(II.EQ.2) THEN
                  TNDEF(II) = 'Y'
              ELSE IF(II.EQ.3) THEN
                  TNDEF(II) = 'Z'
              ELSE
                  TNDEF(II) = ' '
              ENDIF
100       CONTINUE
      ENDIF
C
      IDH  = IDA1I
      IF(IDH.EQ.0) THEN
          CALL HIDALL(IDVECT,NHIST)
          IF(NHIST.GT.MHIST) THEN
              WRITE(TXTERR,'(''I will only copy'',I4
     +         ,'' histograms into Mn_Fit memory'')') MHIST
              CALL M_EMSG('M_HBMN',TXTERR)
              nhist = mhist
          ENDIF
      ELSEIF(IDA1I.LT.IDA2I) THEN
          CALL HIDALL(IDVECT,NHIST)
          IF(NHIST.GT.MHIST) THEN
              WRITE(TXTERR,'(''I can copy'',I4
     +         ,'' a maximum of histograms into Mn_Fit memory'')') MHIST
              CALL M_EMSG('M_HBMN',TXTERR)
          ENDIF
      ELSE
          NHIST = 1
          IDVECT(1) = IDH
      ENDIF
      IERR = 0
C
C     Loop over the histograms
C
      DO 5000 I=1,NHIST
          IDH = IDVECT(I)
          IDA = IDH
C
C         See if the histogram is in the range requested
C
          if(ida1i.lt.ida2i) then
              if(idh.lt.ida1i .or. idh.gt.ida2i) goto 5000
          endif
C
C         Find the date and time of the histogram creation
C
          IF(NMODE.EQ.3) THEN
              NHDATE = 0
              NHTIME = 0
              call vzero_i(kind,32)
          ELSE
              CALL HKIND(IDH,KIND,'A')
              icycle = 999999
              CALL RZVIN(VECT,MVDIM,NFILE,IDH,ICYCLE,'D')
C              WRITE(6,*) 'Histogram: ',IDH,'  Nfile: ',NFILE
C              WRITE(6,'('' IQUEST(1->20)'',/,(1X,5I12))')
C     +         (IQUEST(II),II=1,20)
              CALL RZDATE(IQUEST(14),NHDATE,NHTIME,1)
C              WRITE(6,'('' Date'',I8,''  Time'',I8)') NHdate,NHtime
          ENDIF
C
C         Get the histogram title, binning etc.
C
          CALL HGIVE(IDH,TITLE,NBINX,XLO,XHI,NBINY,YLO,YHI,NWT,IAD)
          if(nmode.eq.3) then
              if(nbiny.eq.0) then
                  kind(1) = 1
              else
                  kind(2) = 1
              endif
          endif
C
C         Ntuple - CWN or RWN?
C
cicb          if(i4.ne.0) then
          if(kind(4).ne.0) then
              qcwntp = hntnew(idh)
          else
              qcwntp = .false.
          endif
C
C         An Ntuple
C
*ICB          IF(I4.NE.0) THEN
          if(kind(4).ne.0) then
              NDIM = MDIMMX
              CALL HGIVEN(IDH,TITLE,NDIM,TNAME,ADLO,ADHI)
              IF(NDIM.GT.MDIMMX) THEN
                  WRITE(TXTERR,'(''Plot'',I7,'' has'',I4
     1             ,'' dimensions, but I can only store'',I4)')
     2             IDH,NDIM,MDIMMX
                  CALL M_EMSG('MN_HBF',TXTERR)
                  GOTO 5000
              ENDIF
C
C             Make sure all the tags are left-justified
C
              LENN = LEN(TNAME(1))
              DO 4100 II=1,NDIM
                  CALL CLEFT(TNAME(II),1,LENN)
4100          CONTINUE
C
              CALL HNOENT(IDH,NPNT)
              NDIM  = -NDIM
              NWPPT = IABS(NDIM)
              NWPPTX = NWPPT
          ELSE IF(NBINY.LE.0) THEN
C
C             SEE IF THE HISTOGRAM HAS VARIABLE BIN WIDTH
C
*ICB              IF(I6.NE.0) THEN
              IF(kind(6).NE.0) THEN
                  NDIM   = -1
                  NWPPT  =  4
              ELSE
                  NDIM   = 1
                  NWPPT  = 2
              ENDIF
              NWPPTX = NWPPT + 1
              NPNT  = NBINX
              TNAME(1) = TNDEF(1)
          ELSE
              NDIM   = 2
              NWPPT  = 2
              NWPPTX = NWPPT + 1
              NPNT  = NBINX*NBINY
              TNAME(1) = TNDEF(1)
              TNAME(2) = TNDEF(2)
          ENDIF
C
C         Allow extra space for sorting HBOOK data to Mn_Fit order
C
          NWDAT  = NPNT*NWPPT
          NWDATX = NPNT*NWPPTX
          NBPPT = 0
          NTMODE = 0
C
C         Ntuples of more than 50000 words will not be read into memory
C         CWN's are never read into memory!
C
          IF(NDIM.LT.0 .AND. (NWDAT.GT.MNTPMX .or. qcwntp)) THEN
              NWDAT  = 0
              NWDATX = 0
          ENDIF
C
C         GET THE HISTOGRAM NUMBER AND THE POINTER
C         RESERVE SPACE FOR THE HISTOGRAM
C
          CALL MN_HNW(IDA,IDB,NDIM,NWDATX,NH,NPTRH,NPTRD,NWH
     +     ,NBPPT,NTMODE)
          IF(NH.LE.0) THEN
              IERR = 1
              GOTO 9000
          ENDIF
C
C         GET THE HISTOGRAM CONTENTS
C
          IF(NDIM.EQ.1 .OR. NDIM.EQ.2 .OR.
cicb     +       (NDIM.EQ.-1 .AND. NBINX.GT.0)) THEN
     +       (NDIM.EQ.-1 .AND. kind(4).eq.0)) THEN
              TPART = ' '
              CALL MN_HEX(IDH,TPART,0,RDAT(NPTRD),NDIM,NWPPT,NPNT
     +         ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,TITLE,ACONT,IERR)
              IF(IERR.NE.0) GOTO 9000
          ELSE
              CALL VZERO_i(IDBIN,MDIMMX)
C
C             Read the Ntuple into memory - set the directories properly
C
              IF(NWDAT.GT.0) THEN
                  CALL M_SDIR(0,IERR)
                  IF(IERR.NE.0) GOTO 5000
                  if(qcwntp) then
                  else
                      CALL HGNPAR(IDH,'M_HBMN')
                  endif
                  DO 4700 NP=1,NPNT
                      NPTR = NPTRD + NWPPT*(NP-1)
                      if(qcwntp) then
                      else
                          CALL HGNF(IDH,NP,RDAT(NPTR),IERR)
                      endif
                      IF(IERR.NE.0) THEN
                          WRITE(TXTERR
     +                     ,'(''Error unpacking Ntuple'',I7)') IDH
                          CALL M_EMSG('MN_HBF',TXTERR)
                          GOTO 5000
                      ENDIF
4700              CONTINUE
              ENDIF
              EDENT = FLOAT(NPNT)
              EDLO  = 0.0
              EDHI  = 1.0
          ENDIF
C
C         FILL IN THE HEADER INFORMATION AND THE POINTERS
C
          NWTOT = NWH + NWDAT
          NSDATE = 0
          NSTIME = 0
          CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB
     1     ,NDIM,NWPPT,NPNT,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
          CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE,FIL_HB
     1     ,DIR_HC,TNAME)
          if(.not.qcwntp) then
              CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
          endif
C
5000  CONTINUE
C
9000  CONTINUE
C
      END
