      SUBROUTINE mn_rootf(IDELIM)
*-----------------------------------------------------------------------
*     Read in root histograms
*
*     $Id: mn_rootf.fpp,v 1.2 2005/02/21 21:58:12 brock Exp $
*-----------------------------------------------------------------------
*
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
*
      integer idelim
*
      INTEGER IDLSA1(100),IDLSA2(100),IDLSB1(100),IDLSB2(100)
*
      integer njunk,ndhis0,ierr,nidl,nl,nmode,nh
      integer ida1,ida2,idb1,idb2,nnid,ndh1,ndh2,ida,idb
      real    err
*
      integer inttyq
*
*-----------------------------------------------------------------------
*
      IF(IDELIM.EQ.0) THEN
          NJUNK = INTTYQ(.TRUE.,IDELIM)
          CALL RESTYQ
      ENDIF
C
      NDHIS0 = NDHIS
*
      call m_emsg('MN_ROOTF'
     + ,'Fetching of root histograms not yet implemented')
      goto 9000
*
*     Open the root file
*
      IF(FIL_MN.EQ.' ' .OR.
     1   (IDELIM.GT.0 .AND.
     2    IDELIM.NE.ICHAR(':') .AND. IDELIM.NE.ICHAR('&'))) THEN
          CALL MN_FIL(1,LUNrIN,FIL_root,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
      NIDL = 0
2000  CONTINUE
      CALL WAITYQ('Give histogram number(s): ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
      IF(NNID.GT.1) THEN
          CALL M_EMSG('MN_ROOTF','Root does not know about' //
     1     ' secondary identifiers')
          CALL MN_ERR('MN_ROOTF','It will be ignored')
      ENDIF
C
      IF(NIDL.GE.100) THEN
          WRITE(LUNTTO,'('' *** MN_MNF: Ran out of space to store plot''
     1       ,'' numbers to get''
     2     ,/,13X,'' Issue MN_FETCH command again to get more plots.'')
     2     ')
          GOTO 3000
      ENDIF
C
      NIDL = NIDL + 1
C     IF(IDA1.EQ.0 .AND. NNID.EQ.1) THEN
C         IDB1 = 0
C         IDB2 = 999
C     END IF
      IDLSA1(NIDL) = IDA1
      IDLSA2(NIDL) = IDA2
      IDLSB1(NIDL) = IDB1
      IDLSB2(NIDL) = IDB2
C
C     READ IN THE DATA
C
      CALL mn_rootr(IDA1,IDA2,IDB1,IDB2,NNID,LUNrIN,FIL_root)
      IF(IDELIM.EQ.0) GOTO 2000
3000  CONTINUE
C
8000  CONTINUE
C
C     CHECK THAT I GOT THE HISTOGRAMS I WANTED
C
      IF(NNID.EQ.1) THEN
          NNID = 2
          DO 8100 NL=1,NIDL
              IF(IDLSA1(NL).EQ.0) THEN
                  IDLSB1(NL) = 0
                  IDLSB2(NL) = 999
              ENDIF
8100      CONTINUE
      ENDIF
      CALL MN_HNG('MN_ROOTF',NNID,NDHIS0,NIDL,IDLSA1,IDLSA2
     1 ,IDLSB1,IDLSB2)
C
C     MAKE SURE THAT THE 1 AND 2 DIMENSIONAL HISTOGRAMS GET ERRORS
C     STORED AS WELL
C
      NMODE = 1
      err   = 0.0
      NDH1 = NDHIS0 + 1
      NDH2 = NDHIS
      DO 8500 NH=NDH1,NDH2
          IDA = IDIDA(NH)
          IDB = IDIDB(NH)
          CALL MN_HGT(IDA,IDB,NH)
          IF((NDIM.EQ.1 .OR. NDIM.EQ.2) .AND. NWPPT.EQ.1) THEN
              CALL MN_ERC(IDA,IDB,NMODE,err)
          ENDIF
8500  CONTINUE
C
9000  CONTINUE
      RETURN
      END
