      SUBROUTINE MN_SCF(IDELIM)
C
C     READS IN AN AVEHST TRUE SCATTER PLOT
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
C      COMMON/MNSCR/ARRAY(511)
#include "mnscr.inc"
      REAL ARRAY(511)
      EQUIVALENCE(SCRATCH(1),ARRAY(1))
C
      INTEGER IARRAY(511)
      EQUIVALENCE (IARRAY,ARRAY)
C
      INTEGER IDBIN(2)
      REAL ADLO(2),ADHI(2)
      REAL ACONT(3**2)
C
      CHARACTER*32 TNAME(2),TNDEF(2)
      INTEGER IDLST1(100),IDLST2(100),IDGOT(MHSTMX)
C
      CHARACTER*80 TITLE
      LOGICAL QRNGE,QSPACE
C
      DATA TNDEF/'X', 'Y'/
C
      IF(IDELIM.EQ.0) THEN
          NJUNK = INTTYQ(.TRUE.,IDELIM)
          CALL RESTYQ
      ENDIF
C
      NDHIS0 = NDHIS
C
      IF(FIL_SC.EQ.' ' .OR.
     1   (IDELIM.GT.0 .AND. IDELIM.NE.ICHAR(':'))) THEN
          CALL MN_FIL(1,LUNSIN,FIL_SC,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
      ELSE
          REWIND LUNSIN
      ENDIF
C
      NIDL = 0
      qrnge = .false.
 2000 CONTINUE
      CALL WAITYQ('Give histogram number(s): ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 8000
      IF(NNID.GT.1) THEN
          WRITE(LUNTTO,'('' MN_SCF: AVEHST does not know about''
     1     ,'' secondary identifiers''
     1     ,/,9X,''It will be ignored'')')
      ENDIF
C
      IF(NIDL.GE.100) THEN
          WRITE(LUNTTO,'('' *** MN_SCF: Ran out of space to store plot''
     1       ,'' numbers to get''
     2     ,/,13X,'' Issue SCT_FETCH command again to get''
     2       ,'' more plots.'')')
          GOTO 2200
      ENDIF
C
      IF(IDA1.EQ.0 .OR. IDA1.NE.IDA2) QRNGE = .TRUE.
      NIDL = NIDL + 1
      IDLST1(NIDL) = IDA1
      IDLST2(NIDL) = IDA2
      IF(IDELIM.GE.0) GOTO 2000
 2200 CONTINUE
      IF(NIDL.LE.0) GOTO 8000
C
      IDB = NDIDB
      QSPACE = .FALSE.
      NGOT = 0
      CALL VZERO_i(IDGOT,MHSTMX)
C
3000  CONTINUE
      IDA   = 0
      NPNT  = 0
      EDLO  = 0.0
      EDHI  = 1.0
      EDENT = 0.0
      XDLO  = 1.0E+30
      XDHI  = -1.0E+30
      YDLO  = 1.0E+30
      YDHI  = -1.0E+30
C
 4000 CONTINUE
      READ(LUNSIN,ERR=9100,END=5000) ARRAY
C
C     EXTRACT THE DATA
C
      NPOINT = IARRAY(1)
C
      DO 4200 I=1,NPOINT
          K = 3*I-2
          NHST = IARRAY(K+1)
          X    = ARRAY(K+2)
          Y    = ARRAY(K+3)
C
C         SEE IF THIS IS THE HISTOGRAM I AM CURRENTLY READING
C         OR IF I HAVE NOT YET GOT IT
C
          IF(IDA.EQ.0) THEN
              DO 4050 NG=1,NGOT
                  IF(NHST.EQ.IDGOT(NG)) GOTO 4200
4050          CONTINUE
C
              IDA = NHST
              NGOT = NGOT + 1
              IDGOT(NGOT) = NHST
C
C             SEE IF I WANT THIS ONE
C
              DO 4100 NL=1,NIDL
                  IF(IDLST1(NL).EQ.0 .OR.
     1               (NHST.GE.IDLST1(NL) .AND. NHST.LE.IDLST2(NL))) THEN
                      GOTO 4150
                  ENDIF
 4100         CONTINUE
C
C             I DON'T WANT IT. RESET ID AND GO TO NEXT POINT
C
              IDA = 0
              GOTO 4200
          ELSE IF(NHST.NE.IDA) THEN
              GOTO 4200
          ENDIF
C
4150      CONTINUE
          NPNT = NPNT + 1
C
C         BOOK THE NEW HISTOGRAM
C
          IF(NPNT.EQ.1) THEN
              NDIM = -2
              NWPPT = 2
              NWRD = 0
              NBPPT = 0
              NTMODE = 0
              CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH
     +         ,NBPPT,NTMODE)
          ENDIF
C
          NPTR = NPTRD + NWPPT*(NPNT-1) - 1
          IF(NPTR+NWPPT.GT.MHSTWD) THEN
               WRITE(LUNTTO,'('' *** MN_SCF:''
     1          ,'' Ran out of storage space'')')
               QSPACE = .TRUE.
               NPNT = NPNT - 1
               GOTO 5000
          ENDIF
          RDAT(NPTR + 1) = X
          RDAT(NPTR + 2) = Y
          EDENT = EDENT + 1.0
          XDLO = AMIN1(XDLO,X)
          XDHI = AMAX1(XDHI,X)
          YDLO = AMIN1(YDLO,Y)
          YDHI = AMAX1(YDHI,Y)
 4200 CONTINUE
      GOTO 4000
C
C     READ IN ALL THE DATA CHECK IT OUT AND FILL THE HEADER
C
 5000 CONTINUE
      IF(NPNT.EQ.0) GOTO 8000
C
C     WRITE(LUNTTO,'('' Histogram'',I7,I4
C     1,''  Data for'',I6,'' points read in'')')
C     1IDA,IDB,NPNT
C
      NWDAT = NWPPT * NPNT
      NWTOT = NWH + NWDAT
      IDBIN(1) = 0
      ADLO(1)  = XDLO
      ADHI(1)  = XDHI
      IDBIN(2) = 0
      ADLO(2)  = YDLO
      ADHI(2)  = YDHI
      TNAME(1) = TNDEF(1)
      TNAME(2) = TNDEF(2)
      TITLE    = 'No Name'
      NHDATE = 0
      NHTIME = 0
      NSDATE = 0
      NSTIME = 0
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB
     + ,NDIM,NWPPT,NPNT,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE,FIL_SC,' ',TNAME)
      CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
6000  CONTINUE
      IF(QSPACE) GOTO 8000
      REWIND LUNSIN
      GOTO 3000
C
8000  CONTINUE
C
C     CHECK THAT I GOT THE HISTOGRAMS I WANTED
C
      NNID = 1
      CALL MN_HNG('MN_SCF',NNID,NDHIS0,NIDL,IDLST1,IDLST2,IDB,IDB)
C
9000  CONTINUE
      GOTO 9900
C
C     ERROR READING IN THE DATA
C
9100  CONTINUE
      WRITE(TXTERR,'(''Error reading in scatter plot''
     1 ,I7)') IDA
      CALL MN_ERR('MN_SCF',TXTERR)
      GOTO 9900
C
9900  CONTINUE
      RETURN
      END
