      SUBROUTINE M_NTPSTO(IDA, IDB, NH, IERR)
C
C-----------------------------------------------------------------------
C
C     Stores an NTUPLE
C
C     Called by:  MN_HBN
C
C-----------------------------------------------------------------------
C
      implicit none
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mncwn.inc"
#include "mninf.inc"
#include "mntpl.inc"
#include "mnlun.inc"
C
      INTEGER  IDA, IDB, NH, IERR
C
      INTEGER NP,idh,nprime
      CHARACTER*32 TNAME(MDIMMX+1)
C
      CHARACTER*80 TXT1
C
      LOGICAL HEXIST,hntnew,qcwntp
C
C     Flag that I am projecting and fill the Ntuple common
C
      IDH   = IDA
      NVAR  = IABS(NDIM)
      TITLE = TDTIT(NH)
      CALL TCOPY(TDNAM(1,NH),TNAME(1),NVAR)
      IDNEVT = 0
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR('//PAWC/TMP',' ')
      CALL HCDIR(TXT1,'R')
      IF(TXT1.NE.'//PAWC/TMP') THEN
          TXTMES = ' M_NTPSTO: Creating a temporary directory' //
     +     ' //PAWC/TMP'
          CALL MN_MES(LUNTTO,'ME',TXTMES)
          CALL HMDIR('TMP',' ')
          CALL HCDIR('//PAWC/TMP',' ')
      ENDIF
C
CICB      NPRIME = MIN0(1000,MIN0(100*NVAR,10000))
      NPRIME = MIN0(10000,MIN0(10000*NVAR,50000))
      IF(HEXIST(IDH)) CALL HDELET(IDH)
C
C     Initialize the reading in of the Ntuple
C
      nvcwn = 0
      CALL M_NTPPNT(IDA,IDB,0,IERR,RVAL)
      IF(IERR.NE.0) GOTO 9000
C
C     Book the new Ntuple
C
      CALL HCDIR('//PAWC/TMP',' ')
      CALL HCDIR('//MN_HBOUT',' ')
      qcwntp = hntnew(idh)
      if(qcwntp) then
          call hntdup(idh,987654,-1,' ',' ')
      else
          CALL HBOOKN(IDH,TITLE,NVAR,'//MN_HBOUT',NPRIME,TNAME)
      endif
C
C     UNBINNNED N-DIMENSIONAL SCATTER PLOT
C
      DO 3000 NP = 1, NPNT
          CALL M_NTPPNT(IDA,IDB,NP,IERR,RVAL)
          IF(IERR.NE.0) GOTO 9000
C
          CALL HCDIR('//PAWC/TMP',' ')
          CALL HCDIR('//MN_HBOUT',' ')
          if(qcwntp) then
              call hfnt(987654)
          else
              CALL HFN(IDH,RVAL)
          endif
 3000 CONTINUE
*
      if(qcwntp) then
          call hrenid(98765,idh,' ')
      endif
*
 9000 CONTINUE
C
      CALL HCDIR('//PAWC/TMP',' ')
      CALL HCDIR('//MN_HBOUT',' ')
C
      END
