      SUBROUTINE M_IGTABL(NLEG,IDA,IDB,RBUF,NWPPT,NDIM,IDBIN,ADLO,ADHI
     + ,SCLIGT)
C
C-----------------------------------------------------------------------
C
C     Calls IGTABL from inside Mn_Fit
C
C     Called by MN_PLT
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mnprs.inc"
#include "mngrn.inc"
#include "mnpij.inc"
#include "mnleg.inc"
#include "mndbg.inc"
C
      INTEGER MPNTMX
      PARAMETER (MPNTMX=5000)
#include "mnscr.inc"
      REAL RBUG(6*MPNTMX)
      EQUIVALENCE(SCRATCH(1),RBUG(1))
C
      REAL RBUF(*)
      INTEGER NLEG,IDA,IDB,NWPPT,NDIM,IDBIN(*),IERR
      REAL ADLO(*),ADHI(*),SCLIGT
C
      INTEGER I,J,NPTR1,NPTR2,NJGPAR
      INTEGER NX1,NX2,NY1,NY2,NFONT,NPREC,ndecad
     + ,lleg,np,ncol,iopt,ntheta,nphi,ioerr
      REAL BIN,x1,x2,y1,y2,zz,size,thick,xx,yy,angle
      REAL RMIN(3),RMAX(3),ANGXY,ANGTHE,ANGPHI,AV(3,8),R(3,8)
     + ,AX1(3),AX2(3),AY1(3),AY2(3),AZ1(3),AZ2(3)
      INTEGER IX1,IX2,IY1,IY2,IZ1,IZ2
      LOGICAL QSCALT(10,3),QTICKT(10,3),QLABLT(10,3)
      character text*80
C
      IF(LIGOPTU.EQ.0) TIGOPTU = ' '
      LIGOPTU = MAX0(1,LIGOPTU)
*
*     Get the font for character and text plots
*
      IF(TIGOPTU(1:1).EQ.'T' .OR. TIGOPTU(1:1).EQ.'K') THEN
          AJGPAR(1) = ISIGN(MOD(IFNTU(4),1000),IFNTU(4))
          AJGPAR(2) = IABS(IFNTU(4))/1000
      ELSE
          AJGPAR(1) = AIGPARU(1)
          AJGPAR(2) = AIGPARU(2)
      ENDIF
*
*     Bin numbers to plot
*
      BIN = (XLO - ADLO(1)) / (ADHI(1) - ADLO(1)) * FLOAT(IDBIN(1))
      NX1 = MAX0(0,MIN0(IDBIN(1),NINT(BIN))) + 1
      BIN = (XHI - ADLO(1)) / (ADHI(1) - ADLO(1)) * FLOAT(IDBIN(1))
      NX2 = MAX0(1,MIN0(IDBIN(1),NINT(BIN)))
      BIN = (YLO - ADLO(2)) / (ADHI(2) - ADLO(2)) * FLOAT(IDBIN(2))
      NY1 = MAX0(0,MIN0(IDBIN(2),NINT(BIN))) + 1
      BIN = (YHI - ADLO(2)) / (ADHI(2) - ADLO(2)) * FLOAT(IDBIN(2))
      NY2 = MAX0(1,MIN0(IDBIN(2),NINT(BIN)))
*
*     Make sure these parameters are passed back to Mn_Fit
*
      XLO = ADLO(1) + FLOAT(NX1-1)/FLOAT(IDBIN(1))*(ADHI(1)-ADLO(1))
      XHI = ADLO(1) + FLOAT(NX2)  /FLOAT(IDBIN(1))*(ADHI(1)-ADLO(1))
      YLO = ADLO(2) + FLOAT(NY1-1)/FLOAT(IDBIN(2))*(ADHI(2)-ADLO(2))
      YHI = ADLO(2) + FLOAT(NY2)  /FLOAT(IDBIN(2))*(ADHI(2)-ADLO(2))
*
      ALEGU(1)   = AJGPAR(1)
      ALEGU(2)   = AJGPAR(2)
*
*     See if this is the first lego or surface plot on this page
*
      if(nsid.gt.0 .and.
     +   (nleg.eq.1 .or. nleg.eq.2 .or. nleg.eq.8)) then
          lleg = 0
          do 1000 np=1,nhplt
              if(ipltia(np).eq.ida .and. ipltib(np).eq.idb .and.
     +           (ipltlg(np).eq.1 .or. ipltlg(np).eq.2 .or.
     +            ipltlg(np).eq.8)) then
                  goto 1010
              elseif(ipltcl(np).eq.1) then
                  lleg = 0
              endif
              if(ipltlg(np).eq.1 .or. ipltlg(np).eq.2 .or.
     +           ipltlg(np).eq.8) lleg = lleg + 1
 1000     continue
 1010     continue
*
          if(lleg.eq.0) then
              size  = tszeu(3)
              nfont = ifntu(1)
              ncol  = icolu(5)
              thick = athku(5)
              xx = amrgu(1) + hszeu(1)
              yy = sizeu(2) - 1.5 * size
              angle = 0.0
              iopt = 1
              text = '[q]    ^o!, [f]    ^o!'
              ntheta = nint(alegu(1))
              nphi   = nint(alegu(2))
              write(text(4:7),'(i4)',iostat=ioerr) ntheta
              write(text(16:19),'(i4)',iostat=ioerr) nphi
              call mn_txt(xx,yy,text,size,angle,iopt
     +         ,nfont,ncol,thick)
          endif
      endif
*
*     Now setup IGTABL parameters
*
      AJGPAR( 3) = XLO
      AJGPAR( 4) = XHI
      AJGPAR( 5) = YLO
      AJGPAR( 6) = YHI
      if(ismodu(3).eq.2) then
          AJGPAR( 7) = alog10(zlo/zllo)
          AJGPAR( 8) = alog10(zhi/zllo)
      else
          AJGPAR( 7) = ZLO
          AJGPAR( 8) = ZHI
      endif
      AJGPAR( 9) = 1000*NX1 + NX2
      AJGPAR(10) = 1000*NY1 + NY2
      IF(NIGPARU.GT.2) CALL UCOPY_r(AIGPARU(3),AJGPAR(11),NIGPARU-2)
      IF(NIGPARU.GT.2) THEN
          NJGPAR = 10 + NIGPARU - 2
      ELSE
          NJGPAR = 10
      ENDIF
*
      NPTR1 = 0
      NPTR2 = 1 - NWPPT
      DO J=1,IDBIN(2)
          DO I=1,IDBIN(1)
              NPTR1 = NPTR1 + 1
              NPTR2 = NPTR2 + NWPPT
              if(ismodu(3).eq.2) then
                  zz = amax1(zlo,amin1(zhi,rbuf(nptr2)))
                  RBUG(NPTR1) = alog10(zz/zllo)
              else
                  rbug(nptr1) = rbuf(nptr2)
              endif
          ENDDO
      ENDDO
CICB*
CICB*     Setup HIGZ options
CICB*
CICB      IF(QWIND) THEN
CICB          XMGL = AMRGU(1) + WMRGU(1)
CICB          XMGR = SIZEU(1) - AMRGU(1) - WMRGU(1) - WSZEU(1)
CICB          YMGL = AMRGU(2) + WMRGU(2)
CICB          YMGU = SIZEU(2) - AMRGU(2) - WMRGU(2) - WSZEU(2)
CICB      ELSE
CICB          XMGL = AMRGU(1)
CICB          XMGR = SIZEU(1) - AMRGU(1) - HSZEU(1)
CICB          YMGL = AMRGU(2) + WMRGU(2)
CICB          YMGU = SIZEU(2) - AMRGU(2) - HSZEU(2)
CICB      ENDIF
*
*     Define the viewport for the current normalization transformation
*
      x1 = antvp(1) + xplo / sizeu(1) * (antvp(2)-antvp(1))
      x2 = antvp(1) + xphi / sizeu(1) * (antvp(2)-antvp(1))
      y1 = antvp(3) + yplo / sizeu(2) * (antvp(4)-antvp(3))
      y2 = antvp(3) + yphi / sizeu(2) * (antvp(4)-antvp(3))
      call isvp(1,x1,x2,y1,y2)
      call iselnt(1)
CICB      write(6,'('' Define viewport - x1,x2,y1,y2:'',2(2f8.4,2x))')
CICB     + x1,x2,y1,y2
*
*     Line thicknesses and fonts
*
      CALL IGSET('LWID',ATHKU(7))
      CALL IGSET('CSHI',0.015)
      CALL IGSET('PASS',AMAX1(1.0,ATHKU(5)))
*
*     Scale the font size with the picture size - this appears not to
*     be perfect, but it is not bad.
*
      NPREC = IABS(IFNTU(5))/1000
      NFONT = ISIGN(MOD(IABS(IFNTU(5)),1000),IFNTU(5))
      CALL IGSET('TXFP',FLOAT(10*NFONT+NPREC))
      size = scalu(3,3) / (yhi-ylo)
      call igset('LASI',size)
*
*     Turn off scale and ticks for 2-D representations
*     Get the information needed for drawing ticks and scale
*
      IF(NLEG.EQ.8) THEN
          NJGPAR     = MAX0(24,NJGPAR)
CICB          AJGPAR(11) = 510.
          AJGPAR(11) = 0.0
          AJGPAR(12) = 510.
          if(ismodu(3).eq.2) then
              ndecad = int(alog10(zhi/zlo)) + 1
              AJGPAR(13) = float(100*ndecad + ndecad)
          else
              AJGPAR(13) = 510.
          endif
          AJGPAR(14) = 1.
          AJGPAR(15) = 1.
          AJGPAR(16) = 1.
          AJGPAR(17) = 0.02
          AJGPAR(18) = 0.02
          AJGPAR(19) = 0.02
          AJGPAR(20) = 0.02
          AJGPAR(21) = 2.
          AJGPAR(22) = 0.02
          AJGPAR(23) = 0.02
          AJGPAR(24) = 0.04
*
*         Extra parameters define the colours
*
          IF(NIGPARU.GT.2) THEN
              NJGPAR = 24 + NIGPARU - 2
              CALL UCOPY_r(AIGPARU(3),AJGPAR(25),NIGPARU-2)
          ENDIF
      ENDIF
*
      CALL IGTABL(IDBIN(1),IDBIN(2),RBUG,NJGPAR,AJGPAR
     + ,TIGOPTU(:LIGOPTU))
*
*     Setup the co-ordinate system again for lego and surface plots
*
      if(nleg.eq.8) then
          RMIN(1) = XLO
          RMAX(1) = XHI
          RMIN(2) = YLO
          RMAX(2) = YHI
          if(ismodu(3).eq.2) then
              RMIN(3) = alog10(zllo)
              RMAX(3) = alog10(zhi/zllo)
          else
              RMIN(3) = ZLO
              RMAX(3) = ZHI
          endif
          ANGXY   = 90.0
          COSA   = COS(ANGXY*DRAD)
          SINA   = SIN(ANGXY*DRAD)
          ANGTHE =  90.0-ALEGU(1)
          ANGPHI = -90.0-ALEGU(2)
          CALL IHSVIE(RMIN,RMAX,ANGPHI,ANGTHE,0.0,IERR)
          CALL IGTAB4(RMIN,RMAX,0.0)
          CALL IHAXIV(RMIN,RMAX,ANGXY,AV,IX1,IX2,IY1,IY2,IZ1,IZ2)
          write(6,'('' Axis vertices: x1,x2,y1,y2,z1,z2:'',6i4)')
     +     ix1,ix2,iy1,iy2,iz1,iz2
          DO I=1,8
              R(1,I) = AV(1,I) + AV(2,I)*COSA
              R(2,I) = AV(2,I)*SINA
              R(3,I) = AV(3,I)
          ENDDO
          CALL IHWTON(R(1,IX1),AX1)
          CALL IHWTON(R(1,IX2),AX2)
          CALL IHWTON(R(1,IY1),AY1)
          CALL IHWTON(R(1,IY2),AY2)
          CALL IHWTON(R(1,IZ1),AZ1)
          CALL IHWTON(R(1,IZ2),AZ2)
CICB          write(6,'('' Co-ordinate of x1:'',2(3f8.4,2x))')
CICB     +     (r(ii,ix1),ii=1,3),ax1
CICB          write(6,'('' Co-ordinate of x2:'',2(3f8.4,2x))')
CICB     +     (r(ii,ix2),ii=1,3),ax2
CICB          write(6,'('' Co-ordinate of y1:'',2(3f8.4,2x))')
CICB     +     (r(ii,iy1),ii=1,3),ay1
CICB          write(6,'('' Co-ordinate of y2:'',2(3f8.4,2x))')
CICB     +     (r(ii,iy2),ii=1,3),ay2
CICB          write(6,'('' Co-ordinate of z1:'',2(3f8.4,2x))')
CICB     +     (r(ii,iz1),ii=1,3),az1
CICB          write(6,'('' Co-ordinate of z2:'',2(3f8.4,2x))')
CICB     +     (r(ii,iz2),ii=1,3),az2
CICB          call igaxis(ax1(1),ax2(1),ax1(2),ax2(2),xlo,xhi,510,'=+')
CICB          call igaxis(ay1(1),ay2(1),ay1(2),ay2(2),ylo,yhi,510,'=+')
*
*         Now setup for Mn_Fit which axes should have ticks and scales
*
          call qcopy(qscalu,qscalt,10*3)
          call qcopy(qticku,qtickt,10*3)
          call qcopy(qlablu,qlablt,10*3)
          SCLIGT = 1.0 / (XPHI-XPLO) * (ANTVP(2)-ANTVP(1)) * 2.0
      else
*
*     Change back to Mn_Fit normalization transformation
*
          CALL TVRNG(.TRUE.,0.0,0.0,SIZEU(1),SIZEU(2))
          SCLIGT = 1.0
      endif
*
 9000 CONTINUE
      END
