      SUBROUTINE MN_DPL(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     + ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     Subroutine that controls the display of the various L3 or ZEUS
C     detectors.
C     Implemented for L3 are:
C     BGO:                         EC_DSP
C     Luminosity monitor BGO:      FB_DSP
C     Luminosity monitor chambers: FW_DSP
C     Luminosity monitor silicon:  FS_DSP
C
C     Implemented for ZEUS are:
C     FTD:                         FT_DSP
C     TRD:                         TR_DSP
C
      IMPLICIT NONE
C
      INTEGER IDA,IDB,NDIM,NWPPT,NPNT,IERR
      REAL    EDLO,EDHI
      REAL RBUF(*)
      INTEGER IDBIN(*)
      REAL ADLO(*),ADHI(*)
C
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
#include "mnpar.inc"
#include "mndsp.inc"
#include "mnhpj.inc"
#include "mnprs.inc"
#include "mnlun.inc"
#endif

C
#if ( defined(L3DSP_SRC) )
C
C     BGO display
C
      IF(DETNAM(NDSPTP).EQ.'ECAL') THEN
          CALL EC_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     FLUM BGO display
C
      ELSEIF(DETNAM(NDSPTP).EQ.'FBGO') THEN
          CALL FB_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     FLUM chamber display
C
      ELSEIF(DETNAM(NDSPTP).EQ.'FWCH') THEN
          CALL FW_DSP(IDA,IDB,NDIM,NWPPT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     FLUM silicon display
C
      ELSEIF(DETNAM(NDSPTP).EQ.'FSIL') THEN
          CALL FS_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     TEC display
C
      ELSEIF(DETNAM(NDSPTP).EQ.'TECH') THEN
          CALL TE_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
#endif
#if ( defined(ZEUSDSP_SRC) )
C
C     FTD display
C
      IF(DETNAM(NDSPTP).EQ.'FTD') THEN
          CALL FT_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C     TRD display
C
      ELSEIF(DETNAM(NDSPTP).EQ.'TRD') THEN
          CALL TR_DSP(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
#endif
#if ( defined(L3DSP_SRC) || defined(ZEUSDSP_SRC) )
C
C     Other displays
C
      ELSEIF(NDSPTP.GT.0)  THEN
          CALL MN_ERR('MN_DPL','Display ' // DETNAM(NDSPTP) //
     +     ' not implemented yet')
          RETURN
      ENDIF
C
C     Store the limits in registers
C
      REGIS(201) = XPLO
      REGIS(202) = XPHI
      REGIS(203) = YPLO
      REGIS(204) = YPHI
      REGIS(205) = XLO
      REGIS(206) = XHI
      REGIS(207) = YLO
      REGIS(208) = YHI
C
#endif

9000  CONTINUE
      END
