      SUBROUTINE M_MORE(NPTRH2,NPTRD2,NWRD,IERR)
C
C     Expand a plot by a given number of words.
C     Check that there is space available and that the histogram is OK.
C
C     NPTRH2 is the pointer to the header
C     NPTRD2 is the pointer to the data
C     NMORE  is the number of extra words
C     IERR   is an error return
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
*
      integer nptrh2,nptrd2,nwrd,ierr
*
      integer nw,nh,nwneed
C
      IERR = 0
C
C     SEE IF I HAVE ENOUGH SPACE LEFT
C
      NW = NDPTE
      NH = NPTRD2 - NPTRH2 + 1
      IF(NWRD.GT.0) THEN
          NWNEED = NH + NWRD
          IF(NW+NWNEED.GT.NHSTWD) THEN
              CALL M_EMSG('MN_HNW'
     +         ,'I have run out of space for expanding this plot')
              CALL MN_ERR('MN_HNW'
     +         ,'Issue the command SQUEEZE to get unused space back')
              IERR = 1
              GOTO 9000
          ENDIF
      ENDIF
C
 9000 CONTINUE
      END
