      SUBROUTINE MN_AVF(IDELIM)
C
      implicit none
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      integer mpntmx
      PARAMETER (MPNTMX=20000)
C      COMMON/MNSCR/BUFDAT(MPNTMX)
#include "mnscr.inc"
      REAL BUFDAT(MPNTMX)
      EQUIVALENCE(SCRATCH(1),BUFDAT(1))
C
      INTEGER IBFDAT(MPNTMX)
      EQUIVALENCE (BUFDAT,IBFDAT)
C
      integer mavef
      PARAMETER (MAVEF=6)
      CHARACTER*1 AVENAM(MAVEF)
C
      INTEGER IDBIN(2)
      REAL ADLO(2),ADHI(2)
      REAL ACONT(3**2)
C
      CHARACTER*32 TNDEF(2)
C
      CHARACTER*80 TITLE
      CHARACTER*132 ATEXT
      INTEGER IDLST1(MHSTMX),IDLST2(MHSTMX)
      LOGICAL QZERO
*
      integer idelim,njunk,ndhis0,ierr,nidl,nidr,ida1,idb1,ida2,idb2
     + ,nnid,ida,idb,lena,lent,lnblnk
     + ,idf,il,it,ntype,nbinx,nbiny,nnum,ndim,nwppt,nwrd,nbppt,nbppta
     + ,nwave,ibmsk,ii,jj,ncpos,indx,ind,ntmode,nh,nptrh,nptrd,nwh
     + ,n1,n2,n3,n4,npnt,nwpt,nline,nxb,nyb,nnxy,nptb,nptr
     + ,nw1,nw2,nb1,nshft,ient,nwdat,nwtot,nhdate,nhtime,nsdate,nstime
      real xflo,yflo,dfx,dfy,xxlo,xxhi,yylo,yyhi,x,dx,ee,dee
     + ,edlo,edhi,edent
*
      integer  inttyq,inttyp,nchscn
      real reltyp
      external inttyq,inttyp,nchscn,reltyp
C
      DATA AVENAM/'*','/','+','%','&',' '/
      DATA TNDEF/'X', 'Y'/
C
#if ( defined(UNIX) ) && ( defined(LINUX) )
      CALL MN_ERR('MN_AVF','Avehist files not supported under Linux')
      RETURN
#endif
#if ( !defined(UNIX) || !defined(LINUX) )
C
      IF(IDELIM.EQ.0) THEN
          NJUNK = INTTYQ(.TRUE.,IDELIM)
          CALL RESTYQ
      ENDIF
C
      NDHIS0 = NDHIS
C
      IF(FIL_AV.EQ.' ' .OR.
     1   (IDELIM.GT.0 .AND. IDELIM.NE.ICHAR(':'))) THEN
          CALL MN_FIL(2,LUNAIN,FIL_AV,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
      ELSE
          REWIND LUNAIN
      ENDIF
C
      NIDL = 0
      NIDR = 0
      QZERO = .FALSE.
 2000 CONTINUE
      CALL WAITYQ('Give histogram number(s): ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 8000
      IF(NNID.GT.1) THEN
          CALL M_EMSG('MN_AVF','AVEHST does not know about' //
     1     ' secondary identifiers')
          CALL MN_ERR('MN_AVF','It will be ignored')
      ENDIF
C
      IF(NIDL.GE.100) THEN
          CALL M_EMSG('MN_AVF','Ran out of space to store plot' //
     1       ' numbers to get')
          CALL MN_ERR('MN_AVF'
     +     ,'Issue AVE_FETCH command again to get more plots.')
          GOTO 2200
      ENDIF
C
      IF(IDA1.EQ.0 .OR. IDA1.NE.IDA2) QZERO = .TRUE.
      NIDL = NIDL + 1
      IDLST1(NIDL) = IDA1
      IDLST2(NIDL) = IDA2
      IF(IDELIM.GE.0) GOTO 2000
 2200 CONTINUE
      IF(NIDL.LE.0) GOTO 8000
C
C     READ IN THE DATA
C
      IDB = NDIDB
 2500 CONTINUE
      READ(LUNAIN,'(A)',ERR=9100,END=2461) ATEXT
      LENA = LNBLNK(ATEXT)
      GOTO 2465
 2461 CONTINUE
      IF(.NOT.QZERO) CALL MN_MES(LUNTTO,'ME',' End of file reached')
      GOTO 8000
C
C     SEE IF THIS IS THE HISTOGRAM DEFINITION CARD
C
 2465 CONTINUE
C
C     Data - with a compressed file it can start in column 1
C
      IF(ATEXT(1:1).EQ.' ' .OR.
     +   (ATEXT(1:1).GE.'0' .AND. ATEXT(1:1).LE.'9') .OR.
     +   ATEXT(1:1).EQ.'-') THEN
          GOTO 2500
C
C     COMMENT CARD
C
      ELSEIF(ATEXT(1:1).EQ.';') THEN
          GOTO 2500
      ENDIF
C
C     CARD MUST BE A HISTOGRAM DEFINITION CARD
C
      CALL QUOTYP(ATEXT(2:LENA))
      IDF = INTTYP(.TRUE.,IDELIM)
      IF(IDELIM.GT.0) GOTO 9100
      CALL RESTYP
CICB      READ(ATEXT(2:),*,ERR=9100) IDF
      IF(IDLST1(1).NE.0) THEN
          DO 2470 IL=1,NIDL
              IF(IDLST1(IL).EQ.0 .OR.
     1           (IDF.GE.IDLST1(IL) .AND. IDF.LE.IDLST2(IL))) THEN
                  GOTO 2550
              ENDIF
2470      CONTINUE
          GOTO 2500
      ENDIF
2550  CONTINUE
C
C     SEE IF THIS HISTOGRAM TYPE IS SUPPORTED
C
      NTYPE = 0
      DO 2560 IT=1,MAVEF-1
          IF(ATEXT(1:1).EQ.AVENAM(IT)) THEN
              NTYPE = IT
              GOTO 2570
          ENDIF
2560  CONTINUE
      CALL MN_ERR('MN_AVF','Histogram type ' // ATEXT(1:1) //
     + ' not supported')
      GOTO 6000
 2570 CONTINUE
C
C     TYPE 1 IS A HISTOGRAM WITHOUT ERROR BARS
C     TYPE 2 IS A HISTOGRAM WITH ERROR BARS
C     TYPE 3 IS A HISTOGRAM WITH ERROR BARS
C     TYPE 4 IS A VARIABLE BINNED HISTOGRAM
C     TYPE 5 IS A SCATTER PLOT
C
      IF(NTYPE.LE.3) THEN
C         '(I,F,F,I,A)'
2600      IDA   = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(IDA.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2600
2610      XFLO  = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(XFLO.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2610
2620      DFX   = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(DFX.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2620
2630      NBINX = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(NBINX.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2630
CICB          READ(ATEXT(2:),*,ERR=9100) IDA,XFLO,DFX,NBINX
          NNUM  = 4
          NDIM  = 1
          NWPPT = 2
          NWRD  = NWPPT*NBINX
      ELSEIF(NTYPE.EQ.4) THEN
C         '(1X,I12,I12,A)'
2700      IDA   = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(IDA.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2700
2710      NBINX = INTTYP(.TRUE.,IDELIM)
          IF(NBINX.LE.0 .AND. IDELIM.GT.0) GOTO 9100
          IF(NBINX.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2710
CICB          READ(ATEXT(2:),*,ERR=9100) IDA,NBINX
          NNUM  = 2
          NDIM  = -1
          NWPPT = 4
          NWRD  = NWPPT*NBINX
      ELSEIF(NTYPE.EQ.5) THEN
2800      IDA   = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(IDA.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2800
2810      XFLO  = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(XFLO.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2810
2820      DFX   = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(DFX.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2820
2830      NBINX = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(NBINX.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2830
2840      YFLO  = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(YFLO.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2840
2850      DFY   = RELTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(DFY.EQ.0.0 .AND. NCHSCN().EQ.0) GOTO 2850
2860      NBINY = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(NBINY.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2860
2870      NBPPTA = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(NBPPTA.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2870
2880      NWAVE = INTTYP(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 9100
          IF(NWAVE.EQ.0 .AND. NCHSCN().EQ.0) GOTO 2880
CICB          READ(ATEXT(2:),*,ERR=9100) IDA,XFLO,DFX,NBINX,YFLO,DFY,NBINY
CICB     1     ,NBPPTA,NWAVE
          NNUM  = 9
          NDIM  = 2
          NWPPT = 2
          NWRD  = NWPPT*NBINX*NBINY
          IBMSK = 0
          DO 2900 II=1,NBPPTA
              IBMSK = IBSET(IBMSK,II-1)
2900      CONTINUE
      ENDIF
C
C     CLEAR OUT THE TYPSCN BUFFER
C
      CALL ZERTYP('.FALSE.')
C
C     CHECK THAT I HAVE ENOUGH INTERMEDIATE STORAGE SPACE
C
      IF(NTYPE.EQ.1) THEN
          NWAVE = NBINX+2
      ELSEIF(NTYPE.EQ.2 .OR. NTYPE.EQ.3) THEN
          NWAVE = 2*(NBINX+2)
      ELSEIF(NTYPE.EQ.4) THEN
          NWAVE = 4*(NBINX+2)
      ENDIF
      IF(NWAVE.GT.MPNTMX) THEN
          WRITE(TXTERR,'('' I do not have enough intermediate''
     1     ,'' storage space to read in histogram'',I6)') IDA
          CALL MN_ERR('MN_AVF',TXTERR)
          GOTO 6000
      ENDIF
C
C     FIND OUT WHERE THE TITLE STARTS
C
      NCPOS = 1
      DO 2920 II=1,NNUM
          INDX = INDEX(ATEXT(NCPOS:),',')
          IF(NTYPE.EQ.4 .AND. INDX.EQ.0) INDX = 25
          IF(INDX.GT.0) NCPOS = NCPOS + INDX
2920  CONTINUE
C
C     CALL MN_SPC(ATEXT(NCPOS:),TITLE)
      TITLE = ATEXT(NCPOS:)
C
C     GET RID OF MULTIPLE 0'S IN SLICE
C
      IF(INDEX(TITLE,'Slice').GT.0) THEN
2950      CONTINUE
          IND = INDEX(TITLE,'00 ')
          IF(IND.EQ.0) THEN
              LENT = LNBLNK(TITLE)
              IF(TITLE(LENT-1:LENT).EQ.'00') THEN
                  TITLE = TITLE(1:LENT-1)
                  GOTO 2950
              ENDIF
          ELSE IF(IND.GT.5) THEN
              TITLE = TITLE(1:IND-1) // TITLE(IND+1:)
              GOTO 2950
          ENDIF
      ENDIF
C
C     FIND OUT WHERE TO STORE THE HISTOGRAM
C
      NBPPT  = 0
      NTMODE = 0
      CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
      IF(NH.LE.0) GOTO 8000
C
C     READ IN THE ENTRIES
C
3000  CONTINUE
      IF(NTYPE.EQ.1) THEN
          N1 = 1
          N2 = NBINX+2
          READ(LUNAIN,*,ERR=3100,END=3200) (BUFDAT(II),II=N1,N2)
          NPNT = NBINX
          NWPT = NBINX
          XXLO = XFLO
          XXHI = XFLO + FLOAT(NBINX)*DFX
      ELSEIF(NTYPE.EQ.2 .OR. NTYPE.EQ.3) THEN
          N1 = 1
          N2 = NBINX + 2
          N3 = NBINX + 2 + 1
          N4 = 2 * (NBINX+2)
          READ(LUNAIN,*,ERR=3100,END=3200) (BUFDAT(II),II=N1,N2)
     1     ,(BUFDAT(II),II=N3,N4)
          NPNT = NBINX
          NWPT = NBINX
          XXLO = XFLO
          XXHI = XFLO + FLOAT(NBINX)*DFX
      ELSEIF(NTYPE.EQ.4) THEN
          N1 = 1
          N2 = 4*NBINX
          READ(LUNAIN,*,ERR=3100,END=3200) (BUFDAT(II),II=N1,N2)
          NPNT = NBINX
          NWPT = NBINX
          XXLO = 1.0E+12
          XXHI = -1.0E+12
      ELSEIF(NTYPE.EQ.5) THEN
          N1 = 1
          N2 = NWAVE
C         READ(LUNAIN,*) IBFDAT
C         READ(LUNAIN,*,ERR=3100,END=3200) (IBFDAT(II),II=N1,N2)
          NLINE = (NWAVE-1)/8 + 1
          DO 3060 II=1,NLINE
              N1 = (II-1)*8 + 1
              N2 = MIN0(NWAVE,II*8)
              READ(LUNAIN,'(8(1X,Z8,1X))',ERR=3100,END=3200)
     1         (IBFDAT(JJ),JJ=N1,N2)
C             WRITE(LUNTTO,'(1X,I4,'':'',8(Z8,'',''))')
C     1        N1,(IBFDAT(JJ),JJ=N1,N2)
3060      CONTINUE
          NPNT = NBINX * NBINY
          NWPT = (NBINX+2) * (NBINY+2)
          XXLO = XFLO
          XXHI = XFLO + FLOAT(NBINX)*DFX
          YYLO = YFLO
          YYHI = YFLO + FLOAT(NBINY)*DFY
      ENDIF
      GOTO 3300
 3100 CONTINUE
      WRITE(TXTERR,'(''Error reading in histogram'',I6)') IDA
      CALL MN_ERR('MN_AVF',TXTERR)
      GOTO 6000
 3200 CONTINUE
      WRITE(TXTERR,'('' MN_AVF: End of file reached''
     1 ,'' reading in histogram'',I6)') IDA
      CALL MN_ERR('MN_AVF',TXTERR)
      GOTO 8000
 3300 CONTINUE
      EDLO = 1.0E+30
      EDHI = -1.0E+30
      EDENT = 0.0
      NYB = -1
      NXB =  0
      NNXY = 0
      DO 5000 II=1,NWPT
          NPTB = NWPPT*(II-1)
          NPTR = NPTRD + NPTB - 1
          IF(NTYPE.LE.3) THEN
              X  = XXLO + (FLOAT(II-1)+0.5)*DFX
              DX = 0.5 * DFX
              EE = BUFDAT(II)
              IF(NTYPE.EQ.1) THEN
                  DEE = SQRT(ABS(EE))
              ELSE
                  DEE = BUFDAT(II+NBINX+2)
              ENDIF
              IF(NDIM.LT.0) THEN
                  RDAT(NPTR+1) = X
                  RDAT(NPTR+2) = EE
                  RDAT(NPTR+3) = DX
                  RDAT(NPTR+4) = DEE
              ELSE
                  RDAT(NPTR+1) = EE
                  RDAT(NPTR+2) = DEE
              ENDIF
          ELSEIF(NTYPE.EQ.4) THEN
              X   = BUFDAT(NPTB+1)
              DX  = 0.5*BUFDAT(NPTB+2)
              EE  = BUFDAT(NPTB+3)
              DEE = BUFDAT(NPTB+4)
              RDAT(NPTR+1) = X
              RDAT(NPTR+2) = EE
              RDAT(NPTR+3) = DX
              RDAT(NPTR+4) = DEE
              XXLO = AMIN1(XXLO,X-DX)
              XXHI = AMAX1(XXHI,X+DX)
          ELSEIF(NTYPE.EQ.5) THEN
              NYB = NYB + 1
              IF(NYB.GT.NBINY+1) THEN
                  NXB = NXB + 1
                  NYB = 0
              ENDIF
              NW1 = NBPPTA*(II-1)/32 + 1
              NW2 = (NBPPTA*II-1)/32 + 1
              NB1 = MOD(NBPPTA*(II-1),32) + 1
              NSHFT = NB1 - 1
              IENT = ISHFT(IBFDAT(NW1),-NSHFT)
              IF(NW2.NE.NW1) THEN
                  NSHFT = 32 - NB1 + 1
                  IENT = IOR(IENT,ISHFT(IBFDAT(NW2),NSHFT))
              ENDIF
              IENT = IAND(IENT,IBMSK)
              EE  = FLOAT(IENT)
              DEE = SQRT(ABS(EE))
              IF(NXB.GT.0 .AND. NXB.LE.NBINX .AND.
     1           NYB.GT.0 .AND. NYB.LE.NBINY) THEN
                  NNXY = NBINX*(NYB-1) + NXB
                  NPTR = NPTRD + NWPPT*(NNXY-1) - 1
                  RDAT(NPTR+1) = EE
                  RDAT(NPTR+2) = DEE
              ELSE
                  GOTO 5000
              ENDIF
          ENDIF
          EDENT = EDENT + EE
          EDLO = AMIN1(EDLO,EE-DEE)
          EDHI = AMAX1(EDHI,EE+DEE)
5000  CONTINUE
C
C     WRITE(LUNTTO,'('' Histogram'',I7,I4,''  Data for'',I6
C     1,'' points read in'')') IDA,IDB,NPNT
      NIDR = NIDR + 1
C
      NWDAT = NWPPT * NPNT
      NWTOT = NWH + NWDAT
C
      IDBIN(1) = NBINX
      ADLO(1)  = XXLO
      ADHI(1)  = XXHI
      IF(IABS(NDIM).GT.1) THEN
          IDBIN(2) = NBINY
          ADLO(2)  = YYLO
          ADHI(2)  = YYHI
      ENDIF
C
      NHDATE = 0
      NHTIME = 0
      NSDATE = 0
      NSTIME = 0
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB,NDIM,NWPPT,NPNT
     + ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE,FIL_AV,' ',TNDEF)
      CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
6000  CONTINUE
      IF(NIDR.LT.NIDL .OR. QZERO) GOTO 2500
C
8000  CONTINUE
C
C     CLEAR OUT THE TYPSCN BUFFER
C
      CALL ZERTYP('.FALSE.')
C
C     CHECK THAT I GOT THE HISTOGRAMS I WANTED
C
      NNID = 1
      CALL MN_HNG('MN_AVF',NNID,NDHIS0,NIDL,IDLST1,IDLST2,IDB,IDB)
C
9000  CONTINUE
      RETURN
C
9100  CONTINUE
      CALL MN_ERR('MN_AVF','Error reading in histograms')
C
C     CLEAR OUT THE TYPSCN BUFFER
C
      CALL ZERTYP('.FALSE.')
C
      RETURN
#endif

      END
