      SUBROUTINE MN_PLT(IDA,IDB,RBUF,NDIM,NWPPT,NPNT,NOVEFL
     + ,TITLE,TFILE,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,AMEAN,ASIG,ACONT,IERR)
C------------------------------------------------------------------------------
C
C     MAIN ROUTINE FOR DECIDING ON SCALE ETC AND PLOTTING A HISTOGRAM
C
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mnprs.inc"
#include "mnflg.inc"
#include "mnpij.inc"
#include "mnplt.inc"
C
      INTEGER MPNTMX
      PARAMETER (MPNTMX=5000)
#include "mnscr.inc"
      REAL RBUG(6*MPNTMX)
      EQUIVALENCE(SCRATCH(1),RBUG(1))
C
      INTEGER IDA,IDB,NDIM,NWPPT,NPNT,NOVEFL
     + ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE,IERR
      REAL EDENT,EDLO,EDHI
      REAL RBUF(*)
      INTEGER IDBIN(*)
      REAL ADLO(*),ADHI(*),AMEAN(*),ASIG(*),ACONT(*)
      CHARACTER  TITLE*80,TFILE*80
C
      REAL XPT(10),YPT(10),XXPT(10),YYPT(10)
      CHARACTER*20 TNUMB
      CHARACTER*255 TXT1,TXT2,CONCAT
      LOGICAL QFRAM,QTICK,QINS,QOUT,QSCAL,QLABL,QLPAG,QGRID
      LOGICAL QBIG,QPNTPL,QPIP
      LOGICAL QERRL,QERRH,QTMP
C
      INTEGER NLEG,NSENT,NDIMN,II,JJ,JERR,NPPLT,NSEGM
     + ,NFONT,NCOL,IOPT,ioptl(3),NSYM,nscol,nhcol,npcol
     + ,NAX1,NAX2,NAX,NXN,IYY,NP10,NG1,NG2
     + ,NGSTEP,NN,NMAG,NWPPO,NOFF,NOFFL,NOFFH,NDBX,NDBY,NLOOP,NL
     + ,NX1,NX2,NPT,NX,NY,NPTR,NPTR1,NCTOPT,NSMODE,NAXW
     + ,NTLO,NTICS,NBTIC,NOTIC
     + ,NADIFB,NDIGI,NDECI,NPOWER,NP11
     + ,NAAL,NAAH,ITB,JTB,N1,N2,ITIC,NMODE,NCHAR,NNCHAR,NNMOD
      REAL THICK,XUNIT,SIZE,ANGLE,XX,YY,XX0,YY0
     + ,BLO,BHI,BDLO,BDHI,EEV,EEM,EET,ELO,EHI,DX,Y,DY
     + ,ALO,AHI,ADIF,ATLO,ATHI,ATDIF
     + ,DEL,AFACT,ATFRC,ATSDIF,AAL,AAH
     + ,XL,YL,ADS,ADA,YT,YU,XT,XU,XV,YV,ADI,ADO,CANG,SANG,CANGL,SANGL
     + ,ANUMB,AFNUMB,SIZET,XXT,YYT,XXG,YYG,XPL,YPL,XXL,YYL
     + ,XXL1,YYL1,XXL2,YYL2
     + ,ANG,ANGX,ZL,SCLIGT,rphi
*
      real tscl(3),toff(3),scale,offset,aulo(3),auhi(3),rnumb
     + ,xxt0,yyt0,xxtl,yytl,rnumb0,rnumbl,anumb0
      integer ntdb,ndate,ntime,itsec,nmon
      logical qtime,qzlog,qlflip
      character tmnth(12)*3
*
      save tscl,toff,nax1,nax2
*
      INTEGER  LNBLNK
      real     am_tdif
      EXTERNAL LNBLNK,am_tdif
C
#include "mnpltd.inc"
      DATA NPPLT/0/
      data tmnth/'Jan','Feb','Mar','Apr','May','Jun'
     +          ,'Jul','Aug','Sep','Oct','Nov','Dec'/
C
      NLEG   = MOD(NLEGU,100)
      QPNTPL = MOD(NLEGU/100,10).EQ.1
      SCLIGT = 1.0
C
      IERR = 0
*
*     Ntuple plots and detector displays handle the number of dimensions
*     themselves
*
      IF(NDIM.GT.2 .OR.
     +   (NDIM.LT.-2 .AND. .NOT.QPNTPL .and. nleg.ne.11)) THEN
          IERR = 2
          RETURN
*
*     All lego, surface, etc. plots must be 2-D
*
      ELSEIF(NLEG.GT.0 .AND. NLEG.LT.10 .AND. NDIM.NE.2) THEN
          IERR = 4
          RETURN
      ELSEIF(NLEG.LT.0 .AND. IABS(NDIM).NE.1) THEN
          IERR = 3
          RETURN
      ENDIF
C
C     DECIDE WHERE ENTRY LIMITS WOULD BE STORED
C
      IF(QPNTPL) THEN
          IF(INTPMN(1).LE.0 .OR. INTPMN(2).LE.0) THEN
              IERR = 5
              RETURN
          ENDIF
          NDIMN = 2
          IF(INTPMN(3).LE.0) THEN
              NDIMN = 1
          ENDIF
      ELSE
          NDIMN = NDIM
      ENDIF
      NSENT = IABS(NDIMN) + 1
*
*     For detector displays set the entry limit to at most 3
*     and number of real dimensions to at most 2
*
      if(nleg.eq.11) then
          ndimn = min0(2,iabs(ndimn))
          if(ndim.lt.0) ndimn = -ndimn
          nsent = min0(3,nsent)
      endif
C
C     Check for screwy limits.
C     Don't return if the plot has no entries, but leave the  error
C     flag so that a warning message is printed
C---------------------------------------------------------------------
      IF(QPNTPL) THEN
          IF(NPNT.LE.0) THEN
              IERR = 1
              RETURN
          ENDIF
      ELSEIF((EDLO.EQ.0.0 .AND. EDHI.EQ.0.0 .AND.
     1    ALIMU(1,NSENT).EQ.0.0 .AND. ALIMU(2,NSENT).EQ.0.0) .OR.
     1   (ALIMU(2,NSENT).LT.ALIMU(1,NSENT)) .OR.
     1   (ALIMU(1,NSENT).EQ.0.0 .AND. ALIMU(2,NSENT).EQ.0.0 .AND.
     1    ((EDLO.EQ.0.0 .AND. EDHI.EQ.0.0) .OR.
     1     EDLO.GT.EDHI))) THEN
*ICB     1    EDHI.LE.EDLO))THEN
          IF(NLEG.NE.10 .AND. NLEG.NE.11) IERR = 1
      ENDIF
C
C     Check for log scale limits
C
      IF(ISMODU(NSENT).EQ.2 .AND. EDHI.LE.0) THEN
          IERR = 1
          RETURN
      ENDIF
*
*     Log scale not allowed for x and y axes of lego and surface plots
*
      if(nleg.eq.1 .or. nleg.eq.2 .or.
     +   (nleg.ge.7 .and. nleg.le.9)) then
          if(ismodu(1).eq.2 .or. ismodu(2).eq.2) then
              ierr = 6
              return
          endif
      endif
C
C     Check the limits etc.
C     For detectors displays hope the user knows what he/she is doing
C
      if(nleg.ne.11) then
          DO 1000 JJ=1,IABS(NDIMN)
              IF(QPNTPL) THEN
                  II = INTPMN(JJ)
              ELSE
                  II = JJ
              ENDIF
              IF((ADLO(II).EQ.0.0 .AND. ADHI(II).EQ.0.0 .AND.
     1         ALIMU(1,JJ).EQ.0.0 .AND. ALIMU(2,JJ).EQ.0.0) .OR.
     2         (ALIMU(2,JJ).LT.ALIMU(1,JJ)) .OR.
     3         (ALIMU(2,JJ).LE.ALIMU(1,JJ) .AND.
     3         (ALIMU(1,JJ).NE.0.0 .OR. ALIMU(2,JJ).NE.0.0)) .OR.
     4         (ALIMU(1,JJ).EQ.0.0 .AND. ALIMU(2,JJ).EQ.0.0 .AND.
     4         ADHI(II).LE.ADLO(II))) THEN
                  IERR = 1
                  RETURN
              ELSEIF(ISMODU(II).EQ.2 .AND.
     +             (ALIMU(2,JJ).LT.0.0 .OR.
     +             (ALIMU(2,JJ).LE.0.0 .AND. ADHI(II).LE.0.0))) THEN
                  IERR = 1
                  RETURN
              ENDIF
 1000     CONTINUE
      endif
C
C     SWITCH TO GRAPHICS MODE IF NECESSARY
C
      CALL MN_TON(JERR)
      IF(JERR.NE.0) THEN
          IERR = -1
          RETURN
      ENDIF
C
C     START A NEW PAGE AND CENTRE PLOT ON THE PAGE
C     IF USING HPLTAB THEN LET IT START THE NEW PAGE
C
      IF(NCLRU.EQ.1) THEN
          NPPLT = 0
          CALL TVNEXT
          CALL TVRNG(.FALSE.,0.0,0.0,SIZEU(1),SIZEU(2))
      ENDIF
C
C     INCREMENT PLOT NUMBERS
C
      NPPLT = NPPLT + 1
C
C     Create a segment to store the plot in
C
      NSEGM = 100*(NPPLT-1) + 1
      CALL M_CRSG(NSEGM)
C
C     Setup line segment size
C
      xunit = tszeu(5)
C
C     DRAW A BOX ROUND THE WHOLE PLOT
C
      IF(NCLRU.EQ.1 .AND. QSBOX) THEN
          NCOL  = ICOLU(1)
          THICK = ATHKU(1)
          XPT(1) = 0.0
          YPT(1) = 0.0
          XPT(2) = SIZEU(1)
          YPT(2) = 0.0
          XPT(3) = SIZEU(1)
          YPT(3) = SIZEU(2)
          XPT(4) = 0.0
          YPT(4) = SIZEU(2)
          XPT(5) = 0.0
          YPT(5) = 0.0
          CALL MN_LIN(XPT,YPT,5,1,XUNIT,NCOL,THICK)
      ENDIF
C
C     Draw items in cm coordinates that should be drawn first
C
      if(nclru.eq.1) then
        call mn_ldp(0,.true.,12,0,0)
      endif
C
C     CALCULATE THE PLOT SIZE AND POSITION
C
C     PLOT/NOCLEAR with window size/margin specified
C
      IF(NOVEFL.EQ.1 .AND. NCLRU.EQ.0 .and.
     +   WSZEU(1).GT.0.0 .AND. WSZEU(2).GT.0.0) THEN
          XPLO = AMRGU(1) + WMRGU(1)
          XPHI = AMRGU(1) + WMRGU(1) + WSZEU(1)
          YPLO = AMRGU(2) + WMRGU(2)
          YPHI = AMRGU(2) + WMRGU(2) + WSZEU(2)
C
C     Windowing
C
      ELSEIF(QWIND) THEN
          XPLO = AMRGU(1) + WMRGU(1)
          XPHI = AMRGU(1) + WMRGU(1) + WSZEU(1)
          YPLO = AMRGU(2) + WMRGU(2)
          YPHI = AMRGU(2) + WMRGU(2) + WSZEU(2)
C
C     All other cases
C
      ELSE
          XPLO = AMRGU(1)
          XPHI = AMRGU(1) + HSZEU(1)
          YPLO = AMRGU(2)
          YPHI = AMRGU(2) + HSZEU(2)
      ENDIF
C
C     If the symbol is 0, use the default symbol for this plot type
C
      IF(NSYMU.EQ.0) THEN
          IF(QPNTPL) THEN
              IF(NDIMN.EQ.2) THEN
                  NSYMU =  12
              ELSEIF(INTPMN(NSENT+3).LE.0) THEN
                  NSYMU =  -1
              ELSE
                  NSYMU = -32
              ENDIF
          ELSEIF(NDIM.EQ.1 .AND. NWPPT.GT.2) THEN
              NSYMU = -32
          ELSEIF(NDIM.EQ.1) THEN
              NSYMU = 1
          ELSEIF(NDIM.GE.2) THEN
              NSYMU = 12
          ELSEIF(NDIM.EQ.-1 .AND. NWPPT.EQ.2) THEN
              NSYMU = -1
          ELSEIF(NDIM.EQ.-1) THEN
              NSYMU = -32
          ELSE
              NSYMU = 1
          ENDIF
      ENDIF
C
C     DRAW IN TITLE
C
      IF(QTITLU(1)) THEN
          CALL M_PTITL(TITLE)
      ENDIF
C
C     DRAW IN THE PLOT ID AND SYMBOL NUMBER
C
      SIZE  = TSZEU(3)
      NFONT = IFNTU(1)
      NCOL  = ICOLU(5)
      THICK = ATHKU(5)
      IF(NSID.GT.0) THEN
          XX0   = AMRGU(1)
          YY0   = SIZEU(2)
          CALL M_HEAD(NPPLT,XX0,YY0,SIZE,NFONT,NCOL,THICK,TFILE,IDA,IDB
     +     ,NDIM,NSYMU,NHDATE,NHTIME,EDENT,AMEAN,ASIG,ACONT,NLEG,NSID)
      ENDIF
*
*     Put in the footer
*
      if(nsfoot.gt.0) then
          size = tszeu(9)
          call m_foot(npplt,size,nfont,ncol,thick)
      endif
C
C     Detector displays get done here
C
      IF(NLEG.EQ.11) THEN
          CALL MN_DPL(IDA,IDB,NDIM,NWPPT,NPNT,EDLO,EDHI
     +     ,IDBIN,ADLO,ADHI,RBUF,IERR)
C
C         Update the used limits as MN_DPL sets them
C
          ALIMU(1,1) = XLO
          ALIMU(2,1) = XHI
          ALIMU(1,2) = YLO
          ALIMU(2,2) = YHI
          IF(NSENT.GT.2) THEN
              ALIMU(1,3) = ZLO
              ALIMU(2,3) = ZHI
          ENDIF
C
C         Draw items in plot coordinates
C         Have to draw first and last, as detector is drawn already
C
          call mn_ldp(0,.true.,02,ida,idb)
          call mn_ldp(0,.true.,01,ida,idb)
C
C         Store the limits in registers
C
          REGIS(201) = XPLO
          REGIS(202) = XPHI
          REGIS(203) = YPLO
          REGIS(204) = YPHI
          REGIS(205) = XLO
          REGIS(206) = XHI
          REGIS(207) = YLO
          REGIS(208) = YHI
          IF(NSENT.GT.2) THEN
              REGIS(209) = ZLO
              REGIS(210) = ZHI
          ENDIF
C
          GOTO 9000
      ENDIF
C
C     If overlay on same scale then only plot the points
C     For an overlay on a different scale only do limits for the
C     number of entries axis
C
      IF(NOVEFL.EQ.2) GOTO 5000
      IF(NOVEFL.EQ.3) THEN
        NAX1 = NSENT
        NAX2 = NSENT
        ALIMU(1,1) = XLO
        ALIMU(2,1) = XHI
        IF(IABS(NDIM).GT.1) THEN
          ALIMU(1,2) = YLO
          ALIMU(2,2) = YHI
        ENDIF
      ELSE
*
*       If background colour is set draw a box in the background colour
*       Do not do it for lego plots etc.
*
        if(icolu(mcol_bgd).gt.0) then
          if(nleg.ne.1 .and. nleg.ne.2 .and.
     +       (nleg.lt.7 .or. nleg.gt.9)) then
            XPT(1) = xplo
            YPT(1) = yplo
            XPT(2) = xphi
            YPT(2) = yplo
            XPT(3) = xphi
            YPT(3) = yphi
            XPT(4) = xplo
            YPT(4) = yphi
            XPT(5) = xplo
            YPT(5) = yplo
            CALL tvshad(2,xpt,ypt,5,100,icolu(mcol_bgd))
          endif
        endif
*
        NAX1 = 1
        NAX2 = NSENT
*
*       Scale factor and offset to apply to the points if this is time
*       mode

        qtime = .false.
        do nax=nax1,nax2
          scale  = 1.0
          offset = 0.0
*
*         Calculate offset to the scale if plotting in date or time mode
*         If the plot is not in time mode then assume it is OK.
*
          if(ismodu(nax).eq.3) then
            call m_pkts(nsdate,nstime,ntdb)
            if(ntmode.eq.4) then
              scale  = 1.0 / float(24*60*60)
              offset = am_tdif(0,ntdb,'S')
            elseif(ntmode.eq.3) then
              scale  = 1.0 / float(24*60)
              offset = am_tdif(0,ntdb,'M')
            elseif(ntmode.eq.2) then
              scale  = 1.0 / float(24)
              offset = am_tdif(0,ntdb,'H')
            elseif(ntmode.eq.1) then
              scale  = 1.0
              offset = am_tdif(0,ntdb,'D')
            endif
          elseif(ismodu(nax).eq.4) then
            call m_pkts(nsdate,nstime,ntdb)
            if(ntmode.eq.4) then
              scale  = 1.0 / float(60*60)
              offset = am_tdif(0,ntdb,'S')
            elseif(ntmode.eq.3) then
              scale  = 1.0 / float(60)
              offset = am_tdif(0,ntdb,'M')
            elseif(ntmode.eq.2) then
              scale  = 1.0
              offset = am_tdif(0,ntdb,'H')
            elseif(ntmode.eq.1) then
              scale  = 24.0
              offset = am_tdif(0,ntdb,'D')
            endif
          endif
          if(scale.ne.1.0 .or. offset.ne.0.0) qtime = .true.
          tscl(nax) = scale
          toff(nax) = offset
        enddo
      ENDIF
C
C     SET THE LIMITS ON THE SCALES
C
      DO 2500 NAX=NAX1,NAX2
          IF(QPNTPL) THEN
              NXN = INTPMN(NAX)
          ELSE
              NXN = NAX
          ENDIF
C
          BLO = ALIMU(1,NAX)
          BHI = ALIMU(2,NAX)
          IF(.NOT.QPNTPL .AND. NAX.EQ.NSENT) THEN
              BDLO = EDLO
              BDHI = EDHI
          ELSE
              BDLO = tscl(nax) * (ADLO(NXN) + toff(nax))
              BDHI = tscl(nax) * (ADHI(NXN) + toff(nax))
          ENDIF
C
C         Set artificial scale if we have 0 entries
C
          IF(NAX.EQ.NSENT .AND.
     +       BLO.EQ.0.0   .AND. BHI.EQ.0.0  .AND.
     +       ((BDLO.EQ.0.0 .AND. BDHI.EQ.0.0) .OR.
     +        BDLO.GT.BDHI)) THEN
*ICB     +       BDLO.GE.BDHI .AND. BDLO.EQ.0.0) THEN
CICB     +       BDLO.EQ.0.0 .AND. BDHI.EQ.0.0) THEN
              IF(ISMODU(NAX).EQ.2) THEN
                  BLO = 0.1
              ELSE
                  BLO = 0.0
              ENDIF
              BHI = 1.0
C
C         Normal scale calculation for the number of entries
C
          ELSEIF(BLO.EQ.0.0 .AND. BHI.EQ.0.0) THEN
              BLO = BDLO
              BHI = BDHI
C
C             For number of entries calculate sensible limits
C
              IF(NAX.EQ.NSENT) THEN
                  DO 2100 IYY=1,2
                      IF(IYY.EQ.1) THEN
                          EEV = ABS(BLO)
                          IF(QSCALU(10,NAX) .AND. ISMODU(NAX).NE.2 .AND.
     +                       NAX.EQ.NSENT .AND. BLO.GE.0.0) THEN
                              BLO = 0.0
                              GOTO 2100
                          ELSEIF(BLO.EQ.0.0) THEN
                              GOTO 2100
                          ENDIF
                      ELSE
                          EEV = ABS(BHI)
                          IF(QSCALU(10,NAX) .AND. ISMODU(NAX).NE.2 .AND.
     +                       NAX.EQ.NSENT .AND. BHI.LE.0.0) THEN
                              BHI = 0.0
                              GOTO 2100
                          ELSEIF(BHI.EQ.0.0) THEN
                              GOTO 2100
                          ENDIF
                      ENDIF
                      IF(NAX.LE.2 .AND. NAX.EQ.NSENT) THEN
                          IF((BLO.GT.0.0 .AND. IYY.EQ.1) .OR.
     +                       (BHI.LT.0.0 .AND. IYY.EQ.2)) THEN
                              EEV = 0.95 * EEV
                          ELSE
                              EEV = 1.05 * EEV
                          ENDIF
                      ENDIF
                      NP10 = 1
                      IF(EEV.NE.0.0) NP10 = IFIX(ALOG10(ABS(EEV)))
                      IF(ABS(EEV).LT.1.0) NP10 = NP10 - 1
                      EEM = ABS(EEV) * 10.0**(1-NP10)
                      IF((BLO.GE.0.0 .AND. IYY.EQ.1) .OR.
     +                   (BHI.LE.0.0 .AND. IYY.EQ.2)) THEN
                          NG1 = NGSCAL
                          NG2 = 1
                          NGSTEP = -1
                      ELSE
                          NG1 = 2
                          NG2 = NGSCAL
                          NGSTEP = +1
                      ENDIF
                      DO 2020 NN=NG1,NG2,NGSTEP
                          IF((NGSTEP.GT.0 .AND.
     +                        (EEM-YGSCAL(NN)).LT.0.1) .OR.
     +                       (NGSTEP.LT.0 .AND.
     +                        (YGSCAL(NN)-EEM).LT.0.1)) THEN
                              IF(NAX.LE.2) THEN
                                  IF(ISMODU(NAX).EQ.1 .AND.
     1                             EEV.LT.9.9 .AND.
     1                             MOD(IGSCAL(NN),10).NE.0)
     2                             GOTO 2020
                              ENDIF
                              EET = YGSCAL(NN)
                              GOTO 2040
                          ENDIF
 2020                 CONTINUE
                      EET = EEM
 2040                 CONTINUE
                      EEV = EET * 10.0**(NP10-1)
                      IF(IYY.EQ.1) THEN
                          BLO = SIGN(EEV,BLO)
                      ELSE
                          BHI = SIGN(EEV,BHI)
                      ENDIF
 2100             CONTINUE
C
C                 If this is a 2-D histogram and the symbol number is >10
C                 then set the lower limit to 0 and the upper limit to the
C                 maximum of the limits. Then we will get filled areas for
C                 positive weights and open for negative
C
                  IF(NDIM.EQ.2 .AND. NAX.EQ.NSENT .AND.
     +               IABS(NSYMU).GT.10 .AND.
     +               BLO.LT.0.0 .AND.BHI.GT.0.0) THEN
                      BHI = AMAX1(ABS(BLO),BHI)
                      BLO = 0.0
                  ENDIF
              ENDIF
C
C             For a log scale set the upper limit the next order of magnitude up
C             Set the lower limit the next order of magnitude down, unless the
C             lower limit is <= 0. Then set it 3 orders of magnitude down.
C
              IF(ISMODU(NAX).EQ.2) THEN
                  NMAG = IFIX(ALOG10(0.99*BHI)) + 1
                  BHI  = 10.0**NMAG
                  IF(BLO.GT.0.0) THEN
                      NMAG = IFIX(ALOG10(0.99*BLO))
                      BLO = 10.0**NMAG
                  ELSE
                      BLO = 10.0**(NMAG-3)
                  ENDIF
              ENDIF
          ENDIF
C
C         NOW STORE LIMITS WHERE THEY SHOULD BE
C
          IF(NAX.EQ.1) THEN
              XLO = BLO
              XHI = BHI
          ELSE IF(NAX.EQ.2) THEN
              YLO = BLO
              YHI = BHI
          ELSE IF(NAX.EQ.3) THEN
              ZLO = BLO
              ZHI = BHI
              if(ismodu(3).eq.2 .and. zlo.gt.0.0) then
                  zllo= 10.0**int(alog10(zlo))
              else
                  zllo= zlo
              endif
          ENDIF
          ALIMU(1,NAX) = BLO
          ALIMU(2,NAX) = BHI
 2500 CONTINUE
C
C     Y AXIS IS NUMBER OF ENTRIES FOR A 1 DIMENSIONAL HISTOGRAM
C     OTHERWISE IT IS THE Z AXIS
C
      IF(IABS(NDIMN).EQ.1) THEN
          ELO = YLO
          EHI = YHI
      ELSE
          ELO = ZLO
          EHI = ZHI
      ENDIF
*
*     See if the symbol size should be log scale
*
      qzlog = nax2.gt.2 .and. ismodu(3).eq.2
*
*     Apply scale and offset to default limits for lego and surface plots
*
      if(nleg.eq.1 .or. nleg.eq.2 .or.
     +   (nleg.ge.7 .and. nleg.le.9)) then
          do nax=nax1,nax2
              aulo(nax) = tscl(nax) * (adlo(nax) + toff(nax))
              auhi(nax) = tscl(nax) * (adhi(nax) + toff(nax))
          enddo
      endif
C
C     Draw items in plot coordinates that should be drawn first
C
      call mn_ldp(0,.true.,02,ida,idb)
C
C     MAKE A LEGO OR SURFACE PLOT HERE
C
      IF(NLEG.EQ.1 .OR. NLEG.EQ.2) THEN
          CALL MN_LEG(NLEG,IDA,IDB,RBUF,NWPPT,NDIM,IDBIN,AULO,AUHI
     1     ,ELO,EHI)
C
C         Update the used limits as MN_LEG may change them a bit!
C
          ALIMU(1,1) = XLO
          ALIMU(2,1) = XHI
          ALIMU(1,2) = YLO
          ALIMU(2,2) = YHI
C
C     Draw a table using IGTABL
C
      ELSEIF(NLEG.GE.7 .AND. NLEG.LE.9) THEN
          CALL M_IGTABL(NLEG,IDA,IDB,RBUF,NWPPT,NDIM,IDBIN,AULO,AUHI
     +     ,SCLIGT,IERR)
          if(ierr.ne.0) then
            ierr = 7
            return
          endif
      ENDIF
C
C     Store the limits in registers
C
      REGIS(201) = XPLO
      REGIS(202) = XPHI
      REGIS(203) = YPLO
      REGIS(204) = YPHI
      REGIS(205) = XLO
      REGIS(206) = XHI
      REGIS(207) = YLO
      REGIS(208) = YHI
      IF(NSENT.GT.2) THEN
          REGIS(209) = ZLO
          REGIS(210) = ZHI
      ENDIF
C
C     Skip the point drawing for lego, surface and igtable plots
C
      IF(NLEG.EQ.9) THEN
          GOTO 9000
      ELSEIF(NLEG.EQ.1 .OR. NLEG.EQ.2 .OR.
     +       NLEG.EQ.7 .OR. NLEG.EQ.8) THEN
          GOTO 7000
      ENDIF
C
C     NOW DRAW IN THE POINTS
C
 5000 CONTINUE
      NsCOL = ICOLU(7)
      NhCOL = ICOLU(8)
      NpCOL = ICOLU(9)
      THICK = ATHKU(7)
      NFONT = IFNTU(4)
      IF(NDIM.LT.0) THEN
          IF(NPNT.GT.0) THEN
              IF(NLEG.EQ.-1) THEN
                  CALL M_PSMOO(RBUF,NDIMN,NWPPT,NPNT,NDIM
     +             ,RBUG,NWPPO,NPT)
                  CALL MN_PLP(RBUG,NDIMN,NWPPO,NPT,NDIMN
     +             ,NSYMU,NHATU,NPATU,NsCOL,nhcol,npcol,THICK,NFONT
     +             ,qtime,tscl,toff,qzlog)
              ELSE
                  CALL MN_PLP(RBUF,NDIMN,NWPPT,NPNT,NDIM
     +             ,NSYMU,NHATU,NPATU,NsCOL,nhcol,npcol,THICK,NFONT
     +             ,qtime,tscl,toff,qzlog)
              ENDIF
          ENDIF
C
C     BINNED PLOT
C
      ELSE
          QERRL = .FALSE.
          QERRH = .FALSE.
          IF(NLEG.EQ.-1) THEN
              NWPPO = (NDIM+1)
          ELSEIF(NWPPT.EQ.1) THEN
              IF(NDIM.EQ.1 .AND. NSYMU.GE.0 .AND. NSYMU.LT.10) THEN
                  NWPPO = 2*(NDIM+1)
                  QERRL = .TRUE.
              ELSE IF(NDIM.EQ.2) THEN
                  NWPPO = 2*(NDIM+1)
                  QERRL = .TRUE.
              ELSE
                  NWPPO = (NDIM+1)
                  QERRL = .FALSE.
              ENDIF
          ELSE IF(NWPPT.EQ.2) THEN
              NWPPO = 2*(NDIM+1)
              QERRL = .TRUE.
          ELSEIF(NWPPT.EQ.3 .OR. NWPPT.EQ.4) THEN
              NWPPO = 3*(NDIM+1)
              QERRL = .TRUE.
              QERRH = .TRUE.
          ENDIF
          NOFF  = 1*(NDIM+1)
          NOFFL = 2*(NDIM+1)
          NOFFH = 3*(NDIM+1)
          NDBX = IDBIN(1)
          NDBY = 1
          DX   = (ADHI(1)-ADLO(1)) / FLOAT(IDBIN(1))
          IF(NDIM.GT.1) THEN
              NDBY = IDBIN(2)
              DY = (ADHI(2)-ADLO(2)) / FLOAT(IDBIN(2))
          ENDIF
          NLOOP = ((NDBX-1) / MPNTMX) + 1
          DO 6500 NL=1,NLOOP
              NX1 = (NL-1)*MPNTMX + 1
              NX2 = MIN0(NDBX,NL*MPNTMX)
              NPT = NX2 - NX1 + 1
              DO 6000 NX=NX1,NX2
                  NPTR = NWPPO*(NX-NX1)
                  RBUG(NPTR + 1) = ADLO(1) + 0.5*DX + FLOAT(NX-1)*DX
                  IF(QERRL) RBUG(NPTR + NOFF  + 1) = 0.5*DX
                  IF(QERRH) RBUG(NPTR + NOFFL + 1) = 0.5*DX
 6000         CONTINUE
              DO 6100 NY=1,NDBY
                  IF(NDIM.GT.1) THEN
                      Y = ADLO(2) + 0.5*DY + FLOAT(NY-1)*DY
                  ENDIF
                  DO 6050 NX=NX1,NX2
                      NPTR1 = NWPPT * (NDBX*(NY-1) + NX - 1)
                      NPTR  = NWPPO*(NX-NX1)
                      IF(NDIM.GT.1) THEN
                          RBUG(NPTR + 2) = Y
                          IF(QERRL) RBUG(NPTR + NOFF  + 2) = 0.5*DY
                          IF(QERRH) RBUG(NPTR + NOFFL + 2) = 0.5*DY
                      ENDIF
                      RBUG(NPTR+NOFF) = RBUF(NPTR1 + 1)
                      IF(QERRL) THEN
                          IF(NWPPT.EQ.1) THEN
                              RBUG(NPTR+NOFFL) = 0.0
                          ELSE
                              RBUG(NPTR+NOFFL) = RBUF(NPTR1 + 2)
                          ENDIF
                      ENDIF
                      IF(QERRH) RBUG(NPTR+NOFFH) = RBUF(NPTR1 + 3)
6050              CONTINUE
                  IF(NLEG.EQ.-1) THEN
                      CALL M_PSMOO(RBUG,NDIMN,NWPPO,NPT,NDIM
     +                 ,RBUG,NWPPO,NPT)
                      CALL MN_PLP(RBUG,NDIMN,NWPPO,NPT,NDIM
     +                 ,NSYMU,NHATU,NPATU,NsCOL,nhcol,npcol,THICK,NFONT
     +                 ,qtime,tscl,toff,qzlog)
                  ELSE
                      CALL MN_PLP(RBUG,NDIMN,NWPPO,NPT,NDIM
     +                 ,NSYMU,NHATU,NPATU,NsCOL,nhcol,npcol,THICK,NFONT
     +                 ,qtime,tscl,toff,qzlog)
                  ENDIF
6100          CONTINUE
6500      CONTINUE
      ENDIF
7000  CONTINUE
C
C     SET SOME USEFUL SIZES
C
      NCTOPT = 1
      NAX2   = 2
      IF(NLEG.EQ.1 .OR. NLEG.EQ.2) THEN
          NCTOPT = 2
          NAX2   = 3
      ELSEIF(NLEG.EQ.8) THEN
          NCTOPT = 3
          NAX2   = 3
      ENDIF
C
C     IF OVERLAY ON SAME SCALE THEN EXIT HERE
C     Need to set NCTOPT correctly first
C
      IF(NOVEFL.EQ.2) GOTO 8000
C
C     DRAW IN LINE AT X=0
C
      IF(NLEG.LE.0) THEN
          NCOL  = ICOLU(10)
          THICK = ATHKU(8)
          IF(IABS(NDIM).EQ.2 .AND. QZEROU(1)) THEN
              IF(XLO.LT.0.0 .AND. XHI.GT.0.0) THEN
                  NSYM  = IABS(IZEROU(1))
                  XPT(1) = 0.0
                  YPT(1) = YLO
                  XPT(2) = 0.0
                  YPT(2) = YHI
                  CALL MN_CTR(XPT,YPT,XXPT,YYPT,2,NCTOPT)
                  CALL MN_LIN(XXPT,YYPT,2,NSYM,XUNIT,NCOL,THICK)
              ENDIF
          ENDIF
C
C         DRAW IN LINE AT Y=0
C
          IF(QZEROU(2)) THEN
              IF(YLO.LT.0.0 .AND. YHI.GT.0.0) THEN
                  NSYM = IABS(IZEROU(2))
                  XPT(1) = XLO
                  YPT(1) = 0.0
                  XPT(2) = XHI
                  YPT(2) = 0.0
                  CALL MN_CTR(XPT,YPT,XXPT,YYPT,2,NCTOPT)
                  CALL MN_LIN(XXPT,YYPT,2,NSYM,XUNIT,NCOL,THICK)
              ENDIF
          ENDIF
      ENDIF
C
C     DECIDE ON THE NUMBER OF TICKS, SCALE AND AXIS LABEL FOR EACH AXIS
C
      DO 4000 NAX=1,NAX2
C
          NSMODE = ISMODU(NAX)
          NAXW = NAX
          IF(NAX.GT.2) NAXW = 2
C
          IF(NAX.EQ.1) THEN
              ALO =  XLO
              AHI =  XHI
              ADIF = XHI - XLO
          ELSEIF(NAX.EQ.2) THEN
              ALO =  YLO
              AHI =  YHI
              ADIF = YHI - YLO
          ELSE
              ALO =  ZLO
              AHI =  ZHI
              ADIF = ZHI - ZLO
          ENDIF
C
C         TICK LIMITS
C
          ATLO = TICKU(6,NAX)
          ATHI = TICKU(7,NAX)
C
C         If allowing pi scale then set tick limits to plot limits,
C         except for number of entries axis.
C         Do not do pi labelling on number of entries axis??
C
          QPIP = .FALSE.
          IF(QPIPLT .AND. NAX.NE.NSENT) THEN
              QPIP = QPIPLT
              ATLO = ALO
              ATHI = AHI
          ENDIF
C
C         CALCULATE THE NUMBER OF TICKS
C
          NTICS = NINT(TICKU(1,NAX))
          NBTIC = NINT(TICKU(2,NAX))
          NOTIC = NINT(TICKU(3,NAX))
C
C         Set the number of ticks
C
          CALL M_PTICK(NDIM,NAX,NSMODE,ALO,AHI,ADIF,QLIMCU(NAX)
     +     ,IDBIN(NAX),ADLO(NAX),ADHI(NAX)
     +     ,QWIND,IWIND(NAXW),WSPACE(NAXW),ALIMU(1,NAX),QPIPLT
     +     ,ATLO,ATHI,NTICS,NBTIC,NOTIC)
C
C         STORE THE NUMBER OF TICKS AND THE LIMITS
C
          TICKU(1,NAX) = FLOAT(NTICS)
          TICKU(2,NAX) = FLOAT(NBTIC)
          TICKU(3,NAX) = FLOAT(NOTIC)
          TICKU(6,NAX) = ATLO
          TICKU(7,NAX) = ATHI
          IF(NBTIC.LT.1) NBTIC = 1
C
C         NOW CALCULATE THE NUMBER OF DIGITS AND THE NUMBER OF DECIMAL
C         PLACES FOR THE SCALE
C         CHANGE THE SCALE MODE TO REAL IF THE DIFFERENCE IS TOO SMALL
C
          NADIFB = NINT(ATHI-ATLO) * NBTIC / NTICS
          IF(NSMODE.EQ.1 .AND. NADIFB.LT.1) NSMODE = 0
C
          NTICS = NTICS + 1
          IF(NTICS.LE.1) NTICS = 2
C
          NDIGI = NINT(SCALU(5,NAX))
          NDECI = NINT(SCALU(6,NAX))
          AFACT = SCALU(7,NAX)
          IF(AFACT.EQ.0.0) AFACT = 1.0
C
          NPOWER = 0
          ATDIF = ATHI - ATLO
          ATFRC = ATDIF / FLOAT(NTICS-1)
C
C         CALCULATE LOWER LIMIT FOR TICKS ON LOG SCALE
C
          IF(NSMODE.EQ.2) THEN
              NP10 = IFIX(ALOG10(1.01*ATLO)) + 1
              IF(ATLO.LT.1.0) NP10 = NP10 - 1
              NP11 = NP10
              NTLO = IFIX(ATLO*10.0**(1-NP10)-0.01)
              IF(ATLO.GT.0.0) NTLO = NTLO + 1
C
C         CALCULATE NUMBER OF DECIMAL PLACES FOR NORMAL SCALE
C
          ELSEIF(QLIMCU(NAX) .OR. NDECI.LT.0) THEN
              ATSDIF = ATDIF * AFACT
              IF(ATSDIF.LE.1.0E-02) THEN
                  NDECI = 4
              ELSEIF(ATSDIF.LE.1.0E-01) THEN
                  NDECI = 3
              ELSEIF(ATSDIF.LE.1.0E-00) THEN
                  NDECI = 2
              ELSEIF(ATSDIF.LE.100.0) THEN
                  NDECI = 1
              ELSE
                  NDECI = 0
              ENDIF
C
C             CHECK IF NUMBER OF DECIMAL PLACES IS OK
C
              AAL = AFACT * ATLO * 10**(NDECI+1)
              NAAL = NINT(AAL)
              AAH = AFACT * ATHI * 10**(NDECI+1)
              NAAH = NINT(AAH)
              IF(MOD(NAAL,10).NE.0 .OR. MOD(NAAH,10).NE.0)
     1         NDECI = NDECI+1
          ENDIF
C
          ISMODU(NAX)  = NSMODE
          SCALU(6,NAX) = FLOAT(NDECI)
C
C         LOOP OVER BOTTOM AND TOP OR LEFT AND RIGHT AXES AND DRAW
C         IN TICKS, GRID, SCALE AND AXIS LABELS
C
          DO 3500 JTB=1,2
C
C             For lego plots that are rotated by more than 90 degrees
C             decide which axes to put the ticks and scale on.
C
              ITB = JTB
              if(nleg.eq.1 .or. nleg.eq.2 .or. nleg.eq.8) then
                  if(abs(alegu(1)).ne.90.0) then
                      call m_tbleg(jtb,nax,alegu(2),itb)
                  endif
              endif
C
              N1 = 2*(JTB-1) + 1
              N2 = 2*JTB
              QFRAM = QFRAMU(JTB,NAX)
              QTICK = QTICKU(N1,NAX) .OR. QTICKU(N2,NAX)
              QINS  = QTICKU(N1,NAX)
              QOUT  = QTICKU(N2,NAX)
              QSCAL = QSCALU(JTB,NAX)
              QLABL = QLABLU(JTB,NAX)
              QLPAG = QLABLU(3,NAX)
              QGRID = IGRIDU(1,NAX).NE.0
              ioptl(nax) = nint(alablu(5,nax))
C
C             FRAME FLAG OVERRIDES EVERYTHING ELSE
C
              IF(.NOT.QFRAM) GOTO 3500
C
C             DON'T DRAW TICKS OR SCALE FOR TOP OR RIGHT ON LEGO PLOTS
C             unless abs(theta) = 90 degrees
C             Flip arguments for tick drawing
C             CANNOT PUT ON A GRID FOR THE X AND Y AXES
C             IGTABL puts on grid, so I don't need to
C             Do not draw the z scale on a lego or surface plot for
C             abs(theta) = 90 degress as the numbers sit on top of each other
C
              if(nleg.eq.1 .or. nleg.eq.2 .or. nleg.eq.8) then
                  if(nax.le.2 .and. jtb.eq.2 .and.
     +               abs(alegu(1)).ne.90.0) goto 3500
                  if(nax.eq.3 .and. abs(alegu(1)).eq.90.0) goto 3500
                  if(abs(alegu(1)).ne.90.0) then
                      qtmp = qins
                      qins = qout
                      qout = qtmp
                  endif
                  if(nax.le.2) qgrid = .false.
                  if(nleg.eq.8) qgrid = .false.
              endif
*
*             Setup all positions and scale factors
*
              call m_tbpos(nax,jtb,itb,nsmode,nleg,alegu(1),alegu(2)
     +         ,scligt,qins,qout,ioptl(nax),xlo,xhi,ylo,yhi,zlo,zhi
     +         ,xl,yl,zl,xt,yt,xu,yu,xv,yv,ads,ada,adi,ado,qlflip,angx)
C
              IF(QTICK .OR. QGRID) THEN
C
C                 SET UP STARTING PARAMETERS FOR LOG SCALE
C
                  IF(NSMODE.EQ.2) THEN
                      NN = NTLO - 1
                      NP10 = NP11
                  ENDIF
C
                  NCOL  = ICOLU(2)
                  THICK = ATHKU(2)
                  ANGLE = DRAD * TSZEU(8)
                  CANG  = COS(ANGLE)
                  SANG  = SIN(ANGLE)
                  rphi  = amod(alegu(2),90.0)
                  if(rphi.lt.0.0) rphi = rphi + 90.0
                  CANGL = COS(drad * rphi)
                  SANGL = SIN(drad * rphi)
C
                  DO 3200 ITIC=1,NTICS
                    IF(NSMODE.EQ.2) THEN
                      NN = NN + 1
                      IF(NN.GE.10) THEN
                        NN   = 1
                        NP10 = NP10 + 1
                      ENDIF
                      ANUMB  = FLOAT(NN) * 10.0**(NP10-1)
                      AFNUMB = ANUMB
                    ELSE
                      ANUMB  = ATLO + FLOAT(ITIC-1)*ATFRC
                      AFNUMB = AFACT * ANUMB
                    ENDIF
C
                    IF(AHI.EQ.0.0) THEN
                      DEL = ANUMB - AHI
                    ELSE
                      DEL = (ANUMB - AHI) / ABS(AHI)
                    ENDIF
                    IF(DEL.GT.0.01) GOTO 3200
C
                    QBIG = MOD(ITIC-1-NOTIC,NBTIC).EQ.0
                    IF(ITIC.LT.NOTIC) QBIG = .FALSE.
C
C                   Draw in the tick
C
                    IF(QTICK) THEN
                      IF(QBIG) THEN
                        SIZET = TICKU(5,NAX)
                      ELSE
                        SIZET = TICKU(4,NAX)
                      ENDIF
C
C                     IGTABL lego and surface plots are mapped onto -1,1
C
                      IF(NLEG.EQ.8) THEN
                        SIZET = SIZET * SCLIGT
                      ENDIF
C
                      IF(NAX.EQ.1) THEN
                        CALL MN_CTR(ANUMB,YT,XXT,YYT,1,NCTOPT)
                        XPT(1) = XXT + ADI*SIZET*SANG
                        XPT(2) = XXT + ADO*SIZET*SANG
                        YPT(1) = YYT + ADI*SIZET*CANG
                        YPT(2) = YYT + ADO*SIZET*CANG
                      ELSEIF(NAX.EQ.2) THEN
                        CALL MN_CTR(XT,ANUMB,XXT,YYT,1,NCTOPT)
                        IF((NLEG.EQ.1 .OR. NLEG.EQ.2 .OR.
     +                   NLEG.EQ.8) .AND.
     +                   ABS(ALEGU(1)).NE.90.0)THEN
                          XPT(1) = XXT
                          XPT(2) = XXT
                          YPT(1) = YYT + ADI*SIZET
                          YPT(2) = YYT + ADO*SIZET
                        ELSE
                          XPT(1) = XXT + ADI*SIZET*CANG
                          XPT(2) = XXT + ADO*SIZET*CANG
                          YPT(1) = YYT + ADI*SIZET*SANG
                          YPT(2) = YYT + ADO*SIZET*SANG
                        ENDIF
                      ELSE
                        CALL M_CXYZ(XT,YT,ANUMB,XXT,YYT,1,-NCTOPT)
                        XPT(1) = XXT + ADI*SIZET
                        XPT(2) = XXT + ADO*SIZET
                        YPT(1) = YYT
                        YPT(2) = YYT
                      ENDIF
C
                      IF(NAX.LT.3 .OR. YYT.LE.YPHI)
     +                 CALL MN_LIN(XPT,YPT,2,1,XUNIT,NCOL,THICK)
                    ENDIF
C
C                   Draw in the grid only if it is a big tick
C                   and if we are doing the first axis
C
                    IF(QGRID .AND. ITB.EQ.1 .AND.
     +               (QBIG .OR. IGRIDU(2,NAX).GT.1)) THEN
                      NSYM = IABS(IGRIDU(1,NAX))
                      IF(NAX.EQ.1) THEN
                        NPT = 2
                        CALL MN_CTR(ANUMB,YT,XXG,YYG,1,NCTOPT)
                        XPT(1) = XXG
                        YPT(1) = YYG
                        CALL MN_CTR(ANUMB,YU,XXG,YYG,1,NCTOPT)
                        XPT(2) = XXG
                        YPT(2) = YYG
                        CALL MN_LIN(XPT,YPT,NPT,NSYM,XUNIT,NCOL
     +                   ,THICK)
                      ELSEIF(NAX.EQ.2) THEN
                        NPT = 2
                        CALL MN_CTR(XT,ANUMB,XXG,YYG,1,NCTOPT)
                        XPT(1) = XXG
                        YPT(1) = YYG
                        CALL MN_CTR(XU,ANUMB,XXG,YYG,1,NCTOPT)
                        XPT(1) = XXG
                        YPT(1) = YYG
                        CALL MN_LIN(XPT,YPT,NPT,NSYM,XUNIT,NCOL
     +                   ,THICK)
C
C                       For the z axis grid must check that the grid does
C                       not go over the top of the plot
C
                      ELSE
                        NPT = 2
                        CALL M_CXYZ(XT,YT,ANUMB,XXG,YYG,1,-NCTOPT)
                        XPT(1) = XXG
                        YPT(1) = YYG
                        CALL M_CXYZ(XU,YU,ANUMB,XXG,YYG,1,-NCTOPT)
                        XPT(2) = XXG
                        YPT(2) = YYG
                        CALL M_PCHK(XPT,YPT,NPT
     +                   ,XPLO,XPHI,YPLO,YPHI)
                        IF(NPT.GT.1) CALL MN_HID(1,XPT,YPT,NPT
     +                   ,NSYM,XUNIT,NCOL,THICK)
C
                        NPT = 2
                        XPT(1) = XXG
                        YPT(1) = YYG
                        CALL M_CXYZ(XV,YV,ANUMB,XXG,YYG,1,-NCTOPT)
                        XPT(2) = XXG
                        YPT(2) = YYG
                        CALL M_PCHK(XPT,YPT,NPT
     +                   ,XPLO,XPHI,YPLO,YPHI)
                        IF(NPT.GT.1) CALL MN_HID(1,XPT,YPT,NPT
     +                   ,NSYM,XUNIT,NCOL,THICK)
                      ENDIF
                    ENDIF
C
C                   ONLY WRITE NUMBER IF SCALE IS TURNED ON OR
C                   IF DOING A BIG TICK
*
*                   Unless qatrim is false
*                   don't write the number if it is the last tick
*                   and the relevant window spacing is zero
*                   and it is not a lego plot
*
*                   Lego plot scale moved a bit. Do not drop first point
*                   anymore 24.09.97
*                   for lego plots don't write the first number for
*                   the y axis if the theta angle is not 90 degrees
*                   as it overlaps with the x axis number
*
                    IF((NAX.LT.3 .OR. YYT.LE.YPHI) .AND.
     +               QTICK .AND. QSCAL .AND. QBIG) THEN
                      IF(qatrim .and.
     +                 (NLEG.LE.0 .OR. NLEG.EQ.7) .AND.
     +                 QWIND .AND. ITIC.EQ.NTICS .AND.
     +                 (nax.eq.1 .or. nax.eq.2)) then
                        if(WSPACE(NAX).EQ.0.0 .AND.
     +                   ((NAX.EQ.1.AND.IPWNDU(NAX).LT.IWIND(NAX)) .OR.
     +                    (NAX.EQ.2.AND.IPWNDU(NAX).GT.1)))
     +                   GOTO 3180
                      endif
                      NMODE = NSMODE
                      IF(NSMODE.EQ.1) THEN
                        IF(ABS(AFNUMB - FLOAT(NINT(AFNUMB))).GT.
     1                   1.0E-3) NMODE = 0
                      ENDIF
                      CALL MN_NUM(AFNUMB,NMODE,NDIGI,NDECI,NPOWER
     1                 ,QPIP,TNUMB,NCHAR,rnumb)
                      SIZE  = SCALU(3,NAX)
                      ANGLE = SCALU(4,NAX)
                      NFONT = IFNTU(3+2*NAX)
                      NCOL  = ICOLU(3)
                      THICK = ATHKU(3)
C
C                     IGTABL lego and surface plots are mapped onto -1,1
C
                      IF(NLEG.EQ.8) THEN
                        SIZE = SIZE * SCLIGT
                      ENDIF
C
C
                      IF(NLEG.EQ.1 .OR. NLEG.EQ.2 .OR.
     +                 NLEG.EQ.8) THEN
                        IF(NAX.EQ.1) THEN
                          XPL = XXT + ADS*SCALU(1,NAX)
                          if(abs(alegu(1)).eq.90.0) then
                            YPL = YYT + ADS*SCALU(2,NAX) -
     +                       0.5*SIZE
                          else
                            YPL = YYT + ADS*SCALU(2,NAX) -
     +                       1.2*SIZET - 0.8*SIZE
                          endif
                          IF(nmode.eq.0 .and. rnumb.lt.0.0)
     +                     XPL = XPL - 0.7*SIZE
                          NNMOD = 0
*
*                         Flip x and y offsets for lego plots
*                         unless the theta angle is 90 degrees
*
                        ELSEIF(NAX.EQ.2) THEN
                          if(abs(alegu(1)).eq.90.0) then
                            XPL = XXT + ADS*SCALU(1,NAX)
                            YPL = YYT + ADS*SCALU(2,NAX) -
     +                       0.5*SIZE
                            NNMOD = nint(ads)
                          else
                            XPL = XXT + ADS*SCALU(2,NAX)
                            YPL = YYT + ADS*SCALU(1,NAX) -
     +                       1.2*SIZET - 0.5*SIZE
                            NNMOD = 0
                            IF(nmode.eq.0 .and. rnumb.lt.0.0)
     +                       XPL = XPL - 0.7*SIZE
                          endif
                        ELSE
                          XPL = XXT + ADS*SCALU(1,3) - SIZET
                          YPL = YYT + ADS*SCALU(2,3) -
     +                     0.5*SIZE
                          NNMOD = 1
                        ENDIF
                      ELSE
                        XPL = XXT + ADS*SCALU(1,NAX)*CANG +
     +                   ADS*SCALU(2,NAX)*SANG
                        YPL = YYT + ADS*SCALU(1,NAX)*SANG +
     +                   ADS*SCALU(2,NAX)*CANG -
     +                   0.5*SIZE
C
C                       Try to put the number centred under the tick
C                       if it is negative and shown as real
C
                        IF(NAX.EQ.1) THEN
                          IF(NMODE.EQ.0 .AND. rnumb.LT.0.0)
     +                     XPL = XPL-0.7*SIZE
                          NNMOD = 0
                        ELSE
                          NNMOD = NINT(ADS)
                        ENDIF
                      ENDIF
                      CALL MN_TXT(XPL,YPL,TNUMB,SIZE
     +                 ,ANGLE,NNMOD,NFONT,NCOL,THICK)
 3180                 CONTINUE
                    ENDIF
C                   END OF IF(QSCAL...
*
*                   Add the month if plotting date mode and the
*                   month has changed
*
 3                  if(qtick .and. qscal .and. nsmode.eq.3) then
                      call mn_num(afnumb,nsmode,ndigi,ndeci,npower
     1                 ,qpip,tnumb,nchar,rnumb)
                      if(itic.eq.1) then
                        xxt0   = xxt
                        yyt0   = yyt
                        rnumb0 = rnumb
                        anumb0 = anumb
                      elseif(rnumb.lt.rnumbl .or.
     +                   itic.eq.ntics) then
                        if(nax.eq.1) then
                          xx = 0.5 * (xxt0 + xxtl)
                          yy = yytl + ads*scalu(1,nax)*sang +
     +                     ads*scalu(2,nax)*cang -
     +                     2.0*size
                        else
                          xx = xxtl + ads*scalu(1,nax)*cang +
     +                     ads*scalu(2,nax)*sang -
     +                     2.0*size
                          yy = 0.5 * (yyt0 + yytl)
                        endif
                        itsec = nint(anumb0*float(24*60*60))
                        call m_ptis(ndate,ntime,itsec)
                        nmon = mod(ndate,10000) / 100
                        tnumb = tmnth(nmon)
                        call mn_txt(xx,yy,tnumb,size,angle
     +                   ,0,nfont,ncol,thick)
*
                        xxt0   = xxt
                        yyt0   = yyt
                        rnumb0 = rnumb
                        anumb0 = anumb
                      endif
                      rnumbl = rnumb
                      xxtl   = xxt
                      yytl   = yyt
                    endif
 3200             CONTINUE
              ENDIF
C             END OF IF(QTICK .OR. QGRID)
C
C             PRINT AXIS LABEL if there is one per plot
C
              IF(QLABL .AND. .NOT.QLPAG) THEN
                  NCHAR = ILABLU(NAX)
                  TXT1  = TLABLU(NAX)
C
C                 Make an axis label if this is a time plot
*                 Proper time plotting is now available - only do this
*                 is the mode is not date
C
                  IF(NAX.EQ.1 .AND. NTMODE.NE.0 .AND. nsmode.ne.3 .and.
     +               NCHAR.LE.0) THEN
                      WRITE(TXT2,'(I6.6,1X,I6.6)') NSDATE,NSTIME
                      TXT1  = 'Starting time ' // TXT2
                      NCHAR = LNBLNK(TXT1)
C
C                 MAKE AN AXIS LABEL IF WE ARE MULTIPLYING BY A FACTOR
C
                  ELSEIF(AFACT.NE.1.0 .AND. NCHAR.LE.0) THEN
                      TXT1 = 'Scale multiplied by'
                      CALL MN_NUM(AFACT,2,7,-2,0
     +                 ,QPIP,TNUMB,NNCHAR,rnumb)
                      TXT2  = CONCAT(TXT1,TNUMB(1:NNCHAR))
                      TXT1  = TXT2
                      NCHAR = 19 + NNCHAR
                  ENDIF
C
C                 DRAW THE AXIS LABEL
*                 Flip also the x and y label offsets to match the scale
C
                  IF(NCHAR.GT.0) THEN
                      SIZE  = ALABLU(3,NAX)
                      ANGLE = ADA*ALABLU(4,NAX)
C
C                     IGTABL lego and surface plots are mapped onto -1,1
C
                      IF(NLEG.EQ.8) THEN
                          SIZE = SIZE * SCLIGT
                      ENDIF
*
                      IF(NLEG.EQ.1 .OR. NLEG.EQ.2 .OR.
     +                   NLEG.EQ.8) THEN
                          IF(NAX.EQ.1) THEN
                            CALL M_CXYZ(XL,YL,ZLO,XXL,YYL,1
     +                       ,-NCTOPT)
                            if(abs(alegu(1)).eq.90.0) then
                              XX = XXL + ADS*ALABLU(1,1)*CANGL -
     +                                   ADS*ALABLU(2,1)*SANGL
                              YY = YYL + ADS*ALABLU(2,1)*CANGL +
     +                                   ADS*ALABLU(1,1)*SANGL -
     +                         0.5*size
                            else
                              if(qlflip) then
                                XX = XXL + ADS*ALABLU(2,1)*CANGL -
     +                                     ADS*ALABLU(1,1)*SANGL
                                YY = YYL + ADS*ALABLU(1,1)*CANGL +
     +                                     ADS*ALABLU(2,1)*SANGL -
     +                           1.2*sizet - 0.8*size
                              else
                                XX = XXL + ADS*ALABLU(1,1)*CANGL -
     +                                     ADS*ALABLU(2,1)*SANGL
                                YY = YYL + ADS*ALABLU(2,1)*CANGL +
     +                                     ADS*ALABLU(1,1)*SANGL -
     +                           1.2*sizet - 0.8*size
                              endif
                            endif
                            CALL M_CXYZ(XLO,YLO,ZLO,XXL1,YYL1
     +                       ,1,-NCTOPT)
                            CALL M_CXYZ(XHI,YLO,ZLO,XXL2,YYL2
     +                       ,1,-NCTOPT)
                            if(abs(alegu(1)).ne.90.0) then
                              ang = angx
                              IF((XXL2-XXL1).NE.0) THEN
                                ANG = angx +
     +                           ATAN2(YYL2-YYL1,XXL2-XXL1)*RDEG
                                ang = ada*ang
*ICB                                write(6,'('' Theta'',f5.1
*ICB     +                           ,'', Phi'',F5.1
*ICB     +                           ,'', Sign'',F4.1,'', Flip'',L4
*ICB     +                           ,'', Rot'',3F6.1)')
*ICB     +                           alegu(1),alegu(2)
*ICB     +                           ,ada,qlflip,angle,angx,ang
                                ANGLE = ANGLE + ANG
                              ENDIF
                            endif
*
*                         Flip x and y offsets for lego plots
*                         unless the theta angle is 90 degrees
*
                          ELSEIF(NAX.EQ.2) THEN
                            CALL M_CXYZ(XL,YL,ZLO,XXL,YYL,1
     +                       ,-NCTOPT)
                            if(abs(alegu(1)).eq.90.0) then
                              XX = XXL + ADS*ALABLU(1,2)*CANGL -
     +                                   ADS*ALABLU(2,2)*SANGL -
     +                         0.5*SIZE
                              YY = YYL + ADS*ALABLU(2,2)*CANGL +
     +                                   ADS*ALABLU(1,2)*SANGL
                            else
                              if(qlflip) then
                                XX = XXL + ADS*ALABLU(2,2)*CANGL -
     +                                     ADS*ALABLU(1,2)*SANGL
                                YY = YYL + ADS*ALABLU(1,2)*CANGL +
     +                                     ADS*ALABLU(2,2)*SANGL -
     +                           1.2*sizet - 0.5*SIZE
                              else
                                XX = XXL + ADS*ALABLU(1,2)*CANGL -
     +                                     ADS*ALABLU(2,2)*SANGL
                                YY = YYL + ADS*ALABLU(2,2)*CANGL +
     +                                     ADS*ALABLU(1,2)*SANGL -
     +                           1.2*sizet - 0.5*SIZE
                              endif
                            endif
                            CALL M_CXYZ(XLO,YLO,ZLO,XXL1,YYL1
     +                       ,1,-NCTOPT)
                            CALL M_CXYZ(XLO,YHI,ZLO,XXL2,YYL2
     +                       ,1,-NCTOPT)
                            if(abs(alegu(1)).ne.90.0) then
                              ANG = angx
                              IF((XXL2-XXL1).NE.0) THEN
                                ANG = ANG +
     +                           ATAN2(YYL2-YYL1,XXL2-XXL1)*RDEG
                                ang = ada*ang
*ICB                                write(6,'('' Theta'',f5.1
*ICB     +                           ,'', Phi'',F5.1
*ICB     +                           ,'', Sign'',F4.1,'', Flip'',L4
*ICB     +                           ,'', Rot'',3F6.1)')
*ICB     +                           alegu(1),alegu(2)
*ICB     +                           ,ada,qlflip,angle,angx,ang
                              ENDIF
                              ANGLE = ANGLE + ANG
                            endif
                          ELSE
                            CALL M_CXYZ(XL,YL,ZL,XXL,YYL,1
     +                       ,-NCTOPT)
                            XX = XXL + ADS*ALABLU(1,NAX) - 1.2*SIZET
                            YY = YYL + ADS*ALABLU(2,NAX)
                          ENDIF
                      ELSEIF(NAX.EQ.1) THEN
                          CALL MN_CTR(XL,YL,XXL,YYL,1,NCTOPT)
                          XX = XXL + ADS*ALABLU(1,NAX)
                          YY = YYL + ADS*ALABLU(2,NAX) - 0.5*SIZE
                      ELSEIF(NAX.EQ.2) THEN
                          CALL MN_CTR(XL,YL,XXL,YYL,1,NCTOPT)
                          XX = XXL + ADS*ALABLU(1,NAX) - 0.5*SIZE
                          YY = YYL + ADS*ALABLU(2,NAX)
                      ENDIF
                  ENDIF
                  IOPT  = ioptl(nax)
                  NFONT = IFNTU(4+2*NAX)
                  NCOL  = ICOLU(4)
                  THICK = ATHKU(4)
C
                  CALL MN_TXT(XX,YY,TXT1,SIZE,ANGLE,IOPT
     1             ,NFONT,NCOL,THICK)
              ENDIF
C             END OF IF(QLABL...
 3500     CONTINUE
C         DO JTB...
 4000 CONTINUE
C     DO NAX...
C
C     Draw in the frame last to overlay any lines in a different colour
C
8000  CONTINUE
      ncol  = icolu(1)
      thick = athku(1)
      do 8200 nax=1,nax2
          do 8100 jtb=1,2
              itb = jtb
              if(nleg.eq.1 .or. nleg.eq.2 .or. nleg.eq.8) then
                  if(abs(alegu(1)).ne.90.0) then
                      call m_tbleg(jtb,nax,alegu(2),itb)
                  endif
              endif
*
              qfram = qframu(jtb,nax)
              if(.not.qfram) goto 8100
*
              if((nleg.eq.1 .or. nleg.eq.2 .or. nleg.eq.8) .and.
     +           jtb.eq.2 .and. abs(alegu(1)).ne.90.0) goto 8100
              if(nax.eq.3 .and. jtb.eq.2) goto 8100
*
              call m_pfram(nax,itb,nleg,alegu(2),nctopt,ncol,thick,xunit
     +         ,xlo,xhi,ylo,yhi,zlo,zhi,xplo,xphi,yplo,yphi)
 8100     continue
 8200 continue
C
C     Reset the normalization transformation
C
      IF(NLEG.EQ.8) THEN
          CALL TVRNG(.TRUE.,0.0,0.0,SIZEU(1),SIZEU(2))
      ENDIF
C
C     One label per page
C
      DO NAX=1,2
        DO ITB=1,2
          N1 = 2*(ITB-1) + 1
          N2 = 2*ITB
          QFRAM = QFRAMU(ITB,NAX)
          QLABL = QLABLU(ITB,NAX)
          QLPAG = QLABLU(3,NAX)
          IF(QLABL .AND. QLPAG) THEN
            IF(ITB.EQ.1) THEN
              ADS = 1.0
              ADA = 1.0
            ELSE
              ADS = -1.0
              ADA = -1.0
            ENDIF
            NCHAR = ILABLU(NAX)
            TXT1  = TLABLU(NAX)
C
C           Make an axis label if this is a time plot
C
            IF(NAX.EQ.1 .AND. NTMODE.NE.0 .AND. NCHAR.LE.0) THEN
              WRITE(TXT2,'(I6.6,1X,I6.6)') NSDATE,NSTIME
              TXT1  = 'Starting time ' // TXT2
              NCHAR = LNBLNK(TXT1)
C
C             MAKE AN AXIS LABEL IF WE ARE MULTIPLYING BY A FACTOR
C
            ELSEIF(AFACT.NE.1.0 .AND. NCHAR.LE.0) THEN
              TXT1 = 'Scale multiplied by'
              CALL MN_NUM(AFACT,2,7,-2,0
     +         ,QPIP,TNUMB,NNCHAR,rnumb)
              TXT2  = CONCAT(TXT1,TNUMB(1:NNCHAR))
              TXT1  = TXT2
              NCHAR = 19 + NNCHAR
            ENDIF
C
C           DRAW THE AXIS LABEL
C
            IF(NCHAR.GT.0) THEN
              IOPT  = NINT(ALABLU(5,NAX))
              SIZE  = ALABLU(3,NAX)
              IF(NAX.EQ.1) THEN
                if(iopt.eq.-1) then
                  XX = AMRGU(1) +
     +             ADS*ALABLU(1,NAX)
                elseif(iopt.eq.+1) then
                  XX = AMRGU(1) + 1.0*HSZEU(1) +
     +             ADS*ALABLU(1,NAX)
                else
                  XX = AMRGU(1) + 0.5*HSZEU(1) +
     +             ADS*ALABLU(1,NAX)
                endif
                YY = AMRGU(2) + FLOAT(ITB-1)*HSZEU(2) +
     +           ADS*ALABLU(2,NAX) - 0.5*SIZE
              ELSE
                XX = AMRGU(1) + FLOAT(ITB-1)*HSZEU(1) +
     +           ADS*ALABLU(1,NAX) - 0.5*SIZE
                if(iopt.eq.-1) then
                  YY = AMRGU(2) +
     +             ADS*ALABLU(2,NAX)
                elseif(iopt.eq.+1) then
                  YY = AMRGU(2) + 1.0*HSZEU(2) +
     +             ADS*ALABLU(2,NAX)
                else
                  YY = AMRGU(2) + 0.5*HSZEU(2) +
     +             ADS*ALABLU(2,NAX)
                endif
              ENDIF
              ANGLE = ADA*ALABLU(4,NAX)
              NFONT = IFNTU(4+2*NAX)
              NCOL  = ICOLU(4)
              THICK = ATHKU(4)
C
              CALL MN_TXT(XX,YY,TXT1,SIZE,ANGLE,IOPT
     1         ,NFONT,NCOL,THICK)
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C
 9000 CONTINUE
C
C     Draw items in plot coordinates that should be drawn last
C
      call mn_ldp(0,.true.,01,ida,idb)
C
C     Close the segment
C
      CALL M_CLSG(NSEGM)
C
      END
