# #########################################################
#
# BRIEF:
#       This is a qmake project file for building the
#       the Qt based GUI MYODBCConfig application.
#
#       The build here is done by using the setup code
#       directly - at build-time.
#
# #########################################################

# #########################################################
# COMMON
# #########################################################
TEMPLATE                = app
TARGET                  = MYODBCConfig
DESTDIR                 = ./
OBJECTS_DIR             = .tmp
MOC_DIR                 = .tmp
UI_DIR                  = .tmp
LANGUAGE                = C++
CPP_ALWAYS_CREATE_SOURCE = TRUE
CONFIG                  += qt thread warn_on release
DEFINES                 += HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H
INCLUDEPATH             += ../util ../setup

# #########################################################
# WIN32
# #########################################################
win32:DEFINES           -= UNICODE
win32:DEFINES           += WIN32
win32:LIBS              += odbc32.lib odbccp32.lib ..\setup\myodbc3S.lib
# win32:RC_FILE         += MYODBCConfig.rc

# #########################################################
# UNIX
# #########################################################
unix:INCLUDEPATH        += ../util ../setup /usr/include
unix:LIBS               += -L../util/.libs -lmyodbcutil  -L/usr/lib -L/usr/local/lib -lodbc -lodbcinst 

# #########################################################
# OSX
#	On OSX we produce a directory called; MYODBCConfig.app
#	which contains everything needed to execute the app
#	using the 'open' command or by double-clicking in
#	Finder. MYODBCConfig.app can be copied to where desired
#	in the file system (for example; /Applications/Utilities).
# #########################################################
mac:DEFINES		-= HAVE_ODBCINST_H
mac:DEFINES		+= HAVE_IODBCINST_H
mac:LIBS                -= -lodbc -lodbcinst -lmyodbc3S
mac:LIBS                += -liodbc -liodbcinst 
mac:LIBS                += -lltdl -framework Carbon -framework QuickTime -lz -framework OpenGL -framework AGL -lz
mac:RC_FILE             = MYODBCConfig.icns

# #########################################################
# FILES
# #########################################################
HEADERS                 += \
                        ../util/MYODBCUtil.h \ 
                        ../setup/MYODBCSetup.h \
                        ../setup/MYODBCSetupCheckBox.h \
                        ../setup/MYODBCSetupComboBox.h \
                        ../setup/MYODBCSetupComboBoxDatabases.h \
                        ../setup/MYODBCSetupDataSourceDialog.h \
                        ../setup/MYODBCSetupDataSourceTab1.h \
                        ../setup/MYODBCSetupDataSourceTab2.h \
                        ../setup/MYODBCSetupDataSourceTab3.h \
                        ../setup/MYODBCSetupDataSourceTab3a.h \
                        ../setup/MYODBCSetupDataSourceTab3b.h \
                        ../setup/MYODBCSetupDataSourceTab3c.h \
                        ../setup/MYODBCSetupDataSourceTab3d.h \
                        ../setup/MYODBCSetupLineEdit.h

SOURCES                 += \
                        main.cpp \
                        ../setup/MYODBCSetupCheckBox.cpp \
                        ../setup/MYODBCSetupComboBox.cpp \
                        ../setup/MYODBCSetupComboBoxDatabases.cpp \
                        ../setup/MYODBCSetupConfigDSNAdd.c \
                        ../setup/MYODBCSetupConfigDSNEdit.c \
                        ../setup/MYODBCSetupConfigDSNRemove.c \
                        ../setup/MYODBCSetupDataSourceConfig.cpp \
                        ../setup/MYODBCSetupDataSourceDialog.cpp \
                        ../setup/MYODBCSetupDataSourceTab1.cpp \
                        ../setup/MYODBCSetupDataSourceTab2.cpp \
                        ../setup/MYODBCSetupDataSourceTab3.cpp \
                        ../setup/MYODBCSetupDataSourceTab3a.cpp \
                        ../setup/MYODBCSetupDataSourceTab3b.cpp \
                        ../setup/MYODBCSetupDataSourceTab3c.cpp \
                        ../setup/MYODBCSetupDataSourceTab3d.cpp \
                        ../setup/MYODBCSetupDriverConnect.c \
                        ../setup/MYODBCSetupDriverConnectPrompt.cpp \
                        ../setup/MYODBCSetupHandleInstallerError.c \
                        ../setup/MYODBCSetupLineEdit.cpp



