# -*- coding: utf-8 -*-
#
#  mciaudior.py - a MCIAUDIOR compatible Saori module for ninix
#  Copyright (C) 2003-2010 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os

import pygst
pygst.require("0.10")
import gst

from ninix.dll import SAORI


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.player = gst.element_factory_make("playbin", "player")
        fakesink = gst.element_factory_make("fakesink", "fakesink")
        self.player.set_property("video-sink", fakesink)
        bus = self.player.get_bus()
        bus.add_signal_watch()
        bus.connect("message", self.on_message)
        self.filepath = None
        self.state = 0 # 0/1/2 - stop/playing/paused
        self.loop = False

    def finalize(self):
        self.player.set_state(gst.STATE_NULL)
        self.player = None
        self.filepath = None
        return 1

    def execute(self, argv):
        argc = len(argv)
        if argc == 1:
            assert self.player is not None
            if argv[0] == 'stop':
                self.player.set_state(gst.STATE_NULL)
            elif argv[0] in ['play', 'loop']:
                if argv[0] == 'loop':
                    self.loop = True
                if self.state == 2:
                    self.state = 1
                    self.player.set_state(gst.STATE_PLAYING)
                    return self.RESPONSE[204]
                elif self.state == 1:
                    self.state = 2
                    self.player.set_state(gst.STATE_PAUSED)
                    return self.RESPONSE[204]
                if os.path.isfile(self.filepath):
                    self.player.set_property("uri", "file://" + self.filepath)
                    self.player.set_state(gst.STATE_PLAYING)
        elif argc == 2:
            if argv[0] == 'load':
                self.player.set_state(gst.STATE_NULL)
                filename = argv[1].replace('\\', '/')
                if not os.path.isabs(filename): # XXX
                    filename = filename.lower()
                self.filepath = os.path.join(self.dir, filename)
        return self.RESPONSE[204]

    def on_message(self, bus, message):
        t = message.type
        if t == gst.MESSAGE_EOS:
            if self.loop:
                self.player.set_state(gst.STATE_PLAYING)
                self.state = 1
            else:
                self.player.set_state(gst.STATE_NULL)
                self.state = 0
        elif t == gst.MESSAGE_ERROR:
            self.player.set_state(gst.STATE_NULL)
            err, debug = message.parse_error()
            print "Error: %s" % err, debug
            self.state = 0
            self.loop = False
