#include <vibtypes.h>
#include <vibprocs.h>
#include "njplot.h"
#include <math.h>
#include <time.h>
#include <ctype.h>

#ifdef WIN_MAC
#include <Quickdraw.h>
#include <Files.h>
#include <Scrap.h>
#endif

#include <vibdefns.h>

#ifdef WIN_MAC
#undef MoveTo
#undef LineTo
#undef ClipRect
#undef TextWidth
#undef DrawString
#undef PaintString
#define DIR_DELIM ':'

#elif defined(WIN_MSWIN)
#define DIR_DELIM '\\'
void *win32_malloc(size_t taille);
void *win32_calloc(size_t nbr, size_t taille);
void win32_free(void *ptr);
#define malloc win32_malloc
#define calloc win32_calloc
#define free win32_free

#else
#define DIR_DELIM '/'
#endif

#include <document.h>

/* typedefs */
struct noeud {
	double l1,l2,l3;
	struct noeud *v1,*v2,*v3;
	} **tabtax;
	
typedef struct { /* une branche definie par ses deux extremites */
	struct noeud *bouta;
	struct noeud *boutb;
	char *br_label;
	} branche;
branche *branches;

#define s_noeud sizeof(struct noeud)
char **tabnames, **labels, *br_length_txt, *end_br_length;
struct nom {
	double x,y;
	char *nom;
	char disp_option;
	} *noms;
struct mon_point {
	double x,y;
	int number;
	} *points;
struct trait {
	double xd,yd,xf,yf;
	} *traits;
struct noeud *racine;


struct win_help_extra {
	DoC document;
	FonT police;
	};


/* prototypes of included functions */
FD_nj_plot *create_win_nj_plot(void);
void cre_help_win(ButtoN unused);
FILE *open_path(char *fname);
void topic_callback(LisT list);
void help_ok_callback(ButtoN bouton);
void load_help_topics(FILE *fich, LisT topic_list);
void subtree_up_callback(ButtoN bouton);
static void quitproc(WindoW);
void win_resize_proc(WindoW);
void prepare_fonts(void);
void prepare_ps_font(int fontnum, int use_bold, int use_italic);
void change_panel_size(PaneL panel, int change_x, int change_y);
void do_plot(void);
void calc_text_size(char *text, double *width, double *height);
void plotstring(char *nom);
void dir_moveto(double x,double y);
void dir_lineto(double x,double y);
void scale_window(double lxmin, double lxmax, double lymin, double lymax,
 	double pxmin, double pxmax, double pymin, double pymax);
void ch_echelle(double lx, double ly, double *px, double *py);
void convert_mem_point(void);
void init_tree(void);
char *preptree(char *fname);
char *check_alloc(int nbrelt, int sizelt);
void err_message(char *text);
void loadphylip(char *arbre);
struct noeud *unrootedset(char *arbre, char *deb, char *fin, 
	branche **p_int_br);
char *extract_filename(char *name);
char *nextpar(char *text, char *pospar);
void mydrawstring(double x, double y, char *nom, char option);
void moveto(double x,double y);
void lineto(double x,double y);
double tree_bal(struct noeud *centre, struct noeud *p1, struct noeud *p2);
void get_next_br(struct noeud *pere, struct noeud *fils, 
	double **abdown, double **abup, struct noeud **f1, struct noeud **f2);
void place_midpoint_root(void);
void parcourir_branches(struct noeud *centre, struct noeud *origine);
void process_branche(struct noeud *cote1, struct noeud *cote2, double length);
double get_length_down(struct noeud *, struct noeud *);
void runtree(void);
void mem_plot(struct noeud *pere, struct noeud *centre, double currx,
	double *curry);
void mem_point(double x, double y, int number);
void mem_nom(double x, double y, char *nom, char option);
void mem_trait(double xd, double yd, double xf, double yf);
char *get_br_label(struct noeud *a, struct noeud *b);
int get_br_from_bouts(struct noeud *a, struct noeud *b);
void free_tree(void);
void ecrit_arbre_parenth(struct noeud *root);
char *recur_ecrit_arbre(struct noeud *centre, char *arbre, char *finarbre);
void removeroot(void);
void remove_arg(int target, int *argc, char *argv[]);
double length_log_phys(double p);
double length_phys_log(double p);
double arrondi_echelle(double x);
double calc_echelle(double larg);
void draw_scale(void);
int calc_n_desc(struct noeud *pere);
void bad_format(char *);
void majuscules(char *p);
void string_callback(ButtoN item);
void search_callback(IteM item);
void string_dialog_callback(TexT item);
void process_keys(Nlm_Char key);
#ifdef WIN_MAC
void add_apropos(char *);
int crefpict(char *, PicHandle );
void copy_plot(IteM);
#endif

/* globals */
FD_nj_plot *fd_nj_plot;
double	physx,physy,physx_min,physy_min,physx_corr,physy_corr;
/* window scaling variables */
double tek_xmin,tek_xmax,tek_ymin,tek_ymax,tek_dx,tek_dy;
double tek_minx,tek_maxx,tek_miny,tek_maxy;
double char_height;
double widnames;
double maxx, maxy, deltay, root_br_l, nexty;
/* max length of taxa names */
int tottraits, ps_plot, has_br_length = 0, totnoms = -1, notu, totbranches, 
	num_noeud, rooted, nextotu, totpoints,
	root_num, swap = 0, plot_br_l = 0, show_bootstrap = FALSE, has_internal = FALSE;
FonT current_font;
char current_ps_font[20];
int current_font_size_rank = font_normal;
int list_font_size[] = { 0, 8, 10, 12, 14, 18 };
char list_font_name[4][15] = {"", "Times", "Helvetica", "Courier"};
paper_item paper_choice = A4;
char fname[200], plotfilename[200], rooted_fname[200];
FILE *plotfile, *help_file;
int long_arbre_parenth; /* long de la chaine decrivant l'arbre lu */
int need_runtree;
int ps_plot_only = FALSE;
int converted;
enum operations {show_tree = 1, depl_racine, permutation, subtree} choix;
/* variables globales pour memoriser la meilleure branche:
celle qui partage l'arbre en 2 parties les plus egales possibles en prof moyenne
*/
double current_best_diff, current_br_length, current_balance;
struct noeud *current_cote1=NULL, *current_cote2=NULL;

struct noeud *subtree_center, *subtree_ascend;
int subtree_notu;
int doing_copy = FALSE;

#ifdef WIN_MAC
Rect		myrect;
PicHandle 	mypicture;
int 		margin;
#endif

int argc;
char **argv;

Int2 Main(void)
{
RecT *p_rect;

argc = Nlm_GetArgc();
argv = Nlm_GetArgv();
*fname = 0;
#ifndef WIN_MAC
process_args(&argc, argv);
if(argc>=2) {
	strcpy(fname,argv[1]);
	}
else	{
	*fname=0;
	}
#endif
   if(ps_plot_only) {
	int status;
	if( (int) strlen(fname) > 0) status = direct_ps_plot();
	return status;
	}
   fd_nj_plot = create_win_nj_plot();
   prepare_fonts();
   fd_nj_plot->tree_name = fname;

   /* fill-in form initialization code */

   /* show the first form */
   if(*fname != 0) init_tree();
   SetTitle(fd_nj_plot->nj_plot, (*fname == 0 ? "njplot" : extract_filename( fname ) ) );
   
   Show(fd_nj_plot->nj_plot);
   p_rect = (RecT *)GetWindowExtra(fd_nj_plot->nj_plot);
   ObjectRect(fd_nj_plot->nj_plot, p_rect);
   ProcessEvents();
   return 0;
}

#ifdef WIN_MSWIN
char **process_wincmdline(char *line, int *pargc)
{
#define MAXARGS 50
char *p, **argv, *newline;
int l, argc = 1;

argv = (char **)malloc(MAXARGS * sizeof(char *));
argv[0] = NULL;
l = strlen(line);
newline = (char *)malloc(l + 1); strcpy(newline, line);
p = strtok(newline, " ");
while(p != NULL && argc < MAXARGS) {
	argv[argc++] = p;
	p = strtok(NULL, " ");
	}

*pargc = argc;
return argv;
}
#endif

FD_nj_plot *create_win_nj_plot(void)
{
  GrouP obj;
  WindoW win;
  MenU menu;
  ChoicE choix_paper;
  GrouP group;
  FD_nj_plot *fdui = (FD_nj_plot *) calloc(1, sizeof(FD_nj_plot));
  static RecT winrect;
  PoinT position;
  
#ifdef WIN_MAC
add_apropos("njplot");
#endif
Nlm_KeyboardView(process_keys);
fdui->nj_plot = win = DocumentWindow(-50, -33, -3, -3, "Njplot", 
		quitproc, win_resize_proc);
#ifdef WIN_MAC
#define OPEN_LABEL      "Open        O"
#define SAVE_PLOT_LABEL "Save Plot P"
#define QUIT_LABEL      "Quit          Q"
#define COPY_LABEL      "Copy   C"
#define FIND_LABEL      "Find    F"
#define AGAIN_LABEL     "Again  A"
#define PLACE_OF_MENUS NULL
#else
#define OPEN_LABEL      "Open        ^O"
#define SAVE_PLOT_LABEL "Save plot  ^P"
#define QUIT_LABEL      "Quit          ^Q"
#define FIND_LABEL      "Find       ^F"
#define AGAIN_LABEL     "Again     ^A"
#define PLACE_OF_MENUS fdui->nj_plot
#endif
  menu = PulldownMenu(PLACE_OF_MENUS, "File");
  fdui->open_button =      CommandItem(menu, OPEN_LABEL, open_callback);
  fdui->save_plot_button = CommandItem(menu, SAVE_PLOT_LABEL, save_plot_callback);
  fdui->save_tree_button = CommandItem(menu, "Save Tree", save_tree_callback);
  			   CommandItem(menu, QUIT_LABEL, exit_callback);
  Advance(PLACE_OF_MENUS);
  menu = PulldownMenu(PLACE_OF_MENUS, "Edit");
#ifdef WIN_MAC
  CommandItem(menu, COPY_LABEL, copy_plot);
#endif
  CommandItem(menu, FIND_LABEL, search_callback);
  fdui->AgainItem = CommandItem(menu, AGAIN_LABEL, search_callback);
  Disable(fdui->AgainItem);
  Advance(PLACE_OF_MENUS);
  fdui->tree_font_menu = PulldownMenu(PLACE_OF_MENUS, "Font"); 
  fdui->choix_font = ChoiceGroup(fdui->tree_font_menu, font_callback);
  ChoiceItem(fdui->choix_font, "Times");
  ChoiceItem(fdui->choix_font, "Helvetica");
  ChoiceItem(fdui->choix_font, "Courier");
  SetValue(fdui->choix_font, times);
  SeparatorItem(fdui->tree_font_menu);
  fdui->choix_taille = ChoiceGroup(fdui->tree_font_menu, font_callback);
  ChoiceItem(fdui->choix_taille, "8");
  ChoiceItem(fdui->choix_taille, "10");
  ChoiceItem(fdui->choix_taille, "12");
  ChoiceItem(fdui->choix_taille, "14");
  ChoiceItem(fdui->choix_taille, "18");
  SetValue(fdui->choix_taille, current_font_size_rank);
  SeparatorItem(fdui->tree_font_menu);
  fdui->bold_item = StatusItem(fdui->tree_font_menu, "Bold", 
  	(Nlm_ItmActnProc) font_callback);
  fdui->italic_item = StatusItem(fdui->tree_font_menu, "Italic", 
  	(Nlm_ItmActnProc) font_callback);
  SetStatus(fdui->bold_item, FALSE);
  SetStatus(fdui->italic_item, FALSE);
  
  Advance(PLACE_OF_MENUS);
  fdui->paper_menu = PulldownMenu(PLACE_OF_MENUS, "Paper"); 
  choix_paper = ChoiceGroup(fdui->paper_menu, paper_callback);
  ChoiceItem(choix_paper, "A4");
  ChoiceItem(choix_paper, "US letter");
  SetValue(choix_paper, paper_choice);
  
  Break(PLACE_OF_MENUS);
  fdui->choix_group = NormalGroup(win, 4, 1, "Operation", programFont, operation_callback);
  RadioButton(fdui->choix_group, "Full tree");
  fdui->reroot_button = RadioButton(fdui->choix_group, "New outgroup");
  RadioButton(fdui->choix_group, "Swap nodes");
  RadioButton(fdui->choix_group, "Subtree");
  SetValue(fdui->choix_group, show_tree);

  Break(win);
  group = NormalGroup(win, 2, 1, "Display", programFont, NULL);
  fdui->branch_length_button = CheckBox(group, "Branch lengths", 
		toggle_branch_callback);
  SetStatus(fdui->branch_length_button, plot_br_l);
  fdui->bootstrap_button = CheckBox(group, "Bootstrap values", 
			toggle_bootstrap_callback);
  SetStatus(fdui->bootstrap_button, show_bootstrap);

  Advance(win);
  GetNextPosition(win, &position);
  position.x += 5;
  position.y += 10;
  SetNextPosition(win, position);
  fdui->subtree_up_button = PushButton(win, "Subtree Up", subtree_up_callback);
  Disable(fdui->subtree_up_button);

  Advance(win);
  PushButton(win, "Help", cre_help_win);

	Break(win);
#ifdef WIN_MSWIN
#define PLOT_HEIGHT 300
#elif defined(WIN_MAC)
#define PLOT_HEIGHT 200
#else
#define PLOT_HEIGHT 350
#endif
fdui->tree_plot = AutonomousPanel(win, 410, PLOT_HEIGHT, tree_draw_proc, NULL, 
		NULL, 0, NULL, NULL);
	SetPanelClick(fdui->tree_plot, tree_click_proc, NULL, NULL, NULL);
	winrect.left = -1;
	SetWindowExtra(win, &winrect, NULL);
	help_file = open_path("njplot.help");
#ifdef WIN_MSWIN
	{ /* contre bug fenetre mange un peu du panel */
	Int2 right;
  	Advance(win);
  	GetNextPosition(win, &position);
  	right = position.x + 5;
  	SetNextPosition(win, position);
  	Break(win);
  	GetNextPosition(win, &position);
  	position.x = right;
  	position.y += 3;
  	SetNextPosition(win, position);
  	StaticPrompt(win, "", 1, 1, programFont, 'l');
  	}
#endif
  return fdui;
}


FILE *open_path(char *fname)  /* to open in read-only file fname searching for 
				 it through all path directories */
{
#define Mxdir 200
        char dir[Mxdir+1], *path, *deb, *fin;
        FILE *fich;
        int lf, ltot;
#ifdef __VMS
	static char vmspath[] = "seaview";
	path = vmspath;
#elif defined(unix)
        path = getenv("PATH"); 	/* get the list of path directories, 
					separated by :
    				*/
#else
	path = NULL;
#endif
        if (path == NULL ) return fopen(fname,"r");
        lf=strlen(fname);
        deb=path;
        do
                {
                fin=strchr(deb,':');
                if(fin!=NULL)
                        { strncpy(dir,deb,fin-deb); ltot=fin-deb; }
                else
                        { strcpy(dir,deb); ltot=strlen(dir); }
                /* now one directory is in string dir */
                if( ltot + lf + 1 <= Mxdir)
                        {
#ifdef __VMS
                        dir[ltot]=':';
#else 
                        dir[ltot]='/';
#endif
                        strcpy(dir+ltot+1,fname); /* now dir is appended with fi
   lename */
                        if( (fich = fopen(dir,"r") ) != NULL) break;
                        }
                else fich = NULL;
                deb=fin+1;
                }
        while (fin != NULL);
	if(fich == NULL) fich=fopen(fname,"r"); /* try also current directory */
        return fich;
#undef Mxdir
}


void cre_help_win(ButtoN bouton)
{
static WindoW win;
LisT topic_list;
static DoC help_doc;
static struct win_help_extra win_data;
static int first = TRUE;
int larg;
GrouP group;

if(first) {
	if(help_file == NULL) {
		Disable(bouton);
		err_message("Sorry, help file njplot.help is not found.");
		return;
		}
	first = FALSE;
	win = DocumentWindow( -50, -33, -3, -3, "Njplot Help", NULL, NULL);
	group = HiddenGroup(win, -1, -2, NULL);
	SetGroupSpacing(group, 0, 5);
	topic_list = SingleList(group, 7, 8, topic_callback);
	load_help_topics(help_file, topic_list);
	DefaultButton(group, "Ok", help_ok_callback);
	Advance(win);
#ifdef WIN_MSWIN
	win_data.police = ParseFont("Courier New,10");
#else
	win_data.police = programFont;
#endif
	SelectFont(win_data.police);
	larg = 81 * Nlm_TextWidth("Q", 1);
	win_data.document = DocumentPanel(win, larg, 20 * Nlm_LineHeight() );
	SetWindowExtra(win, &win_data, NULL);
	}
Show(win);
Select(win);
}


void topic_callback(LisT list)
{
int num_topic;
char ligne[100], *p;
static int last_topic = 0;
Int2 total;
static char txt[5000];
WindoW win;
DoC help_doc;
struct win_help_extra *p_win_data;

num_topic = GetValue(list);
if(num_topic == 0 || num_topic == last_topic) return;
last_topic = num_topic;
win = ParentWindow(list);
p_win_data = (struct win_help_extra *)GetWindowExtra(win);
help_doc = p_win_data->document;
Hide(help_doc);
GetDocParams(help_doc, &total, NULL);
while(total > 0) DeleteItem(help_doc, total--);
rewind(help_file);
while(fgets(ligne, sizeof(ligne), help_file) != NULL) {
	if(strncmp(ligne, ">>>", 3) != 0) continue;
	if( --num_topic == 0) break;
	}
if(num_topic != 0) return;
p = txt;
while(fgets(ligne, sizeof(ligne), help_file) != NULL) {
	if(strncmp(ligne, ">>>", 3) == 0) break;
	strcpy(p, ligne); p += strlen(ligne);
	}
AppendText(help_doc, txt, NULL, NULL, p_win_data->police);
Show(help_doc);
}


void help_ok_callback(ButtoN bouton)
{
Hide( ParentWindow(bouton) );
}


void load_help_topics(FILE *fich, LisT topic_list)
{
char ligne[100], topic[50];
int l;

rewind(fich);
while(fgets(ligne, sizeof(ligne), fich) != NULL) {
	if(strncmp(ligne, ">>>", 3) != 0) continue;
	strcpy(topic, ligne + 3);
	l = strlen(topic) - 1;
	topic[l] = 0;
	ListItem(topic_list, topic);
	}
}


void subtree_up_callback(ButtoN bouton)
{
if(subtree_center == NULL) return;
subtree_center = subtree_ascend;
if(subtree_center != NULL) {
	subtree_ascend = subtree_center->v3;
	if(subtree_ascend == NULL) {
		SetValue(fd_nj_plot->choix_group, show_tree);
		Disable(fd_nj_plot->subtree_up_button);
		choix = show_tree;
		show_tree_callback();
		return;
		}
	subtree_notu = calc_n_desc(subtree_center) - 1;
	}
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}


void process_keys(Nlm_Char key)
{
#ifdef WIN_MAC
	/* combinaison command-lettre */
	#define test_key(a) Nlm_cmmdKey && Nlm_currentKey == a
#else
	/* combinaison control-lettre */
	#define test_key(a)  key == a - 96
#endif
if( test_key('q') ) 
	exit(0);
else if( test_key('o') )
	open_callback(fd_nj_plot->open_button);
else if( test_key('p') )
	save_plot_callback(fd_nj_plot->save_plot_button);
else if( test_key('f') )
	search_callback(NULL);
else if( test_key('a') ) {
	if(Enabled(fd_nj_plot->AgainItem) ) 
		search_callback(fd_nj_plot->AgainItem);
	}
#ifdef WIN_MAC
else if( test_key('c') )
	copy_plot(NULL);
#endif
return;
}


static void quitproc(WindoW i)
{
exit(0);
}


void win_resize_proc(WindoW win)
{
RecT *old_rect, rect;
int change_x, change_y, new_val, old_height, new_height;

old_rect = (RecT *)GetWindowExtra(win);
if(old_rect->left == -1) return;
ObjectRect(win, &rect);
old_height = old_rect->bottom - old_rect->top;
new_height = rect.bottom - rect.top;
change_y = (new_height - old_height);
old_height = old_rect->right - old_rect->left;
new_height = rect.right - rect.left;
change_x = (new_height - old_height);
if(change_x != 0 || change_y != 0) {
	change_panel_size(fd_nj_plot->tree_plot, change_x, change_y);
	*old_rect = rect;
	}
}


void change_panel_size(PaneL panel, int change_x, int change_y)
{
RecT r, r_group;
GrouP group;
Boolean in_group;

group = Parent(panel);
in_group = (group != ParentWindow(panel));
GetPosition(panel, &r);
if(in_group) {
	GetPosition(group, &r_group);
	Hide(group);
	}
else
	Hide(panel);
Reset(panel);
r.bottom += change_y;
r.right += change_x;
SetPosition(panel, &r);
if(in_group) {
	r_group.bottom += change_y;
	r_group.right += change_x;
	SetPosition( group, &r_group);
	Show(group);
	}
else	Show(panel);
}


void font_callback(ChoicE choix)
{
prepare_fonts();
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}


void prepare_fonts(void)
{
Boolean use_bold, use_italic;
Int2 font_num;
char font_full_name[20];

/* prepare vibrant font */
use_bold = GetStatus(fd_nj_plot->bold_item);
use_italic = GetStatus(fd_nj_plot->italic_item);
font_num = GetValue(fd_nj_plot->choix_font);
current_font_size_rank = GetValue(fd_nj_plot->choix_taille);
sprintf(font_full_name, "%s,%d", list_font_name[font_num], 
	list_font_size[current_font_size_rank]);
if(use_bold || use_italic) strcat(font_full_name, ",");
if(use_bold) strcat(font_full_name, "b");
if(use_italic) strcat(font_full_name, "i");
current_font = ParseFont(font_full_name);
prepare_ps_font(font_num, use_bold, use_italic);
}


void prepare_ps_font(int font_num, int use_bold, int use_italic)
{
/* prepare postscript name of font */
strcpy(current_ps_font, list_font_name[font_num]);
current_ps_font[0] = toupper(current_ps_font[0]);
if( use_bold )
	strcat(current_ps_font,"-Bold");
else if( use_italic )  {
	if(font_num == times) 
		strcat(current_ps_font,"-Italic");
	else
		strcat(current_ps_font,"-Oblique");
	}
else if(font_num == times) 
	strcat(current_ps_font,"-Roman");
}


void remove_arg(int target, int *argc, char *argv[])
{
int num;
for(num = target; num < *argc - 1; num++) 
	argv[num] = argv[num+1];
(*argc)--;
}


void process_args(int *argc, char *argv[])
{
int num, taille;

for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-h", 2) ==0 ){
		fprintf(stderr,"Usage: njplot [-options] [tree_file_name]\n"
"where options are:\n"
"-h             print out this message\n"
"-us            postcript tree file prepared for US Letter paper size\n"
"-psonly        no window interface, just write the postscript tree file\n"
"-size n        font size n used for taxon names\n"
"-lengths       show branch lengths if they appear in tree file\n"
"-boot          show bootstrap values if they appear in tree file\n"
"\n"
"and where tree_file_name is the name of a tree file using nested parentheses\n");
		exit(0);
		}
	}

for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-us", 3) == 0) {
		paper_choice = LETTER;
		remove_arg(num, argc, argv);
		break;
		}
	}

for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-size", 5) == 0) {
		const int maxi = sizeof(list_font_size) / sizeof(int);
		taille = 12;
		if(num + 1 < *argc) {
			sscanf(argv[num + 1], "%d", &taille);
			remove_arg(num + 1, argc, argv);
			}
		remove_arg(num, argc, argv);
		for(num = 0; num < maxi; num++) 
			if(taille <= list_font_size[num]) break;
		if(num >= maxi) 
			num = maxi - 1;
		current_font_size_rank = num;
		break;
		}
	}
for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-psonly", 7) == 0) {
		ps_plot_only = TRUE;
		remove_arg(num, argc, argv);
		break;
		}
	}
for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-lengths", 7) == 0) {
		plot_br_l = TRUE;
		remove_arg(num, argc, argv);
		break;
		}
	}
for(num = 1; num < *argc; num++) {
	if( strncmp(argv[num], "-boot", 5) == 0) {
		show_bootstrap = TRUE;
		remove_arg(num, argc, argv);
		break;
		}
	}
}


char *extract_filename(char *name)
{
char *p;
while( ( p = strchr(name, DIR_DELIM) ) != NULL) name = p + 1;
return name;
}


int direct_ps_plot(void)
{
char *p;
choix = show_tree;
/* read tree file */
if( preptree(fname) != NULL ) {
	return 1;
	}
strcpy(plotfilename, fname);
p = strchr(plotfilename, '.'); 
if(p == NULL) p = plotfilename + strlen(plotfilename);
strcpy(p, ".ps");
maxy = 1000.;
deltay = maxy/notu;
need_runtree = TRUE;
prepare_ps_font(times, FALSE, FALSE);
runtree();
ps_plot = TRUE;
do_plot();
return 0;
}


/* callbacks for form nj_plot */
void open_callback(IteM ob)
{
Boolean reponse;
if(notu != 0) free_tree();
notu = 0;
reponse = GetInputFileName(fname, sizeof(fname), NULL, NULL);
if(!reponse) {
	*fname = 0;
	SetTitle(fd_nj_plot->nj_plot, "njplot");
	tree_draw_proc(fd_nj_plot->tree_plot);
	return;
	}
init_tree();
SetTitle(fd_nj_plot->nj_plot, 
		(fd_nj_plot->tree_name[0] == 0 ? "njplot" : extract_filename( fname )) );
}


void paper_callback(ChoicE ob)
{
paper_choice = GetValue(ob);
}


void save_plot_callback(IteM ob)
{
double currx, curry;
char *p;
if(notu==0)return;
strcpy(plotfilename,fname);
p = strchr(extract_filename(plotfilename), '.'); 
if(p == NULL) p = plotfilename + strlen(plotfilename);
#ifdef WIN_MAC
strcpy(p,".pict");
#else
strcpy(p,".ps");
#endif
if(ob != NULL) {
	if( !GetOutputFileName(plotfilename, sizeof(plotfilename), 
		extract_filename(plotfilename) ) ) return;
	}
WatchCursor();
ps_plot = TRUE;
totnoms = tottraits = totpoints = -1;
end_br_length = br_length_txt;
currx = 0.;
maxx = 0.;
nexty = -deltay;
widnames = 0.0;
if(subtree_center == NULL)
	mem_plot(NULL, racine, currx, &curry);
else
	mem_plot(subtree_ascend, subtree_center, currx, &curry);
do_plot();
ps_plot = FALSE;
need_runtree = TRUE;
ArrowCursor();
}


void save_tree_callback(IteM ob)
{
char *p;

if(notu==0)return;
/* build out file name */
strcpy(rooted_fname, fname);
#ifndef WIN_MSWIN
/* ajouter _root. dans le nom */
#define AJOUT "_root."
if(strstr(rooted_fname, AJOUT) == NULL) {
	p = strchr(rooted_fname, '.'); 
	if(p == NULL) p = rooted_fname + strlen(rooted_fname);
	strcpy(p, AJOUT);
	}
#undef AJOUT
p = strchr(fname, '.');
if(p == NULL)
	strcat(rooted_fname, "ph");
else
	strcpy( strchr(rooted_fname,'.'), p);
#else
/* remplacer extension par .phr */
p = strchr(rooted_fname, '.');
if(p == NULL) p = rooted_fname + strlen(rooted_fname);
strcpy( p, ".phr");
#endif
if( !GetOutputFileName(rooted_fname, sizeof(rooted_fname), extract_filename(rooted_fname) ) ) 
		return;
ecrit_arbre_parenth(racine);
}


void toggle_branch_callback(ButtoN ob)
{
	plot_br_l = GetStatus(ob);
	need_runtree = TRUE;
	tree_draw_proc(fd_nj_plot->tree_plot);
}


void toggle_bootstrap_callback(ButtoN ob)
{
show_bootstrap = !show_bootstrap;
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}


void operation_callback(GrouP group)
{
choix = GetValue(group);
if(choix == permutation)
	swap_callback();
else if(choix == depl_racine)
	new_outgroup_callback();
else if(choix == subtree)
	subtree_callback();
else
	show_tree_callback();
}

void subtree_callback(void)
{
	choix = subtree;
	Disable(fd_nj_plot->save_tree_button);
	Disable(fd_nj_plot->open_button);
	Enable(fd_nj_plot->subtree_up_button);
	if(has_br_length) {
		SetStatus(fd_nj_plot->branch_length_button, FALSE);
		Disable(fd_nj_plot->branch_length_button);
		plot_br_l=0;
		}
	SetStatus(fd_nj_plot->bootstrap_button, FALSE);
	show_bootstrap = FALSE;
	Disable(fd_nj_plot->bootstrap_button);
	Disable(fd_nj_plot->reroot_button);
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}

void swap_callback(void)
{
	choix = permutation;
	Disable(fd_nj_plot->save_plot_button);
	Disable(fd_nj_plot->save_tree_button);
	Disable(fd_nj_plot->open_button);
	if(has_br_length) {
		SetStatus(fd_nj_plot->branch_length_button, FALSE);
		Disable(fd_nj_plot->branch_length_button);
		plot_br_l=0;
		}
	SetStatus(fd_nj_plot->bootstrap_button, FALSE);
	show_bootstrap = FALSE;
	Disable(fd_nj_plot->bootstrap_button);
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}

void new_outgroup_callback(void)
{
	choix = depl_racine;
	Disable(fd_nj_plot->save_plot_button);
	Disable(fd_nj_plot->save_tree_button);
	Disable(fd_nj_plot->open_button);
	if(has_br_length) {
		SetStatus(fd_nj_plot->branch_length_button, FALSE);
		Disable(fd_nj_plot->branch_length_button);
		plot_br_l=0;
		}
	SetStatus(fd_nj_plot->bootstrap_button, FALSE);
	show_bootstrap = FALSE;
	Disable(fd_nj_plot->bootstrap_button);
need_runtree = TRUE;
tree_draw_proc(fd_nj_plot->tree_plot);
}


void show_tree_callback(void)
{
	choix = show_tree;
	Enable(fd_nj_plot->save_plot_button);
	Enable(fd_nj_plot->save_tree_button);
	Enable(fd_nj_plot->open_button);
	Disable(fd_nj_plot->subtree_up_button);
	if(has_br_length) {
		Enable(fd_nj_plot->branch_length_button);
		}
	if(has_internal) {
		Enable(fd_nj_plot->bootstrap_button);
		}
	Enable(fd_nj_plot->reroot_button);
need_runtree = TRUE;
subtree_center = NULL;
tree_draw_proc(fd_nj_plot->tree_plot);
}


void exit_callback(IteM ob)
{
exit(0);
}


void tree_draw_proc(PaneL panel)
{
RecT ob_rect;
Int2 width, height;
static Int2 previous_h = 0, previous_w = 0;

WatchCursor();
Select (panel);
ObjectRect(panel, &ob_rect);
EraseRect(&ob_rect);
FrameRect(&ob_rect);
Nlm_ClipRect(&ob_rect);
	if(notu == 0 || strlen(fd_nj_plot->tree_name) == 0) {
		ArrowCursor();
		return;
		}
	width = ob_rect.right - ob_rect.left;
	height = ob_rect.bottom - ob_rect.top;
	SelectFont(current_font);
	Black();
	if( need_runtree || /* recalcul des positions des # si window re-size */
		(choix != show_tree && (height != previous_h || width != previous_w)))
			runtree();
	need_runtree = FALSE;
	swap = 0;
	do_plot();
	previous_w = width;
	previous_h = height;
Nlm_ResetClip();
ArrowCursor();
}


void tree_click_proc(PaneL panel, PoinT click)
{
	double eps, x, y;
	int i, found=0, node_num;
	RecT ob_rect;
	Int2 panel_x, panel_y, panel_h;
	if(notu==0) return;
	if(choix != permutation && choix != depl_racine && choix != subtree) 
		return;
	ObjectRect(panel, &ob_rect);
	panel_x = ob_rect.left; panel_y = ob_rect.top; panel_h = ob_rect.bottom - ob_rect.top;
	eps = char_height/2;
	x = click.x - panel_x;
	click.y -= panel_y;
	y = panel_h - click.y;
	for(i=0; i<=totpoints; i++ ) {
		if(fabs(x - (points+i)->x) > eps)
			 continue;
		if(fabs(y - (points+i)->y) > eps)
			 continue;
		found=1;
		break;
		}
	if(!found)return;
	node_num=(points+i)->number;
	if(choix==depl_racine) {
		if(node_num >= 1 && node_num <= 2*notu && 
						node_num-1 != root_num) {
			root_num = node_num-1;
			removeroot();
			}
		}
	else if(choix==permutation) {
		if(node_num >= notu+2 && node_num <= 2*notu+1) 
			swap= node_num-1;
		else
			swap=0;
		}
	else if(choix==subtree) {
		if(node_num < notu+2 || node_num > 2*notu+1) return;
		subtree_center = tabtax[node_num - 1];
		subtree_ascend = subtree_center->v3;
		subtree_notu = calc_n_desc(subtree_center) - 1;
		choix = show_tree;
		SetValue(fd_nj_plot->choix_group, 0);
		Nlm_InvalObject(fd_nj_plot->choix_group);
		if(has_br_length) {
			Enable(fd_nj_plot->branch_length_button);
			Nlm_InvalObject(fd_nj_plot->branch_length_button);
			}
		if(has_internal) {
			Enable(fd_nj_plot->bootstrap_button);
			Nlm_InvalObject(fd_nj_plot->bootstrap_button);
			}
		}
	need_runtree = TRUE;
	tree_draw_proc(panel);
}


double length_log_phys(double p)
{
return p * tek_dx;
}

double length_phys_log(double p)
{
return  p / tek_dx;
}


double arrondi_echelle(double x)
{ /* arrondi x a une valeur 1, 2, 5 pour echelle */
double l, n;
int r;
static int corresp[] = {1,1,2,2,5,5,5,10,10,10,10,10};
                     /* 0,1,2,3,4,5,6, 7, 8, 9,10,11 */
l = log10(x);
n = floor(l);
l = x * pow(10., -n);  /* 10. plutot que 10 necessaire pour alpha! */
r = myrint(l); r = corresp[r];
return r * pow(10., n);  /* 10. plutot que 10 necessaire pour alpha! */
}


double calc_echelle(double larg)
{ /* rend taille logique pour echelle optimale */
double log_val, phys_val;
phys_val = larg/10;
log_val = length_phys_log(phys_val);
log_val = arrondi_echelle(log_val);
return log_val;
}


void draw_scale(void)
{
char ech_name[20];
double phys_w, y, xd, xf, lc, height;
double log_val;

log_val = calc_echelle(physx);
phys_w = myrint(length_log_phys(log_val));
y = physy - 1.35 * char_height;
xf = physx * 0.95;
xd = xf - phys_w;
sprintf(ech_name, "%.1g", log_val);
calc_text_size(ech_name,&lc,&height);
dir_moveto( (xd + xf)/2 - lc/2, 
	y + char_height/6 ); 
plotstring(ech_name);
dir_moveto(xd, y);
dir_lineto(xf, y);
dir_moveto(xd, y - char_height/3);
dir_lineto(xd, y + char_height/3);
dir_moveto(xf, y - char_height/3);
dir_lineto(xf, y + char_height/3);
}


void do_plot(void)
{
struct trait *p;
int num, erreur = FALSE;
double width;

/* size of the tree plot window  */
if(ps_plot) {
#ifdef WIN_MAC
	int macfont;
	Style mystyle=normal;
	margin = 30;
	myrect.top=10;
	myrect.left=10;
	myrect.bottom=760;
	myrect.right=500;
	ClipRect(&myrect);
	mypicture = OpenPicture(&myrect);
	PenNormal();
	macfont = GetValue(fd_nj_plot->choix_font);
	if(macfont == courier)
		macfont=22;
	else if(macfont == helvetica)
		macfont=21;
	else if(macfont == times)
		macfont=20;
	else
		macfont=22;
	TextFont(macfont);
	TextSize( list_font_size[current_font_size_rank] );
    if( GetStatus(fd_nj_plot->bold_item) )
    	mystyle += bold;
    if( GetStatus(fd_nj_plot->italic_item) )
    	mystyle += italic;
    TextFace(mystyle);
	physx = myrect.right-myrect.left - 2 * margin;
	physy = myrect.bottom-myrect.top - 2 * margin;
#else
	const int a4_h = 750, letter_h = 700;
	int paper_h, font_size;
	time_t heure;
	font_size = list_font_size[current_font_size_rank];
	plotfile = fopen(plotfilename,"w");
	if(plotfile == NULL) {
		erreur = TRUE;
		goto fin;
		}
	physx = 500.0;
	if(paper_choice == A4)
		paper_h = a4_h;
	else
		paper_h = letter_h;
	physy = paper_h;
fprintf(plotfile,"%%!\n1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray\n");
fprintf(plotfile,"/basefont /%s findfont %d scalefont def\n",
	current_ps_font, font_size);
fprintf(plotfile,"/titlefont /Times-Roman findfont 12 scalefont def\n");
fprintf(plotfile,"50 50 translate\n");
fprintf(plotfile,"-10 -10 moveto 510 -10 lineto 510 %d lineto -10 %d lineto \
-10 -10 lineto stroke\n", paper_h+10, paper_h+10);
time(&heure);
fprintf(plotfile,"titlefont setfont\n");
fprintf(plotfile, "0 %d moveto (%s     %s) show\n", paper_h+15, fname, ctime(&heure));
fprintf(plotfile,"basefont setfont\n");
#endif
	}
else {
	RecT ob_rect;
	ObjectRect(fd_nj_plot->tree_plot, &ob_rect);
	physx = ob_rect.right - ob_rect.left;
	physy = ob_rect.bottom - ob_rect.top;
	}

physx_corr = physx - widnames - char_height/3;
physx_min  = char_height;
physy_corr = physy - 2*char_height;
physy_min  = char_height;
scale_window(0, maxx, 0, maxy, 
	physx_min, physx_corr, physy_min, physy_corr);

for(num=0; num<=totnoms; num++) {
	mydrawstring( (noms+num)->x, (noms+num)->y , (noms+num)->nom,
			(noms+num)->disp_option );
	}
for(num=0; num<=tottraits; num++) {
	p= traits+num;
	moveto(p->xd,p->yd);
	lineto(p->xf,p->yf);
	}

if(has_br_length){
	/* echelle */
	draw_scale();
	}

convert_mem_point();
	
if(ps_plot) {
#ifdef WIN_MAC
	ClosePicture();
	if( !doing_copy ) erreur = crefpict(plotfilename, mypicture);
#else
	fprintf(plotfile,"showpage\n");
	if(ferror(plotfile)) erreur = TRUE;
	fclose(plotfile);
#endif
	if(!erreur && !ps_plot_only && !doing_copy ) {		
		char mess[250];
		sprintf(mess, 
			"Tree plot is now in file %s in "
#ifdef WIN_MAC
			"PICT"
#else
			"Postscript"
#endif
			" format", 
			extract_filename(plotfilename) );
		need_runtree = TRUE;
		ps_plot = FALSE; /* pour eviter boucle infernale! */
		err_message(mess);
		}
	}
fin: 
if(ps_plot && erreur && !ps_plot_only) {
	char mess[250];
	sprintf(mess, "Error while writting to file %s", 
			extract_filename(plotfilename) );
	need_runtree = TRUE;
	ps_plot = FALSE; /* pour eviter boucle infernale! */
	err_message(mess);
	}
} /* end of do_plot */


void calc_text_size(char *text, double *width, double *height)
{
double jambe;
Int2 ascend, descend;
if(ps_plot) {
#ifdef WIN_MAC
	static FontInfo macfontinfo;
	*width = TextWidth(text, 0, strlen(text));
	GetFontInfo(&macfontinfo);
	*height = macfontinfo.ascent + macfontinfo.descent;
#else
	int font_size;
	font_size = list_font_size[current_font_size_rank];
	*width = font_size * 0.61 * (int)strlen(text);
	*height = font_size;
#endif
	}
else	{
	ascend = Ascent(); descend = Descent();
	*height = ascend + descend;
	*width = Nlm_TextWidth(text, strlen(text) );
	}
}


void plotstring(char *nom)
{
Int2 x, y;
RecT obrect;
if(ps_plot) { 
#ifdef WIN_MAC
	static char copy[255];
	int l;
	l = strlen(nom);
	*copy = l;
	memcpy(copy + 1, nom, l + 1);
	DrawString( (ConstStr255Param) copy);
#else
	fprintf(plotfile,"(%s) show\n",nom);
#endif
	}
else 	{
	Nlm_PaintString(nom);
	}
}


void dir_moveto(double x,double y)
/* move to physical coord x,y */
{
if(ps_plot) {
	int xi,yi;
	xi=x;
#ifdef WIN_MAC
	xi += margin;
	yi = physy - y + margin;
	MoveTo(xi, yi);
#else
	yi=y;
	fprintf(plotfile,"%d %d moveto\n",xi,yi);
#endif
}
else	{
	RecT obrect;
	ObjectRect(fd_nj_plot->tree_plot, &obrect);
	Nlm_MoveTo(myrint(x) + obrect.left, obrect.bottom - myrint(y) );
	}
}

void dir_lineto(double x,double y)
/* draw line from current pos to physical coord x,y */
{
if(ps_plot) {
	int xi,yi;
	xi=x;
#ifdef WIN_MAC
	xi += margin;
	yi = physy - y + margin;
	LineTo(xi, yi);
#else
	yi=y;
	fprintf(plotfile,"%d %d lineto stroke\n",xi,yi);
#endif
}
else	{
	RecT obrect;
	ObjectRect(fd_nj_plot->tree_plot, &obrect);
	Nlm_LineTo(	myrint(x) + obrect.left, obrect.bottom - myrint(y) );
	}
}


#ifdef WIN_MAC
int crefpict(char *fname, PicHandle picture)
{
OSErr success = 0, err;
static char zeros[512];
Boolean async = false;
static char strfname[255];
OSType f_type,f_creator;
static ParamBlockRec paramblock;
PicPtr picptr;
int size;

strcpy(strfname+1, fname);
*strfname = strlen(fname);
paramblock.fileParam.ioNamePtr = (StringPtr)&strfname;

plotfile = fopen(fname, "wb");
if( (plotfile == NULL) || (fwrite(zeros,1,512,plotfile) != 512) )
	return TRUE;
picptr = *picture;
size = GetHandleSize((Handle)picture);
if( fwrite(picptr,1,size,plotfile) != size ) return TRUE;
fclose(plotfile);
KillPicture(picture);

err = PBGetFInfo(&paramblock,async);
if( err != success ) return FALSE;
strncpy((char *)&f_type, "PICT", 4);
strncpy((char *)&f_creator, "CDrw", 4); /* creator = ClarisDraw */
paramblock.fileParam.ioFlFndrInfo.fdType = f_type;
paramblock.fileParam.ioFlFndrInfo.fdCreator = f_creator;
err = PBSetFInfo(&paramblock, async);
return FALSE;
}


void copy_plot(IteM unused)
{
unsigned long pictlen;
double currx, curry;

if(notu == 0) return;
WatchCursor();
doing_copy = TRUE;
ps_plot = TRUE;
totnoms = tottraits = totpoints = -1;
end_br_length = br_length_txt;
currx = 0.;
maxx = 0.;
nexty = -deltay;
widnames = 0.0;
if(subtree_center == NULL)
	mem_plot(NULL, racine, currx, &curry);
else
	mem_plot(subtree_ascend, subtree_center, currx, &curry);
do_plot();

ZeroScrap();
HLock( (Handle) mypicture);
pictlen = GetHandleSize( (Handle)  mypicture);
PutScrap(pictlen, 'PICT', (Ptr)*mypicture);
HUnlock( (Handle) mypicture);
KillPicture(mypicture);
ps_plot = FALSE;
need_runtree = TRUE;
doing_copy = FALSE;
ArrowCursor();
}
#endif


void string_dialog_callback(TexT item)
{
}


void string_callback(ButtoN item)
{
Boolean *pdone;

pdone = (Boolean *)GetWindowExtra( Nlm_ParentWindow(item) );
*pdone = TRUE;
}


void search_callback(IteM item)
{
static WindoW win;
static Boolean search_done;
static TexT select_box;
static char select[100];
char aux[100];
int num, trouve;
static int first = TRUE;

if(item != fd_nj_plot->AgainItem) {
	if(first) {
		win = FixedWindow(-50,-50,-5,-5,"Name searched:",NULL);
		select_box=DialogText(win,"",15,string_dialog_callback);
		Advance(win);
		DefaultButton(win,"ok",string_callback);
		SetWindowExtra(win, &search_done, NULL);
		first = FALSE;
		}
	Show(win);
	Select(win); Select(select_box);
	search_done=FALSE;
	while(! search_done) {
		Nlm_ProcessAnEvent();
		}
	GetTitle(select_box, select, sizeof(select));
	majuscules(select);
	Hide(win);
	Enable(fd_nj_plot->AgainItem);
	Select(fd_nj_plot->nj_plot);
	}
if(strlen(select) == 0) return;
trouve = FALSE;
for(num = 0; num <= totnoms; num++) {
	strcpy(aux, (noms+num)->nom);
	majuscules(aux);
	if(strstr( aux, select) != NULL) {
		(noms+num)->disp_option = 'r';
		trouve = TRUE;
		}
	}
if(trouve) {
	tree_draw_proc(fd_nj_plot->tree_plot);
	}
}


void scale_window(double lxmin, double lxmax, double lymin, double lymax,
 double pxmin, double pxmax, double pymin, double pymax)
/* to scale the plot window for logical coords l... in physical coords p... */
{
tek_xmin=lxmin; tek_xmax=lxmax; tek_ymin=lymin; tek_ymax=lymax;
tek_minx=pxmin; tek_maxx=pxmax; tek_miny=pymin; tek_maxy=pymax;
tek_dx = (tek_maxx-tek_minx)/(tek_xmax-tek_xmin);
tek_dy = (tek_maxy-tek_miny)/(tek_ymax-tek_ymin);
}


void ch_echelle(double lx, double ly, double *px, double *py)
/* conversion coord logique lx,ly en coord physique px,py */
{
*px = (lx-tek_xmin)*tek_dx + tek_minx;
*py = (ly-tek_ymin)*tek_dy + tek_miny;
}

void convert_mem_point(void)
{
int i;
if(converted) return;
for (i=0; i<=totpoints; i++) {
   	ch_echelle( (points+i)->x, (points+i)->y, &((points+i)->x), 
			&((points+i)->y) );
	(points+i)->x += char_height / 6;
	}
converted = TRUE;
}


void init_tree(void)
{
char *pname;
choix = show_tree;
WatchCursor();
/* read tree file */
if( (pname=preptree(fname)) != NULL ) {
	char *message;
	size_t taille;
	fd_nj_plot->tree_name[0] = 0;
	notu = 0;
	tree_draw_proc(fd_nj_plot->tree_plot);
	taille = strlen(pname) + strlen(fname) + 3;
	message = check_alloc(1, taille);
	strcpy(message, pname);
	strcat(message, " ");
	strcat(message, extract_filename(fname) );
	err_message(message);
	free(message);
	return;
	}
maxy = 1000.;
deltay = maxy/notu;
fd_nj_plot->tree_name = fname;
need_runtree = TRUE;
subtree_center = NULL;
tree_draw_proc(fd_nj_plot->tree_plot);
if(has_br_length) {
	Enable(fd_nj_plot->branch_length_button);
	}
else
	Disable(fd_nj_plot->branch_length_button);
if(has_internal) {
	Enable(fd_nj_plot->bootstrap_button);
	}
else
	Disable(fd_nj_plot->bootstrap_button);
}

char *preptree(char *fname)
{
int i, c, steparbre, maxarbre, maxlname;
FILE *njfile;
char *arbre, *der_arbre, *finarbre, *tmp;
static char message[200];

if( (njfile=fopen(fname,"r")) == NULL ){
	sprintf(message, "Tree file %s not found.", fname);
	return (message);
	}
/* recherche du debut de la description de l'arbre */
do c=fgetc(njfile);
while (c == '\n' || c == ' ' );
/* for fastDNAml format, skip initial [comment] */
if(c == '[') {
	do c=fgetc(njfile); while (c != ']');
	do c=fgetc(njfile); while (c == '\n' || c == ' ' );
	}
if ( c != '(') {
	fclose(njfile);
	goto erreur;
	}
/* lecture de l'arbre par paquets de steparbre caracteres*/
	steparbre=1000;
	maxarbre=steparbre;
	arbre=check_alloc(maxarbre,1);
	der_arbre = arbre+maxarbre;
	*arbre=c;
	notu=2; i=3;
	finarbre=arbre;
	while( (c=fgetc(njfile)) != EOF && c != ';') {
		if( c=='\n' || c=='\r') continue;
		if(++finarbre >= der_arbre-2) {
			maxarbre += steparbre;
			tmp=check_alloc(maxarbre,1);
			memcpy(tmp,arbre,finarbre-arbre);
			finarbre=tmp+(finarbre-arbre);
			free(arbre);
			arbre=tmp;
			der_arbre=arbre+maxarbre;
			}
		*(finarbre)=c;
		if(c==')')notu++;
		if(c=='(')i++;
		}
	*(finarbre+1)='\0';
long_arbre_parenth= (finarbre-arbre+1);
fclose(njfile);
if(i!=notu)goto erreur;
notu--;
totbranches= -1;

/* allocate all memory */
tabtax = (struct noeud **)check_alloc(2*notu +1,sizeof(struct noeud *));
branches = (branche *)check_alloc(notu-2,sizeof(branche));
tabnames = (char **)check_alloc(2*notu+1, sizeof(char *));
for(i=0; i<2*notu+1; i++) *(tabtax+i)=
			(struct noeud *)check_alloc(1,s_noeud);
noms = (struct nom *)check_alloc(5*notu+1,sizeof(struct nom));
points = (struct mon_point *)check_alloc(4*notu+1,sizeof(struct mon_point));
traits = (struct trait *)check_alloc(3*notu,sizeof(struct trait));
labels = (char **)check_alloc(notu+1, sizeof(char *));
br_length_txt = (char *)check_alloc(2*notu,10);
loadphylip(arbre);
free(arbre);
maxlname = 0; /* largeur max des noms des feuilles */
for(i = 0; i <= nextotu; i++) {
	c = strlen(labels[i]);
	if(c > maxlname) maxlname = c;
	}
for(i = 0; i < 2*notu+1; i++) {
	tabnames[i] = (char *)check_alloc(maxlname + 2 + 1, 1); /*2=place pour # */
	}
	
if(!rooted) {
	racine = *(tabtax+(++num_noeud));
	if(num_noeud >= 2*notu + 1) bad_format("Error: incorrect tree file");
	if(has_br_length) {
		place_midpoint_root();
		root_num = -1;
		}
	else	{
/* ancienne version: derniere espece est groupe externe
*/
		racine->v3 = NULL;
		root_num = notu; 
		}
	}
else	{
	racine = *(tabtax+num_noeud);
	root_br_l= racine->l1 + racine->l2;
	root_num = num_noeud;
	if(!has_br_length) tree_bal(racine,racine->v1,racine->v2);
/* y a-t-il un bootstrap sur l'une des branches racine ? */
	i = get_br_from_bouts(racine, racine->v1); 
	if(i == -1) i = get_br_from_bouts(racine, racine->v2);
	if(i != -1) {
		branches[i].bouta = racine->v1;
		branches[i].boutb = racine->v2;
		}
	}
if(notu+1<3) return ("Tree should contain at least 3 elements.");
return NULL;

erreur:
return ("File does not contain correct tree data.");
} /* end of preptree */


char *check_alloc(int nbrelt, int sizelt)
{
char *retval;
if( (retval=(char *)calloc(nbrelt,sizelt)) != NULL ) return retval;
err_message("ERROR: Not enough memory.");
exit(1);
}


/* fenetre message d'alerte.
Operation Select dans la boucle des evenements qui ramene toujours la fenetre
au premier plan. Lent, mais interessant.
*/
static void alert_ok_action(ButtoN bouton)
{
Boolean *alert_done;
alert_done = (Boolean *)GetWindowExtra(Parent(bouton));
*alert_done = TRUE;
}


void err_message(char *texte)
{
WindoW alwin;
Boolean alert_done;

alwin=FloatingWindow(-50,-50,-5,-5,NULL);
StaticPrompt(alwin,texte,0,0,programFont,'l');
Break(alwin);
DefaultButton(alwin,"ok",alert_ok_action);
Show(alwin);
alert_done=FALSE;
SetWindowExtra(alwin, &alert_done, NULL);
ArrowCursor();
while(! alert_done) {
	Nlm_ProcessAnEvent();
	if(!alert_done) {
		Select(alwin); 
		}
	}
Remove(alwin);
}


void loadphylip(char *arbre)
{
char *deba,*debb,*debc, *finarbre;
struct noeud *p1, *p2, *p3, *p;
branche *int_br_g, *int_br_d;
int i;

has_br_length = 2;
has_internal = FALSE;
/* ignore all stuff after last closing parenthesis 
(needed for fastDNAml output)
*/
finarbre= nextpar(arbre,arbre);
rooted=0;
deba=arbre+1;
debb=deba;
while(*debb != ',') {
	if(*debb == 0) bad_format("Incorrect tree file");
	if(*debb == '(')debb=nextpar(arbre,debb);
	debb++;
	}
debb++;
debc=debb;
while(*debc != ',' && debc<finarbre) {
	if(*debc == '(')debc=nextpar(arbre,debc);
	debc++;
	}
if(*debc==',') {
/* the tree is unrooted <==> it has 3 subtrees at its bottommost level */
	debc++;
	}
else	{
/* the tree is rooted */
	debc=finarbre+1;
	rooted=1;
/*!!!!!!!! notu computed before was 1 unit too high !!!!!!!!*/
	notu--;
	}
num_noeud=notu;
nextotu= -1;
p1=unrootedset(arbre,deba,debb-2,&int_br_g);
p2=unrootedset(arbre,debb,debc-2,&int_br_d);
p = *(tabtax+(++num_noeud));
if(num_noeud >= 2*notu + 1) bad_format("Error: incorrect tree file");
if(!has_br_length) {
	p1->l3 = 0.5*p1->l3;
	p2->l3 = 0.5*p2->l3;
	}
p->v1=p1; p1->v3=p; p->l1=p1->l3;
if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p1; }
p->v2=p2; p2->v3=p; p->l2=p2->l3;
if(int_br_d!=NULL) { int_br_d->bouta=p; int_br_d->boutb=p2; }
if(!rooted) {
	p3=unrootedset(arbre,debc,finarbre-1,&int_br_g);
	if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p3; }
	p->v3=p3; p3->v3=p; p->l3=p3->l3;
	}
else	{
	p->v3=NULL;
/* recherche d'un dernier label interne */
	debc=finarbre+1;
	while(*debc!=0 && *debc!=':' && *debc!='[') debc++;
	if(debc-finarbre>1) {
		int l=debc-finarbre-1;
		has_internal = TRUE;
		totbranches++;
		branches[totbranches].br_label=check_alloc(l+1,1);
		memcpy(branches[totbranches].br_label,finarbre+1,l);
		branches[totbranches].br_label[l]=0;
		branches[totbranches].bouta=p1;
		branches[totbranches].boutb=p2;
		}
	}
}


struct noeud *unrootedset(char *arbre, char *deb, char *fin, branche **p_int_br)
{
struct noeud *p;
char *virg;
int l;
branche *int_br_g, *int_br_d;

*p_int_br=NULL;
while(*deb==' ' || *deb=='\'')deb++;
while(*fin==' ')fin--;
virg=deb;
while(*virg != ',' && virg < fin) {
	if(*virg == '(') virg=nextpar(arbre,virg);
	virg++;
	}
if(virg>fin) virg=deb;
if(*virg == ',') {
	struct noeud *p1,*p2;
	p1=unrootedset(arbre,deb,virg-1,&int_br_g);
	p2=unrootedset(arbre,virg+1,fin,&int_br_d);
	p = *(tabtax+(++num_noeud));
	if(num_noeud >= 2*notu + 1) bad_format("Error: incorrect tree file");
	p->v1=p1; p1->v3=p; p->l1=p1->l3;
	if(int_br_g!=NULL) { int_br_g->bouta=p; int_br_g->boutb=p1; }
	p->v2=p2; p2->v3=p; p->l2=p2->l3;
	if(int_br_d!=NULL) { int_br_d->bouta=p; int_br_d->boutb=p2; }
	}
else	{
	double brlength;
	virg=deb;
	while(*virg != ':' && virg < fin) {
		if(*virg=='(')virg=nextpar(arbre,virg);
		virg++;
		}
	if(virg>fin) virg=deb;
	if(*virg == ':') {
		if(has_br_length == 0) goto problem;
		sscanf(virg+1,"%le",&brlength);
		virg--;
		has_br_length=1;
		if(*fin == ']') { /* bootstrap entre [] apres longueurs */
			char *fpar = fin - 1;
			while(fpar > virg + 1 && *fpar != '[') fpar--;
			if(*fpar == '[' && fin - fpar >= 2) {
				has_internal = TRUE;
				totbranches++;
				l = fin - fpar - 1;
				branches[totbranches].br_label =
					check_alloc(l+1,1);
				memcpy(branches[totbranches].br_label,fpar+1,l);
				branches[totbranches].br_label[l]=0;
				*p_int_br= &branches[totbranches];
				}
			}
		}
	else	{
		if(has_br_length == 1) goto problem;
		brlength=1;
		has_br_length=0;
		}
	if(*deb == '(') {
		char *fpar;
		branche *prov;
		fpar=nextpar(arbre,deb)-1;
		p=unrootedset(arbre,deb+1,fpar,&prov);
/* recherche internal label */
		l=virg-fpar-1;
		if(l>0) {
			has_internal = TRUE;
			totbranches++;
			branches[totbranches].br_label=
				check_alloc(l+1,1);
			memcpy(branches[totbranches].br_label,fpar+2,l);
			branches[totbranches].br_label[l]=0;
			*p_int_br= &branches[totbranches];
			}
		}
	else	{ /* memoriser les noms des feuilles dans labels */
		size_t n;
		if( virg-1 >= deb && *virg == '\'' ) virg--;
		n = virg-deb+1;
		labels[++nextotu] = (char *)check_alloc(n + 1, 1);
		memcpy(labels[nextotu], deb, n);
		labels[nextotu][n] = 0;
		p = *(tabtax+nextotu);
		p->v1 = p->v2 = p->v3 = NULL;
		}
	p->l3 = brlength;
	}
return p;
problem:
err_message("Error: Inconsistent tree file for branch lengths.");
exit(1);
}


char *nextpar(char *text, char *pospar)
{
char *pos;
pos=pospar+1;
while(*pos != ')') {
	if(*pos == 0) bad_format("Error: unbalanced parentheses");
	if(*pos == '(') pos=nextpar(text,pos);
	pos++;
	}
return pos;
}


void bad_format(char *mess)
{
err_message(mess);
exit(1);
}


void mydrawstring(double x, double y, char *nom, char option)
{
static double px,py;

ch_echelle(x,y,&px,&py);
if(option == '1') {
/* ecrire une chaine en la montant d'un chouia */
	py += char_height/6;
	}
else if(option == 'c' || option == 'r')	{
/* ecrire une chaine en la centrant vert. sur cette position*/
	py -= char_height/3;
	px += char_height/6;
	}
else if(option == 't')	{
	py -=  (5./6.) * char_height;
	}
else if(option == 'b')	{
	py += char_height/6;
	}
dir_moveto(px,py);
if(option == 'r') 
	Nlm_Red();
plotstring(nom);
if(option == 'r') 
	Nlm_Black();
}


void moveto(double x,double y)
/* move from current pos to logical coord x,y */
{
static double px,py;
ch_echelle(x,y,&px,&py);
dir_moveto(px,py);
}


void lineto(double x,double y)
/* draw line from current pos to logical coord x,y */
{
static double px,py;
ch_echelle(x,y,&px,&py);
dir_lineto(px,py);
}

/* pour un arbre sans longueur de branche, les calculer de facon a ce
que toutes les feuilles arrivent a la meme profondeur */
double tree_bal(struct noeud *centre, struct noeud *p1, struct noeud *p2)
{
double ld, lg, pg, pd, *abup1, *abup2, *abdown1, *abdown2;
struct noeud *f1, *f2;
get_next_br(centre,p1,&abup1,&abdown1,&f1,&f2);
if(f1!=NULL) lg=tree_bal(p1,f1,f2);
else lg=0.0;
get_next_br(centre,p2,&abup2,&abdown2,&f1,&f2);
if(f1!=NULL) ld=tree_bal(p2,f1,f2);
else ld=0.0;
pg=lg+1; pd=ld+1;
if(pg>pd) pd=pg;
else pg=pd;
*abup1 = *abdown1 = pg-lg;
*abup2 = *abdown2 = pd-ld;
return (pg);
}


void get_next_br(struct noeud *pere, struct noeud *fils, 
double **abdown, double **abup, struct noeud **f1, struct noeud **f2)
/* pour une branche pere->fils donnee, calculer dans *f1, *f2 les deux autres
voisins de fils et dans *abdown et *abup les adresses des longeurs de la
branche pere->fils dans les deux sens */
{
if(pere->v1==fils) *abdown= &(pere->l1);
else if(pere->v2==fils) *abdown=&(pere->l2);
else *abdown=&(pere->l3);
if(fils->v1==pere) {
	*abup=&(fils->l1);
	*f1=fils->v2;
	*f2=fils->v3;
	}
else if(fils->v2==pere) {
	*abup=&(fils->l2);
	*f1=fils->v1;
	*f2=fils->v3;
	}
else 	{
	*abup=&(fils->l3);
	*f1=fils->v1;
	*f2=fils->v2;
	}
}


void place_midpoint_root(void)
/* enraciner l'arbre sans racine en cherchant son centre 
*/
{
struct noeud *aux;
double laux;

current_best_diff= 9.e99;
current_cote1=current_cote2=NULL;
parcourir_branches(*tabtax,NULL);
rooted = TRUE;
root_br_l = current_br_length;
/* il faut toujours que la racine soit telle que racine->v1->v3=racine */
if (current_cote1->v1 == current_cote2 ) {
/* echanger les voisins v1 et v3 de cote1 */
	aux=current_cote1->v1;
	current_cote1->v1=current_cote1->v3;
	current_cote1->v3=aux;
	laux=current_cote1->l1;
	current_cote1->l1=current_cote1->l3;
	current_cote1->l3=laux;
	}
else if (current_cote1->v2 == current_cote2) {
/* echanger les voisins v2 et v3 de cote1 */
	aux=current_cote1->v2;
	current_cote1->v2=current_cote1->v3;
	current_cote1->v3=aux;
	laux=current_cote1->l2;
	current_cote1->l2=current_cote1->l3;
	current_cote1->l3=laux;
	}
current_cote1->v3 = racine;

if (current_cote2->v1 == current_cote1 )
	current_cote2->v1 = racine;
else if (current_cote2->v2 == current_cote1)
	current_cote2->v2 = racine;
else
	current_cote2->v3 = racine;
racine->v1=current_cote1;
racine->v2=current_cote2;
racine->v3=NULL;
racine->l3=0;
racine->l1=current_br_length*current_balance;
racine->l2=current_br_length - racine->l1;
}


void parcourir_branches(struct noeud *centre, struct noeud *origine)
/* parcourir recursivement toutes les branches de l'arbre sans racine
a partir de centre et dans la direction opposee a son voisin origine
*/
{
if(centre==NULL) return;
if(centre->v1!=origine) {
	process_branche(centre,centre->v1,centre->l1);
	parcourir_branches(centre->v1,centre);
	}
if(centre->v2!=origine) {
	process_branche(centre,centre->v2,centre->l2);
	parcourir_branches(centre->v2,centre);
	}
if(centre->v3!=origine) {
	process_branche(centre,centre->v3,centre->l3);
	parcourir_branches(centre->v3,centre);
	}
}


void process_branche(struct noeud *cote1, struct noeud *cote2, double length)
/* calculer la prof moyenne des 2 cotes de la branche cote1<-->cote2
de longueur length
et memoriser la meilleure branche dans les variables globales
*/
{
double b1, b2, x, dist_root_side1, dist_root_side2, diff_betw_sides;

if(cote1==NULL || cote2==NULL) return;
b1=get_length_down(cote2,cote1);
b2=get_length_down(cote1,cote2);
if( fabs(length) > 1.e-5 )
	x=(b2-b1+length)/(2*length);
else
	x=0;
if(x<0) x=0;
if(x>1) x=1;
dist_root_side1=length*x+b1;
dist_root_side2=length*(1-x)+b2;
diff_betw_sides=fabs(dist_root_side1-dist_root_side2);
if(diff_betw_sides < current_best_diff ) {
	current_best_diff=diff_betw_sides;
	current_cote1=cote1;
	current_cote2=cote2;
	current_br_length=length;
	current_balance=x;
	}
}


double get_length_down(struct noeud *pere, struct noeud *racine)
/* compute the average length of the tree down a node */
{
if(racine == NULL) return 0.0;
else	{
	struct noeud *gauche, *droite;
	double bg,bd,lg,ld;
	if( racine->v1 == pere ) {
		gauche =racine->v2; droite = racine->v3;
		bg = (racine->l2); bd = (racine->l3);
		}
	else if( racine->v2 == pere ) {
		gauche =racine->v1; droite = racine->v3;
		bg = (racine->l1); bd = (racine->l3);
		}
	else	{
		gauche =racine->v1; droite = racine->v2;
		bg = (racine->l1); bd = (racine->l2);
		}
 	/* conserver cette ecriture sinon plante sur PC */
 	lg = ld = 0;
 	if(gauche != NULL) lg = get_length_down(racine,gauche);
 	lg += bg;
 	if(droite != NULL) ld = get_length_down(racine,droite);
 	ld += bd;
	return ((lg+ld)/2);
	}
}


void runtree(void)
{
double currx, curry;
int i;
struct noeud *p1, *p2;
double b1,b2,frac_gauche, aux;
if(!rooted) {
	/* place root at user-chosen place: node # root_num */
	rooted = !rooted;
	p1 = *(tabtax+root_num);
	p2 = p1->v3;
	root_br_l = p1->l3;
	p1->v3 = racine;
	if (p2->v1 == p1 )
		p2->v1 = racine;
	else if (p2->v2 == p1)
		p2->v2 = racine;
	else
		p2->v3 = racine;
	racine->v1=p1;
	racine->v2=p2;
	racine->v3=NULL;
	if(has_br_length) {
#define MAX_FRAC 0.95
		/* compute the average length of the 2 half trees : b1,b2 */
		b1 = get_length_down(racine,p1);
		b2 = get_length_down(racine,p2);
		/* divide the central branch in 2 parts to equilibrate tree */
		frac_gauche = (root_br_l+b2-b1)/(2*root_br_l);
		if(frac_gauche>MAX_FRAC) frac_gauche=MAX_FRAC;
		else if(frac_gauche<1-MAX_FRAC) frac_gauche=1-MAX_FRAC;
		b1 = frac_gauche*root_br_l;  b2 = root_br_l - b1;
		racine->l1=b1; racine->l2=b2;
#undef MAX_FRAC
		}
	else	{
		tree_bal(racine,p1,p2);
		}
	}
/* initialize leave and node names */
for(i = 0; i <= 2*notu; i++) tabnames[i][0] = 0;
if (choix == depl_racine)
	for(i=0; i<=2*notu-1; i++) sprintf(tabnames[i],"# ");
else if(choix == permutation)
	for(i=notu+1; i<=2*notu; i++) sprintf(tabnames[i],"#");
else if(choix == subtree)
	for(i=notu+1; i<=2*notu-1; i++) sprintf(tabnames[i],"#");

for(i=0; i<=notu; i++) {
	int j;
	j = strlen(tabnames[i]);
	strcpy(tabnames[i] + j, labels[i]);
	}

totnoms = tottraits = totpoints = -1;
end_br_length = br_length_txt;
currx = 0.;
maxx = 0.;
if(subtree_center != NULL)
	deltay = maxy / subtree_notu;
else
	deltay = maxy / notu;
nexty = -deltay;
widnames=0.0;
calc_text_size("Mq", &aux, &char_height);
if(subtree_center == NULL)
	mem_plot(NULL, racine, currx, &curry);
else
	mem_plot(subtree_ascend, subtree_center, currx, &curry);
converted = FALSE;
} /* end of runtree */


void mem_plot(struct noeud *pere, struct noeud *centre, double currx,
double *curry)
/* prepare tree by memorizing all graphic requests */
{
int num=0;
char *p;
struct noeud *gauche, *droite;
double bg, bd, bpere;

while( *(tabtax+num) != centre) num++;
if(pere != NULL && 
	(centre->v1 == NULL || centre->v2 == NULL || centre->v3 == NULL) ) {
	/* orienter le noeud centre de maniere standard: centre->v3=pere */
	if( centre->v1 == pere ) {
		gauche =centre->v2; droite = centre->v3;
		bg = centre->l2; bd = centre->l3; bpere = centre->l1;
		}
	else if( centre->v2 == pere ) {
		gauche =centre->v1; droite = centre->v3;
		bg = centre->l1; bd = centre->l3; bpere = centre->l2;
		}
	else	{
		gauche =centre->v1; droite = centre->v2;
		bg = centre->l1; bd = centre->l2; bpere = centre->l3;
		}
	centre->v3=pere; centre->v1=gauche; centre->v2=droite;
	centre->l3=bpere; centre->l1=bg; centre->l2=bd;
	/* write taxon name */
	nexty += deltay;
	mem_nom(currx,nexty,tabnames[num],'c');
	if(choix==depl_racine) mem_point(currx,nexty,num+1);
	*curry = nexty;
	}
else 	{
	double yg, yd, xg, xd;

	static int doswap;
	static struct noeud *tmp;
	/* doswap vrai ssi permutation de 2 descendants necessaire ici */
	doswap = (swap != 0 && *(tabtax+swap) == centre);
	if( centre->v1 == pere ) {
		if(doswap) {
			tmp= centre->v2;centre->v2= centre->v3;centre->v3= tmp;
			bg= centre->l2; centre->l2= centre->l3; centre->l3= bg;
			}
		gauche =centre->v2; droite = centre->v3;
		bg = centre->l2; bd = centre->l3; bpere = centre->l1;
		}
	else if( centre->v2 == pere ) {
		if(doswap) {
			tmp= centre->v1;centre->v1= centre->v3;centre->v3= tmp;
			bg= centre->l1; centre->l1= centre->l3; centre->l3= bg;
			}
		gauche =centre->v1; droite = centre->v3;
		bg = centre->l1; bd = centre->l3; bpere = centre->l2;
		}
	else	{
		if(doswap) {
			tmp= centre->v1;centre->v1= centre->v2;centre->v2= tmp;
			bg= centre->l1; centre->l1= centre->l2; centre->l2= bg;
			}
		gauche =centre->v1; droite = centre->v2;
		bg = centre->l1; bd = centre->l2; bpere = centre->l3;
		}
	/* orienter le noeud centre de maniere standard: centre->v3=pere */
	centre->v3=pere; centre->v1=gauche; centre->v2=droite;
	centre->l3=bpere; centre->l1=bg; centre->l2=bd;
	xg=currx+bg; xd=currx+bd;

	mem_plot(centre,gauche,xg,&yg);
	mem_plot(centre,droite,xd,&yd);

	mem_trait(currx,yg,xg,yg);
	mem_trait(currx,yd,xd,yd);
	mem_trait(currx,yg,currx,yd);
	*curry = (yg+yd)/2;

/* write internal labels */
	if(choix==show_tree && show_bootstrap) {
		if( (p=get_br_label(centre, gauche)) != NULL )
			mem_nom(currx,yg,p,'t');
		if( (p=get_br_label(centre, droite)) != NULL )
			mem_nom(currx,yd,p,'b');
		if(pere==NULL && (p=get_br_label(gauche, droite)) != NULL )
			mem_nom(currx,*curry,p,'c');
		}

/* write node number */
	mem_nom(currx,*curry,tabnames[num],'c');
	mem_point(currx,*curry,num+1);
	if(plot_br_l && has_br_length) {
/* write branch length */
		double min_br_l = 0.008; /* minimum branch length displayed */
		if(bg>min_br_l) {
			sprintf(end_br_length,"%.3f",bg);
			mem_nom(currx+bg/10,yg,end_br_length,'1');
			end_br_length += (strlen(end_br_length)+1);
			}
		if(bd>min_br_l) {
			sprintf(end_br_length,"%.3f",bd);
			mem_nom(currx+bd/10,yd,end_br_length,'1');
			end_br_length += (strlen(end_br_length)+1);
			}
		}
	}
}  /* end of mem_plot */

void mem_point(double x, double y, int number)
{
++totpoints;
(points+totpoints)->x = x;
(points+totpoints)->y = y;
(points+totpoints)->number = number;
}

void mem_nom(double x, double y, char *nom, char option)
/* x,y: logical coordinates of beginning of string 
   nom: address of string to be displayed later
   option: 'c' use for position of center of character height
           '1' put bottom of characters at y+1 pixel
	   't' use for position of top of character
	   'b' use for position of bottom of character
*/
{
if(strlen(nom)!=0) {
	int i;
	double width,height;
	totnoms++;
	if(x>maxx) maxx=x;
	(noms+totnoms)->x = x;
	(noms+totnoms)->y = y;
	(noms+totnoms)->nom = nom;
	(noms+totnoms)->disp_option = option;
	calc_text_size(nom,&width,&height);
	if(width>widnames)widnames=width;
	}
}


void mem_trait(double xd, double yd, double xf, double yf)
{
tottraits++;
if(xd>maxx) maxx=xd;
if(xf>maxx) maxx=xf;
(traits+tottraits)->xd = xd;
(traits+tottraits)->yd = yd;
(traits+tottraits)->xf = xf;
(traits+tottraits)->yf = yf;
}


char *get_br_label(struct noeud *a, struct noeud *b)
{
int i;
for(i=0; i<=totbranches; i++) {
	if(branches[i].bouta==a && branches[i].boutb==b) 
		return branches[i].br_label;
	if(branches[i].boutb==a && branches[i].bouta==b) 
		return branches[i].br_label;
	}
return NULL;
}


int get_br_from_bouts(struct noeud *a, struct noeud *b)
{
int i;
for(i=0; i<=totbranches; i++) {
	if(branches[i].bouta==a && branches[i].boutb==b) 
		return i;
	if(branches[i].boutb==a && branches[i].bouta==b) 
		return i;
	}
return -1;
}


void free_tree(void)
{
int i;
if(notu == 0) return;
/* de-allocate all memory */
for(i=0; i<2*notu+1; i++)
	free(tabtax[i]);
free(tabtax);
for(i=0; i<notu-2; i++)
	if(branches[i].br_label != NULL) free(branches[i].br_label);
free(branches);
for(i = 0; i < 2 * notu + 1; i++) free(tabnames[i]);
free(tabnames);
free(noms);
free(points);
free(traits);
for(i = 0; i < notu + 1; i++) free(labels[i]);
free(labels);
free(br_length_txt);
}


/* ecriture d'un arbre racine au format phylip */
void ecrit_arbre_parenth(struct noeud *root)
{
char *arbre, *fin, *p, mess[150];
int l, maxarbre = 1.5 * long_arbre_parenth;
FILE *out;

arbre=check_alloc( maxarbre+20,1);
fin=recur_ecrit_arbre(root,arbre,arbre+maxarbre-1);
/* ecriture du dernier label interne */
if( fin != NULL && (p=get_br_label(root->v1,root->v2)) != NULL ) {
	l=strlen(p);
	if(fin+l>=arbre+maxarbre) fin= NULL;
	else	{
		memcpy(fin+1,p,l);
		fin+=l;
		}
	}
if(fin!=NULL) {
	strcpy(fin+1,";");
	}
else	{
	free(arbre);
	err_message("Sorry, Not enough memory");
	return;
	}
out = fopen(rooted_fname,"w");
if(out != NULL) {
	fputs(arbre, out); putc('\n', out);
	fclose(out);
	}
else	{
	char mess[250];
	sprintf(mess, "Sorry, cannot write to file %s", 
		extract_filename(rooted_fname) );
	err_message(mess);
	}
free(arbre);
}


char *recur_ecrit_arbre(struct noeud *centre, char *arbre, char *finarbre)
{
int num, l;
char *p;

if(centre->v1==NULL && centre->v2==NULL) {
	num=0;
	while( *(tabtax+num) != centre) num++;
	l=strlen(tabnames[num]);
	if(arbre+l>=finarbre) return NULL;	
	memcpy(arbre,tabnames[num],l);
	arbre += l-1;
	}
else	{
	*arbre='(';
	arbre=recur_ecrit_arbre(centre->v1,arbre+1,finarbre);
	if(arbre==NULL) return NULL;
	if(has_br_length) {
		if(arbre+10>=finarbre) return NULL;
		sprintf(++arbre,":%.5f",centre->l1);
		while(*arbre!=0) arbre++;
		}
	else arbre++;
	*arbre=',';
	arbre=recur_ecrit_arbre(centre->v2,arbre+1,finarbre);
	if(arbre==NULL) return NULL;
	if(has_br_length) {
		if(arbre+10>=finarbre) return NULL;
		sprintf(++arbre,":%.5f",centre->l2);
		while(*arbre!=0) arbre++;
		}
	else arbre++;
	*arbre=')';
	/* ecriture des labels internes */
	if( (p=get_br_label(centre,centre->v3))!=NULL ) {
		l=strlen(p);
		if(arbre+l>=finarbre) return NULL;
		memcpy(arbre+1,p,l);
		arbre+=l;
		}
	}
return arbre;
}


void removeroot(void)
{
struct noeud *p1, *p2;
p1=racine->v1;
p2=racine->v2;
if(p1->v1 == racine )
	{p1->v1 = p2; p1->l1 = root_br_l;}
else if (p1->v2 == racine)
	{p1->v2 = p2; p1->l2 = root_br_l;}
else
	{p1->v3 = p2; p1->l3 = root_br_l;}
if(p2->v1 == racine )
	{p2->v1 = p1; p2->l1 = root_br_l;}
else if (p2->v2 == racine)
	{p2->v2 = p1; p2->l2 = root_br_l;}
else
	{p2->v3 = p1; p2->l3 = root_br_l;}
rooted = 0;
}


int myrint(double val)
{
if(val >= 0)
	return (int)(val + 0.5);
else
	return (int)(val - 0.5);
}


int calc_n_desc(struct noeud *pere)
{
if(pere->v1 == NULL) return 1;
else return calc_n_desc(pere->v1) + calc_n_desc(pere->v2);
}


void majuscules(char *p)
{
while(*p != 0) {*p = toupper(*p); p++;}
}
