/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: strsrc5.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $
*****************************************************************************/

static char Psz_RCS [] =
   "$Id: strsrc5.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $";

/****************************************************************************/

#include <mcl/util/strutil.hpp>


/****************************************************************************/
/** Search the pattern in a stream and put data read to strOut,
*** stops to read when pattern is found.
*** The pattern is not written to strOut.
***
*\C Parameters:
*\P   pcszPattern  IN - String to search
*\P   isIStream    IN - Stream to read from
*\P   strOut       IN - String to write to
*\P   iMaxLen      IN - Put not more than iMaxLen chars in strOut, discard
***                     the remaining
***
*\C Returns:
*\R   FALSE if not found
*\R   TRUE  if found
*****************************************************************************/
BOOL MclStrSearchSkip (PCSZ pcszPattern, istream & isIStream,
                       STRING & strOut, INT iMaxLen)
   {
   *Psz_RCS = *Psz_RCS;                 // To fake compiler warnings

   INT   iPattLen;
   INT * piNext;
   INT   i, j, k;
   CHAR  chData;

   if ((pcszPattern == NULL) || isIStream.fail ())
      {
      return (FALSE);
      }

   strOut = "";
   iPattLen = strlen (pcszPattern);

   piNext = new INT[iPattLen+1];

   if (piNext == NULL)
      {
      return (FALSE);
      }

   //*************************************************************************
   // Init piNext
   //*************************************************************************
   piNext [0] = -1;
   for (i = 0, j = -1; (i < iPattLen); ++i, ++j, piNext[i] = j)
      {
      while ((j >= 0) && (pcszPattern [i] != pcszPattern [j]))
         {
         j = piNext [j];
         }
      }

   //*************************************************************************
   // Search
   //*************************************************************************
   isIStream.get (chData);
   for (j = 0; (j < iPattLen) && !isIStream.fail (); ++j)
      {
      while ((j >= 0) && (chData != pcszPattern[j]))
         {
         if (piNext[j] != -1)
            {
            for (k = 0; (k < j - piNext[j]) && (iMaxLen != 0); ++k)
               {
               strOut += pcszPattern[k];
               --iMaxLen;
               }
            }
         j = piNext[j];
         }

      if ((j == -1) && (iMaxLen != 0))
         {
         strOut += chData;
         }
      isIStream.get (chData);
      }

   if (!isIStream.fail ())
      {
      isIStream.unget (chData);
      }

   delete [] piNext;

   return (j == iPattLen);
   }

