/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.tok;

import com.thaiopensource.xml.tok.InvalidTokenException;
import com.thaiopensource.xml.tok.Token;

public class ContentToken
extends Token {
    private static final int INIT_ATT_COUNT = 8;
    private int attCount = 0;
    private int[] attNameStart = new int[8];
    private int[] attNameEnd = new int[8];
    private int[] attValueStart = new int[8];
    private int[] attValueEnd = new int[8];
    private boolean[] attNormalized = new boolean[8];

    public final int getAttributeSpecifiedCount() {
        return this.attCount;
    }

    public final int getAttributeNameStart(int n) {
        if (n >= this.attCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attNameStart[n];
    }

    public final int getAttributeNameEnd(int n) {
        if (n >= this.attCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attNameEnd[n];
    }

    public final int getAttributeValueStart(int n) {
        if (n >= this.attCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attValueStart[n];
    }

    public final int getAttributeValueEnd(int n) {
        if (n >= this.attCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attValueEnd[n];
    }

    public final boolean isAttributeNormalized(int n) {
        if (n >= this.attCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attNormalized[n];
    }

    final void clearAttributes() {
        this.attCount = 0;
    }

    final void appendAttribute(int n, int n2, int n3, int n4, boolean bl) {
        if (this.attCount == this.attNameStart.length) {
            this.attNameStart = ContentToken.grow(this.attNameStart);
            this.attNameEnd = ContentToken.grow(this.attNameEnd);
            this.attValueStart = ContentToken.grow(this.attValueStart);
            this.attValueEnd = ContentToken.grow(this.attValueEnd);
            this.attNormalized = ContentToken.grow(this.attNormalized);
        }
        this.attNameStart[this.attCount] = n;
        this.attNameEnd[this.attCount] = n2;
        this.attValueStart[this.attCount] = n3;
        this.attValueEnd[this.attCount] = n4;
        this.attNormalized[this.attCount] = bl;
        ++this.attCount;
    }

    final void checkAttributeUniqueness(char[] cArray) throws InvalidTokenException {
        for (int i = 1; i < this.attCount; ++i) {
            int n = this.attNameEnd[i] - this.attNameStart[i];
            for (int j = 0; j < i; ++j) {
                if (this.attNameEnd[j] - this.attNameStart[j] != n) continue;
                int n2 = n;
                int n3 = this.attNameStart[i];
                int n4 = this.attNameStart[j];
                do {
                    if (--n2 >= 0) continue;
                    throw new InvalidTokenException(this.attNameStart[i], 2);
                } while (cArray[n3++] == cArray[n4++]);
            }
        }
    }

    private static final int[] grow(int[] nArray) {
        int[] nArray2 = nArray;
        nArray = new int[nArray2.length << 1];
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        return nArray;
    }

    private static final boolean[] grow(boolean[] blArray) {
        boolean[] blArray2 = blArray;
        blArray = new boolean[blArray2.length << 1];
        System.arraycopy(blArray2, 0, blArray, 0, blArray2.length);
        return blArray;
    }
}

